/*
    This file is part of KOrganizer.
    Copyright (c) 2000,2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/
#ifndef KOPREFS_H
#define KOPREFS_H

#include <qdict.h>

#include <libkdepim/kpimprefs.h>

class KConfig;
class QFont;
class QColor;
class QStringList;

class KOPrefs : public KPimPrefs
{
  public:
    enum { FormatVCalendar, FormatICalendar };
    enum { MailClientKMail, MailClientSendmail };
    enum { IMIPDummy, IMIPKMail };
    enum { IMIPOutbox, IMIPdirectsend };
    enum { neverAuto, addressbookAuto, selectedAuto };
    enum { standardDestination, askDestination };

    virtual ~KOPrefs();

    /** Get instance of KOPrefs. It is made sure that there is only one
    instance. */
    static KOPrefs *instance();

    /** Set preferences to default values */
    void usrSetDefaults();

    /** Read preferences from config file */
    void usrReadConfig();

    /** Write preferences to config file */
    void usrWriteConfig();
    void setCategoryDefaults();

  protected:
    void setTimeZoneIdDefault();

    /** Fill empty mail fields with default values. */
    void fillMailDefaults();

  private:
    /** Constructor disabled for public. Use instance() to create a KOPrefs
    object. */
    KOPrefs();

    static KOPrefs *mInstance;
    QDict<QString> *mLocaleDict;
    QStringList getDefaultList();
  public:
    // preferences data
    KConfig* getConfig();
    void setFullName(const QString &);
    QString fullName();
    void setEmail(const QString &);
    QString email();

    QString mAdditional;

    bool    mEmailControlCenter;

    bool    mBcc;
    bool    mAutoSave;
    int     mAutoSaveInterval;
    bool    mConfirm;

    bool    mEnableGroupScheduling;
    bool    mEnableProjectView;

    int     mDefaultFormat;
    int     mMailClient;

    QString mTimeZone;
    QString mTimeZoneId;
    //QString mTimeZoneName; // e.g. +00:04:00 Indian/Mauritius
    //int     mTimeZoneOffset; // e.g. -240 min
    bool    mUseDaylightsaving;
    int     mDaylightsavingStart;
    int     mDaylightsavingEnd;
    int     mStartTime;
    int     mDefaultDuration;
    int     mAlarmTime;
    int     mDaylightSavings;

    int     mWorkingHoursStart;
    int     mWorkingHoursEnd;
    bool    mExcludeHolidays;
    bool    mExcludeSaturdays;
    bool    mMarcusBainsShowSeconds;

    QFont   mTimeBarFont;
    QFont   mMonthViewFont;
    QFont   mAgendaViewFont;
    QFont   mMarcusBainsFont;
    QFont   mTimeLabelsFont;
    QFont   mTodoViewFont;
    QFont   mListViewFont;
    QFont   mDateNavigatorFont;
    QFont   mEditBoxFont;
    QFont   mJornalViewFont;
    QFont   mWhatsNextFont;
    QFont   mEventViewFont;




    QColor  mHolidayColor;
    QColor  mHighlightColor;
    QColor  mEventColor;
    QColor  mAgendaBgColor;
    QColor  mWorkingHoursColor;
    QColor  mTodoDueTodayColor;
    QColor  mTodoOverdueColor;
    QColor  mMonthViewEvenColor;
    QColor  mMonthViewOddColor;
    QColor  mMonthViewHolidayColor;
    bool mMonthViewUsesDayColors;
    bool mMonthViewSatSunTog;
    QColor  mAppColor1;
    QColor  mAppColor2;
    bool mUseAppColors;

    int     mDayBegins;
    int     mHourSize;
    int     mAllDaySize;
    bool    mShowFullMenu;
    bool    mDailyRecur;
    bool    mWeeklyRecur;
    bool    mMonthDailyRecur;
    bool    mMonthWeeklyRecur;
    bool    mMonthShowIcons;
    bool    mMonthShowShort;
    bool    mEnableToolTips;
    bool    mEnableMonthScroll;
    bool    mFullViewMonth;
    bool    mMonthViewUsesCategoryColor;
    bool    mFullViewTodo;
    bool    mShowCompletedTodo;
    bool    mMarcusBainsEnabled;
    int     mNextXDays;
    int     mWhatsNextDays;
    int     mWhatsNextPrios;
    bool    mEnableQuickTodo;
    bool    mLanguageChanged;

    bool    mCompactDialogs;
    bool    mVerticalScreen;

    bool mShowIconNewTodo;
    bool mShowIconNewEvent;
    bool mShowIconSearch;
    bool mShowIconList;
    bool mShowIconDay1;
    bool mShowIconDay5;
    bool mShowIconDay7;
    bool mShowIconMonth;
    bool mShowIconTodoview;
    bool mShowIconBackFast;
    bool mShowIconBack;
    bool mShowIconToday;
    bool mShowIconForward;
    bool mShowIconForwardFast;
    bool mShowIconWhatsThis;
    bool mShowIconNextDays;
    bool mShowIconNext;
    bool mShowIconJournal;
    
    bool mShowIconStretch;

    bool mToolBarHor;
    bool mToolBarUp;
    bool mToolBarMiniIcons;

    bool mAskForQuit;
    bool mUsePassWd;
    bool mWriteBackFile;
    bool mAskForPreferences;
    bool mShowSyncSummary;
    bool mShowSyncEvents;
    bool mWriteBackExistingOnly;

    QString mRemoteIP;
    QString mRemoteUser;
    QString mRemotePassWd;
    QString mRemoteFile;
    QString mLocalTempFile;

    int mLastSyncTime;
    int mSyncAlgoPrefs;
    int mRingSyncAlgoPrefs;
    QStringList mSyncProfileNames;
    QString mLocalMachineName;
    void setCategoryColor(QString cat,const QColor & color);
    QColor *categoryColor(QString cat);

    QString mArchiveFile;
    QString mHtmlExportFile;
    bool    mHtmlWithSave;

    QStringList mSelectedPlugins;
  
    QString mLastImportFile;
    QString mLastVcalFile;
    QString mLastSaveFile;
    QString mLastLoadFile;
    QString mLastSyncedLocalFile;


    QString mDefaultAlarmFile;
    int mIMIPScheduler;
    int mIMIPSend;
    QStringList mAdditionalMails;
    int mIMIPAutoRefresh;
    int mIMIPAutoInsertReply;
    int mIMIPAutoInsertRequest;
    int mIMIPAutoFreeBusy;
    int mIMIPAutoFreeBusyReply;

    QStringList mTodoTemplates;
    QStringList mEventTemplates;

    int mDestination;


    bool mEditOnDoubleClick;
    bool mViewChangeHoldFullscreen;
    bool mViewChangeHoldNonFullscreen;
    bool mCenterOnCurrentTime;
    bool mSetTimeToDayStartAt;
    bool mHighlightCurrentDay;
    bool mUseHighlightLightColor;
    bool mListViewMonthTimespan;
    bool mWNViewShowsParents;
    bool mWNViewShowLocation;
    bool mTodoViewShowsPercentage;
    bool mTodoViewUsesCatColors;
    bool mTodoViewUsesSmallFont;
    bool mTodoViewUsesForegroundColor;
    bool mMonthViewUsesForegroundColor;

    bool mHightlightDateTimeEdit;
    int mPreferredLanguage;
    bool mUseQuicksave;
    int mPreferredTime;
    int mPreferredDate;
    bool mWeekStartsOnSunday;
    bool mShortDateInViewer;
    QString mUserDateFormatLong;
    QString mUserDateFormatShort;

    QStringList mLocationDefaults;
    QStringList mEventSummaryUser;
    QStringList mTodoSummaryUser;

    bool mUseInternalAlarmNotification;
    int mAlarmPlayBeeps;
    int mAlarmSuspendTime;
    int mAlarmSuspendCount;
    int mAlarmBeepInterval;

  private:
    QDict<QColor> mCategoryColors;
    QColor mDefaultCategoryColor;

    QFont mDefaultTimeBarFont;
    QFont mDefaultViewFont;
    QFont mDefaultMonthViewFont;

    QString mName;
    QString mEmail;
};

#endif
