/*
    This file is part of KOrganizer.
    Copyright (c) 2004 Lutz Rogowski <rogowski@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

// $Id: kprefs.cpp,v 1.3 2002/11/30 03:00:10 cschumac Exp $

#include <qcolor.h>

#include <kconfig.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kdebug.h>

#include "ksyncprofile.h"


KSyncProfile::KSyncProfile( const char * name)
{
    setDefault(); 
}
KSyncProfile::~KSyncProfile()
{

}


KSyncProfile* KSyncProfile::clone()
{
    KSyncProfile* myClone = new KSyncProfile();
    myClone->setPreSyncCommand( mPreSyncCommand );
    myClone->setPostSyncCommand( mPostSyncCommand );
    myClone->setLocalTempFile( mLocalTempFile);
    myClone->setRemoteFileName( mRemoteFileName );
    myClone->setShowSummaryAfterSync( mShowSummaryAfterSync );
    myClone->setAskForPreferences( mAskForPreferences);
    myClone->setWriteBackExisting(mWriteBackExisting );
    myClone->setWriteBackFile( mWriteBackFile);
    myClone->setIncludeInRingSync( mIncludeInRingSync );
    myClone->setSyncPrefs( mSyncPrefs);
    myClone->setIsLocalFileSync( mIsLocalFileSync );
    myClone->setName( "noName" );
    return myClone;
}


void KSyncProfile::setDefault()
{
    mName = "noName";
    mPreSyncCommand = i18n("command for downloading remote file to local device");
    mPostSyncCommand = i18n("command for uploading local temp file to remote device");
    mLocalTempFile = "/tmp/mycalendar.ics";
    mRemoteFileName = "/home/polo/Applications/korganizer/localfile.ics";
    mShowSummaryAfterSync = true;
    mAskForPreferences = true;
    mWriteBackExisting = false;
    mWriteBackFile = true;
    mIncludeInRingSync = false;
    mSyncPrefs = SYNC_PREF_ASK;
    mIsLocalFileSync = true;

}
void KSyncProfile::readConfig(KConfig *config )
{
    config->setGroup("SyncProfiles");
    QString prefix = "Profile_"+mName+"_";
    //mName = config->readEntry( prefix+ "Name", mName );
    mPreSyncCommand = config->readEntry( prefix+ "PreSyncCommand",mPreSyncCommand  );
    mPostSyncCommand = config->readEntry( prefix+ "PostSyncCommand", mPostSyncCommand );
    mIncludeInRingSync = config->readBoolEntry( prefix+ "IncludeInRingSync",mIncludeInRingSync  );
    mLocalTempFile = config->readEntry( prefix+ "LocalTempFile", mLocalTempFile );
    mRemoteFileName = config->readEntry( prefix+ "RemoteFileName", mRemoteFileName );
    mShowSummaryAfterSync = config->readBoolEntry( prefix+ "ShowSummaryAfterSync", mShowSummaryAfterSync );
    mAskForPreferences = config->readBoolEntry( prefix+ "AskForPreferences",mAskForPreferences  );
    mWriteBackExisting = config->readBoolEntry( prefix+ "WriteBackExisting",mWriteBackExisting  );
    mSyncPrefs = config->readNumEntry( prefix+ "SyncPrefs", mSyncPrefs );
    mIsLocalFileSync= config->readBoolEntry( prefix+ "IsLocalFileSync", mIsLocalFileSync );
}
void KSyncProfile::writeConfig( KConfig * config )
{
    config->setGroup("SyncProfiles");
    QString prefix = "Profile_"+mName+"_";
    // config->writeEntry( prefix+ "Name", mName );
    config->writeEntry( prefix+ "PreSyncCommand",mPreSyncCommand  );
    config->writeEntry( prefix+ "PostSyncCommand", mPostSyncCommand );
    config->writeEntry( prefix+ "IncludeInRingSync",mIncludeInRingSync  );
    config->writeEntry( prefix+ "LocalTempFile", mLocalTempFile );
    config->writeEntry( prefix+ "RemoteFileName", mRemoteFileName );
    config->writeEntry( prefix+ "ShowSummaryAfterSync", mShowSummaryAfterSync );
    config->writeEntry( prefix+ "AskForPreferences",mAskForPreferences  );
    config->writeEntry( prefix+ "WriteBackExisting",mWriteBackExisting  );
    config->writeEntry( prefix+ "SyncPrefs", mSyncPrefs );
    config->writeEntry( prefix+ "IsLocalFileSync", mIsLocalFileSync );
}

/*
class KPrefsItemInt : public KPrefsItem {
  public:
    KPrefsItemInt(const QString &group,const QString &name,int *,int defaultValue=0);
    virtual ~KPrefsItemInt() {}
    
    void setDefault();
    void readConfig(KConfig *);
    void writeConfig(KConfig *);

  private:
    int *mReference;
    int mDefault;
};
*/
