#include "kcolorbutton.h"
#include "kcolordialog.h"

#include "qapplication.h"
#ifdef DESKTOP_VERSION
#include <qcolordialog.h>
#endif

#include "qlayout.h"

void KColorButton:: edit()
{
#ifndef DESKTOP_VERSION
    KColorDialog* k =  new KColorDialog( this );
    k->setColor( mColor );
    int res = k->exec();
    if ( res ) {
        mColor = k->getColor(); 
        setColor ( mColor );
        emit changed ( mColor );
    }
    delete k;
#else
    QColor c  = QColorDialog::getColor ( mColor ); 
    if ( c.isValid() ) {
        mColor = c;
        setColor ( mColor );
        emit changed ( mColor );
    }
#endif
}
KColorButton::KColorButton( QWidget *p ):QPushButton( p )
{
    int size = 24;
    if(  QApplication::desktop()->width() < 480 )
        size = 18;
    setFixedSize( size,size );
    connect ( this, SIGNAL( clicked() ), this ,SLOT (edit() ));
    
}
void KColorButton::setColor ( const QColor & c) 
{
 mColor = c; 
 QPixmap pix ( height() - 4, width() - 4 );
 pix.fill( c );
 setPixmap ( pix );
}
