/*
 *  linux/drivers/bootldr/labcopyymodem.c
 *
 *  Copyright (C) 2003 Joshua Wise
 *  Bootloader port to Linux Kernel, May 09, 2003
 *
 *  ymodem module for LAB "copy" command.
 */

#include <linux/bootldr/copy.h>
#include <linux/stat.h>
#include <linux/slab.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>

extern char* lab_ymodem_receive( unsigned int* length);


static int getcheck(char* filename)
{
	if (*filename != '\0')
		return 0;
	return 1;
};

static unsigned char* get(int* count, char* filename)
{
	if (*filename != '\0')
		return 0;
	return lab_ymodem_receive(count);
};

int labcopyymodem_init(void)
{
	lab_copy_addsrc("ymodem",getcheck,get);
};

void labcopyymodem_cleanup(void)
{	
};

MODULE_AUTHOR("Joshua Wise");
MODULE_DESCRIPTION("LAB copy ymodem module");
MODULE_LICENSE("GPL");
module_init(labcopyymodem_init);
module_exit(labcopyymodem_cleanup);