/*
 * $Id: mq1100.h,v 1.3 2003/10/06 09:04:57 florian Exp $
 *
 * Copyright © 2003 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _MQ1100_H_
#define _MQ1100_H_

#ifndef MQ1100FB_DEBUG
#define MQ1100FB_DEBUG 0
#endif

#ifdef __KERNEL__
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/tty.h>
#include <linux/slab.h>
#include <linux/delay.h>
#include <linux/fb.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/pm.h>

#include <video/fbcon.h>
#include <video/fbcon-cfb16.h>

#if MQ1100FB_DEBUG
#define debug(f,a...)	printk("%s:" f,  __FUNCTION__ , ## a)
#else
#define debug(f,a...)
#endif

#define output(f, a...) printk("mq1100fb: " f, ## a)
#else

#define debug(f,a...)	printf("%s:" f, __FUNCTION__, ## a)
#define output(f, a...) printf(f, ##a)
#endif

typedef unsigned char	mq8;
typedef unsigned short	mq16;
typedef unsigned int	mq32;
typedef short		mqs16;

#define count(t)    ((sizeof (t) / sizeof (t[0])))

void mq1100_backlight_level(unsigned char level);

typedef struct _mqReg {
    /*
     * CPU Interface (CC) Module	    0x000
     */
    union {
	struct {
	    mq32    cpu_control;
#define MQ_CPU_CONTROL_MIU_READ_REQUEST_GENERATOR_ON			(1 << 0)
#define MQ_CPU_CONTROL_DISBABLE_FB_READ_CACHE				(1 << 1)
#define MQ_CPU_CONTROL_ENABLE_CLKRUN					(1 << 3)
#define MQ_CPU_CONTROL_GPIO_SOURCE_DATA_SELECT				(3 << 4)
#define MQ_CPU_CONTROL_CPU_INTERFACE_GPIO_DATA				(3 << 6)
	    mq32    fifo_status;
#define MQ_CPU_COMMAND_FIFO(s)						(((s) >> 0) & 0x1f)
#define MQ_CPU_SOURCE_FIFO(s)						(((s) >> 8) & 0x1f)
#define MQ_CPU_GE_BUSY							(1 << 16)
	    mq32    gpio_control_0;
	    mq32    gpio_control_1;
	    mq32    cpu_test_mode;
	} s;
	mq32	a[6];
	mq8	size[128];
    } CC;
    /*
     * Memory Interface Unit Controller    0x080
     */
    union {
	struct {
	    mq32	miu_1;
#define MQ_MIU_ENABLE						    (1 << 0)
#define MQ_MIU_RESET_ENABLE					    (1 << 1)
	    mq32	miu_2;
#define MQ_MIU_MEMORY_CLOCK_SOURCE_BUS				    (1 << 0)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER				    (7 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_1				    (0 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_1_5				    (1 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_2				    (2 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_2_5				    (3 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_3				    (4 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_4				    (5 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_5				    (6 << 2)
#define MQ_MIU_MEMORY_CLOCK_DIVIDER_6				    (7 << 2)
#define MQ_MIU_DISPLAY_BURST_COUNT				    (3 << 5)
#define MQ_MIU_DISPLAY_BURST_COUNT_2				    (0 << 5)
#define MQ_MIU_DISPLAY_BURST_COUNT_4				    (1 << 5)
#define MQ_MIU_DISPLAY_BURST_COUNT_6				    (2 << 5)
#define MQ_MIU_DISPLAY_BURST_COUNT_8				    (3 << 5)
#define MQ_MIU_GRAPHICS_ENGINE_BURST_COUNT	    		    (3 << 7)
#define MQ_MIU_GRAPHICS_ENGINE_BURST_COUNT_2	    		    (0 << 7)
#define MQ_MIU_GRAPHICS_ENGINE_BURST_COUNT_4	    		    (1 << 7)
#define MQ_MIU_GRAPHICS_ENGINE_BURST_COUNT_6	    		    (2 << 7)
#define MQ_MIU_GRAPHICS_ENGINE_BURST_COUNT_8	    		    (3 << 7)
#define MQ_MIU_CPU_BURST_COUNT					    (3 << 9)
#define MQ_MIU_CPU_BURST_COUNT_2	    			    (0 << 9)
#define MQ_MIU_CPU_BURST_COUNT_4	    			    (1 << 9)
#define MQ_MIU_CPU_BURST_COUNT_6	    			    (2 << 9)
#define MQ_MIU_CPU_BURST_COUNT_8	    			    (3 << 9)
#define MQ_MIU_I2S_BURST_COUNT					    (3 << 11)
#define MQ_MIU_I2S_BURST_COUNT_2    				    (0 << 11)
#define MQ_MIU_I2S_BURST_COUNT_4    				    (1 << 11)
#define MQ_MIU_I2S_BURST_COUNT_6    				    (2 << 11)
#define MQ_MIU_I2S_BURST_COUNT_8    				    (3 << 11)
#define MQ_MIU_USB_BURST_COUNT					    (3 << 13)
#define MQ_MIU_USB_BURST_COUNT_2    				    (0 << 13)
#define MQ_MIU_USB_BURST_COUNT_4    				    (1 << 13)
#define MQ_MIU_USB_BURST_COUNT_6    				    (2 << 13)
#define MQ_MIU_USB_BURST_COUNT_8    				    (3 << 13)
#define MQ_MIU_GCI_FIFO_THRESHOLD				    (0xf << 16)
#define MQ_MIU_GCI_FIFO_THRESHOLD_(v)				    ((v) << 16)
#define MQ_MIU_GRAPHICS_ENGINE_SRC_READ_THRESHOLD		    (7 << 20)
#define MQ_MIU_GRAPHICS_ENGINE_SRC_READ_THRESHOLD_(v)		    ((v) << 20)
#define MQ_MIU_GRAPHICS_ENGINE_DST_READ_THRESHOLD		    (7 << 23)
#define MQ_MIU_GRAPHICS_ENGINE_DST_READ_THRESHOLD_(v)		    ((v) << 23)
#define MQ_MIU_I2S_TRANSMIT_THRESHOLD				    (7 << 26)
#define MQ_MIU_I2S_TRANSMIT_THRESHOLD_(v)    			    ((v) << 26)
	    mq32	miu_test_control;
	} s;
	mq32	a[6];
	mq8	size[128];
    } MIU;
    /* 
     * Interrupt Controller	    0x100
     */
    union {
	struct {
	    mq32    global_interrupt_control;
#define MQ_INTERRUPT_CONTROL_INTERRUPT_ENABLE			    (1 << 0)
#define MQ_INTERRUPT_CONTROL_INTERRUPT_POLARITY			    (1 << 1)
#define MQ_INTERRUPT_CONTROL_GPIO_0_INTERRUPT_POLARITY		    (1 << 2)
#define MQ_INTERRUPT_CONTROL_GPIO_1_INTERRUPT_POLARITY		    (1 << 3)
#define MQ_INTERRUPT_CONTROL_GPIO_2_INTERRUPT_POLARITY		    (1 << 4)
	    mq32    interrupt_mask;
#define MQ_INTERRUPT_MASK_VSYNC_RISING				    (1 << 0)
#define MQ_INTERRUPT_MASK_VSYNC_FALLING				    (1 << 1)
#define MQ_INTERRUPT_MASK_VENABLE_RISING			    (1 << 2)
#define MQ_INTERRUPT_MASK_VENABLE_FALLING			    (1 << 3)
#define MQ_INTERRUPT_MASK_BUS_CYCLE_ABORT			    (1 << 4)
#define MQ_INTERRUPT_MASK_GPIO_0				    (1 << 5)
#define MQ_INTERRUPT_MASK_GPIO_1				    (1 << 6)
#define MQ_INTERRUPT_MASK_GPIO_2				    (1 << 7)
#define MQ_INTERRUPT_MASK_COMMAND_FIFO_HALF_EMPTY    		    (1 << 8)
#define MQ_INTERRUPT_MASK_COMMAND_FIFO_EMPTY			    (1 << 9)
#define MQ_INTERRUPT_MASK_SOURCE_FIFO_HALF_EMPTY	    	    (1 << 10)
#define MQ_INTERRUPT_MASK_SOURCE_FIFO_EMPTY			    (1 << 11)
#define MQ_INTERRUPT_MASK_GRAPHICS_ENGINE_IDLE			    (1 << 12)
#define MQ_INTERRUPT_MASK_USB_HOST_GLOBAL_SUSPEND_MODE		    (1 << 13)
#define MQ_INTERRUPT_MASK_USB_HOST_REMOTE_WAKE_UP    		    (1 << 14)
#define MQ_INTERRUPT_MASK_USB_HOST				    (1 << 15)
#define MQ_INTERRUPT_MASK_USB_DEVICE				    (1 << 16)
#define MQ_INTERRUPT_MASK_I2S					    (1 << 17)
#define MQ_INTERRUPT_MASK_SPI					    (1 << 18)
#define MQ_INTERRUPT_MASK_USB_DEVICE_WAKE_UP			    (1 << 19)
	    mq32    interrupt_status;
#define MQ_INTERRUPT_STATUS_VSYNC_RISING			    (1 << 0)
#define MQ_INTERRUPT_STATUS_VSYNC_FALLING			    (1 << 1)
#define MQ_INTERRUPT_STATUS_VENABLE_RISING			    (1 << 2)
#define MQ_INTERRUPT_STATUS_VENABLE_FALLING			    (1 << 3)
#define MQ_INTERRUPT_STATUS_BUS_CYCLE_ABORT			    (1 << 4)
#define MQ_INTERRUPT_STATUS_GPIO_0				    (1 << 5)
#define MQ_INTERRUPT_STATUS_GPIO_1				    (1 << 6)
#define MQ_INTERRUPT_STATUS_GPIO_2				    (1 << 7)
#define MQ_INTERRUPT_STATUS_COMMAND_FIFO_HALF_EMPTY    		    (1 << 8)
#define MQ_INTERRUPT_STATUS_COMMAND_FIFO_EMPTY			    (1 << 9)
#define MQ_INTERRUPT_STATUS_SOURCE_FIFO_HALF_EMPTY	    	    (1 << 10)
#define MQ_INTERRUPT_STATUS_SOURCE_FIFO_EMPTY			    (1 << 11)
#define MQ_INTERRUPT_STATUS_GRAPHICS_ENGINE_IDLE		    (1 << 12)
#define MQ_INTERRUPT_STATUS_USB_HOST_GLOBAL_SUSPEND_MODE	    (1 << 13)
#define MQ_INTERRUPT_STATUS_USB_HOST_REMOTE_WAKE_UP    		    (1 << 14)
#define MQ_INTERRUPT_STATUS_USB_HOST				    (1 << 15)
#define MQ_INTERRUPT_STATUS_USB_DEVICE				    (1 << 16)
#define MQ_INTERRUPT_STATUS_I2S					    (1 << 17)
#define MQ_INTERRUPT_STATUS_SPI					    (1 << 18)
#define MQ_INTERRUPT_STATUS_USB_DEVICE_WAKE_UP			    (1 << 19)
	} s;
	mq8	size[128];
    } IC;
    /*
     * Graphics Controller	    0x180
     */
    union {
	struct {
	    mq32    control;
#define MQ_GC_CONTROL_ENABLE					    (1 << 0)
#define MQ_GC_HORIZONTAL_COUNTER_RESET				    (1 << 1)
#define MQ_GC_VERTICAL_COUNTER_RESET				    (1 << 2)
#define MQ_GC_IMAGE_WINDOW_ENABLE				    (1 << 3)
#define MQ_GC_DEPTH						    (0xf << 4)
#define MQ_GC_DEPTH_PSEUDO_1					    (0x0 << 4)
#define MQ_GC_DEPTH_PSEUDO_2					    (0x1 << 4)
#define MQ_GC_DEPTH_PSEUDO_4					    (0x2 << 4)
#define MQ_GC_DEPTH_PSEUDO_8					    (0x3 << 4)
#define MQ_GC_DEPTH_GRAY_1					    (0x8 << 4)
#define MQ_GC_DEPTH_GRAY_2					    (0x9 << 4)
#define MQ_GC_DEPTH_GRAY_4					    (0xa << 4)
#define MQ_GC_DEPTH_GRAY_8					    (0xb << 4)
#define MQ_GC_DEPTH_TRUE_16					    (0xc << 4)
#define MQ_GC_HARDWARE_CURSOR_ENABLE				    (1 << 8)
#define MQ_GC_DOUBLE_BUFFER_CONTROL				    (3 << 10)
#define MQ_GC_X_SCANNING_DIRECTION				    (1 << 12)
#define MQ_GC_LINE_SCANNING_DIRECTION				    (1 << 13)
#define MQ_GC_HORIZONTAL_DOUBLING				    (1 << 14)
#define MQ_GC_VERTICAL_DOUBLING					    (1 << 15)
#define MQ_GC_GRCLK_SOURCE					    (3 << 16)
#define MQ_GC_GRCLK_SOURCE_BUS					    (0 << 16)
#define MQ_GC_GRCLK_SOURCE_FIRST    				    (1 << 16)
#define MQ_GC_GRCLK_SOURCE_SECON    				    (2 << 16)
#define MQ_GC_GRCLK_SOURCE_THIRD    				    (3 << 16)
#define MQ_GC_ENABLE_TEST_MODE					    (1 << 18)
#define MQ_GC_ENABLE_POLY_SI_TFT				    (1 << 19)
#define MQ_GC_GMCLK_FIRST_DIVISOR				    (7 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_1				    (0 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_1_5				    (1 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_2_5				    (2 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_3_5				    (3 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_4_5				    (4 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_5_5				    (5 << 20)
#define MQ_GC_GMCLK_FIRST_DIVISOR_6_5				    (6 << 20)
#define MQ_GC_GMCLK_SECOND_DIVISOR				    (0xf << 24)
#define MQ_GC_GMCLK_SECOND_DIVISOR_(v)				    ((v) << 24)
#define MQ_GC_SHARP_160x160_HR_TFT_ENABLE    			    (1 << 31)
	    mq32    power_sequencing;
#define MQ_GC_POWER_UP_INTERVAL					    (7 << 0)
#define MQ_GC_POWER_UP_INTERVAL_1	    			    (0 << 0)
#define MQ_GC_POWER_UP_INTERVAL_2	    			    (1 << 0)
#define MQ_GC_POWER_UP_INTERVAL_4	    			    (2 << 0)
#define MQ_GC_POWER_UP_INTERVAL_8	    			    (3 << 0)
#define MQ_GC_POWER_UP_INTERVAL_16    				    (4 << 0)
#define MQ_GC_POWER_UP_INTERVAL_32    				    (5 << 0)
#define MQ_GC_POWER_UP_INTERVAL_48    				    (6 << 0)
#define MQ_GC_POWER_UP_INTERVAL_64    				    (7 << 0)
#define MQ_GC_FAST_POWER_UP					    (1 << 3)
#define MQ_GC_POWER_DOWN_INTERVAL				    (1 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_1	    			    (0 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_2	    			    (1 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_4	    			    (2 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_8	    			    (3 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_16    		    	    (4 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_32    		    	    (5 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_48    		    	    (6 << 4)
#define MQ_GC_POWER_DOWN_INTERVAL_64    		    	    (7 << 4)
#define MQ_GC_FAST_POWER_DOWN					    (1 << 7)
	    mq32    horizontal_display;
#define MQ_GC_HORIZONTAL_DISPLAY_TOTAL				    (0x7ff << 0)
#define MQ_GC_HORIZONTAL_DISPLAY_TOTAL_(s)    			    ((s) << 0)
#define MQ_GC_HORIZONTAL_DISPLAY_END				    (0x7ff << 16)
#define MQ_GC_HORIZONTAL_DISPLAY_END_(s)    			    ((s) << 16)
	    mq32    vertical_display;
#define MQ_GC_VERTICAL_DISPLAY_TOTAL				    (0x3ff << 0)
#define MQ_GC_VERTICAL_DISPLAY_TOTAL_(s)			    ((s) << 0)
#define MQ_GC_VERTICAL_DISPLAY_END				    (0x3ff << 16)
#define MQ_GC_VERTICAL_DISPLAY_END_(s)				    ((s) << 16)
	    mq32    horizontal_sync;
#define MQ_GC_HORIZONTAL_SYNC_START				    (0x7ff << 0)
#define MQ_GC_HORIZONTAL_SYNC_START_(s)				    ((s) << 0)
#define MQ_GC_HORIZONTAL_SYNC_END				    (0x7ff << 16)
#define MQ_GC_HORIZONTAL_SYNC_END_(s)				    ((s) << 16)
	    mq32    vertical_sync;
#define MQ_GC_VERTICAL_SYNC_START				    (0x3ff << 0)
#define MQ_GC_VERTICAL_SYNC_START_(s)				    ((s) << 0)
#define MQ_GC_VERTICAL_SYNC_END					    (0x3ff << 16)
#define MQ_GC_VERTICAL_SYNC_END_(s)				    ((s) << 16)
	    mq32    horizontal_counter_init;	/* set to 0 */
	    mq32    vertical_counter_init;	/* set to 0 */
	    mq32    horizontal_window;
#define MQ_GC_HORIZONTAL_WINDOW_START				    (0x7ff << 0)
#define MQ_GC_HORIZONTAL_WINDOW_START_(s)			    ((s) << 0)
#define MQ_GC_HORIZONTAL_WINDOW_WIDTH				    (0x7ff << 16)
#define MQ_GC_HORIZONTAL_WINDOW_WIDTH_(s)			    ((s) << 16)
	    mq32    vertical_window;
#define MQ_GC_VERTICAL_WINDOW_START				    (0x3ff << 0)
#define MQ_GC_VERTICAL_WINDOW_START_(s)				    ((s) << 0)
#define MQ_GC_VERTICAL_WINDOW_HEIGHT				    (0x3ff << 16)
#define MQ_GC_VERTICAL_WINDOW_HEIGHT_(s)			    ((s) << 16)
	    mq32    reserved_28;
	    mq32    line_clock;
#define MQ_GC_LINE_CLOCK_START					    (0x7ff << 0)
#define MQ_GC_LINE_CLOCK_START_(s)				    ((s) << 0)
#define MQ_GC_LINE_CLOCK_END					    (0x7ff << 16)
#define MQ_GC_LINE_CLOCK_END_(s)				    ((s) << 16)
	    mq32    window_start_address;
	    mq32    alternate_window_start_address;
	    mq32    window_stride;
	    mq32    reserved_3c;
	    mq32    cursor_position;
#define MQ_GC_HORIZONTAL_CURSOR_START				    (0x7ff << 0)
#define MQ_GC_HORIZONTAL_CURSOR_START_(s)			    ((s) << 0)
#define MQ_GC_VERTICAL_CURSOR_START				    (0x3ff << 16)
#define MQ_GC_VERTICAL_CURSOR_START_(s)				    ((s) << 16)
	    mq32    cursor_start_address;
#define MQ_GC_CURSOR_START_ADDRESS				    (0xff << 0)
#define MQ_GC_CURSOR_START_ADDRESS_(s)				    ((s) << 0)
#define MQ_GC_HORIZONTAL_CURSOR_OFFSET				    (0x3f << 16)
#define MQ_GC_HORIZONTAL_CURSOR_OFFSET_(s)			    ((s) << 16)
#define MQ_GC_VERTICAL_CURSOR_OFFSET				    (0x3f << 24)
#define MQ_GC_VERTICAL_CURSOR_OFFSET_(s)			    ((s) << 24)
	    mq32    cursor_foreground;
	    mq32    cursor_background;
	    mq32    reserved_50_64[6];
	    mq32    frame_clock_control;
#define MQ_GC_FRAME_CLOCK_START					    (0x3ff << 0)
#define MQ_GC_FRAME_CLOCK_START_(s)	    			    ((s) << 0)
#define MQ_GC_FRAME_CLOCK_END					    (0x3ff << 16)
#define MQ_GC_FRAME_CLOCK_END_(s)	    			    ((s) << 16)
	    mq32    misc_signals;
	    mq32    horizonal_parameter;
	    mq32    vertical_parameter;
	    mq32    window_line_start_address;
	    mq32    cursor_line_start_address;
	} s;
	mq32	a[0x20];
	mq8	size[128];
    } GC;
    /*
     * Graphics Engine			    0x200
     */
    union {
	mq32	a[0xc];
	mq8	size[128];
    } GE;
    /*
     * Synchronous Serial Controller	    0x280
     */
    union {
	mq8	size[128];
    } SSC;
    /*
     * Serial Peripheral Interface	    0x300
     */
    union {
	mq8	size[128];
    } SPI;
    /* 
     * Device Configuration Space	    0x380
     */
    union {
	struct {
	    mq32    config_0;
#define MQ_CONFIG_LITTLE_ENDIAN_ENABLE				(1 << 0)
#define MQ_CONFIG_BYTE_SWAPPING					(1 << 1)
	    mq32    config_1;
#define MQ_CONFIG_18_OSCILLATOR					(3 << 0)
#define MQ_CONFIG_18_OSCILLATOR_DISABLED    			(0 << 0)
#define MQ_CONFIG_18_OSCILLATOR_OSCFO				(1 << 0)
#define MQ_CONFIG_18_OSCILLATOR_INTERNAL    			(3 << 0)
#define MQ_CONFIG_CPU_CLOCK_DIVISOR				(1 << 8)
#define MQ_CONFIG_DTACK_CONTROL					(1 << 9)
#define MQ_CONFIG_INTERFACE_SYNCHRONIZER_CONTROL    		(1 << 10)
#define MQ_CONFIG_WRITE_DATA_LATCH    				(1 << 11)
#define MQ_CONFIG_CPU_TEST_MODE					(1 << 12)
#define MQ_CONFIG_SOFTWARE_CHIP_RESET				(1 << 16)
#define MQ_CONFIG_WEAK_PULL_DOWN_FMOD				(1 << 28)
#define MQ_CONFIG_WEAK_PULL_DOWN_FLCLK				(1 << 29)
#define MQ_CONFIG_WEAK_PULL_DOWN_PWM0				(1 << 30)
#define MQ_CONFIG_WEAK_PULL_DOWN_PWM1				(1 << 31)
	    mq32    config_2;
#define MQ_CONFIG_CC_MODULE_ENABLE				(1 << 0)
	    mq32    config_3;
#define MQ_CONFIG_BUS_INTERFACE_MODE				(0x7f << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_SH7750    			(0x01 << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_SH7709    			(0x02 << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_VR4111    			(0x04 << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_SA1110    			(0x08 << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_PCI    			(0x20 << 0)
#define MQ_CONFIG_BUS_INTERFACE_MODE_DRAGONBALL_EZ    		(0x40 << 0)
	    mq32    config_4;
#define MQ_CONFIG_GE_FORCE_BUSY_GLOBAL				(1 << 0)
#define MQ_CONFIG_GE_FORCE_BUSY_LOCAL				(1 << 1)
#define MQ_CONFIG_GE_CLOCK_SELECT    				(1 << 2)
#define MQ_CONFIG_GE_CLOCK_DIVIDER    				(7 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_1				(0 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_1_5				(1 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_2				(2 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_2_5				(3 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_3				(4 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_4				(5 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_5				(6 << 3)
#define MQ_CONFIG_GE_CLOCK_DIVIDER_6				(7 << 3)
#define MQ_CONFIG_GE_FIFO_RESET					(1 << 6)
#define MQ_CONFIG_GE_SOURCE_FIFO_RESET				(1 << 7)
#define MQ_CONFIG_USB_SE0_DETECT    				(1 << 8)
#define MQ_CONFIG_USB_HOST_DYNAMIC_POWER    			(1 << 9)
#define MQ_CONFIG_USB_COUNTER_SCALE_ENABLE    			(1 << 10)
#define MQ_CONFIG_USB_HOST_READ_TEST_ENABLE    			(1 << 11)
#define MQ_CONFIG_USB_HOST_TEST_MODE_DATA    			(0xf << 12)
#define MQ_CONFIG_USB_TRANSCEIVER_TEST_MODE_ENABLE		(1 << 16)
#define MQ_CONFIG_USB_HOST_OVER_CURRENT_DETECT    		(1 << 17)
#define MQ_CONFIG_USB_DEVICE_DYNAMIC_POWER_ENABLE    		(1 << 18)
#define MQ_CONFIG_USB_HOST_TRANSCEIVER_INPUT_ENABLE    		(1 << 19)
#define MQ_CONFIG_USB_DEVICE_TRANSCEIVER_INPUT_ENABLE		(1 << 20)
#define MQ_CONFIG_USB_TEST_VECTOR_GENERATION_ENABLE    		(1 << 21)
	    mq32    config_5;
#define MQ_CONFIG_GE_ENABLE					(1 << 0)
#define MQ_CONFIG_USB_HOST_ENABLE				(1 << 1)
#define MQ_CONFIG_USB_DEVICE_CLOCK_ENABLE    			(1 << 2)
	    mq32    config_6;
	    mq32    config_7;
	} s;
	mq32	a[8];
	mq8	size[128];
    } DC;
    /*
     * PCI Configuration Header 
     */
    union {
	/* little endian */
	struct {
	    mq16    vendor_id;
	    mq16    device_id;
	    mq16    command;
	    mq16    status;
	    mq32    revision_class;
	    mq8	    cache_line_size;
	    mq8	    latency_timer;
	    mq8	    header_type;
	    mq8	    BIST;
	    mq32    bar0;
	    mq32    bar1;
	    mq32    pad0[4];
	    mq32    cardbus_cis;
	    mq16    subsystem_vendor_id;
	    mq16    subsystem_id;
	    mq32    expansion_rom;
	    mq8	    cap_ptr;
	    mq8	    pad1[3];
	    mq8	    interrupt_line;
	    mq8	    interrupt_pin;
	    mq8	    min_gnt;
	    mq8	    max_lat;
	    mq8	    capability_id;
	    mq8	    next_item_ptr;
	    mq16    power_management_capabilities;
	    mq16    power_management_control_status;
	    mq8	    PMCSR_BSE_bridge;
	    mq8	    data;
	} s;
	mq8	size[256];
    } PCI;
    /*
     * USB Host 
     */
    union {
	mq8	size[256];
    } USBHost;
    /* 
     * Flat Panel Controller 
     */
    union {
	struct {
	    mq32    control;
#define MQ_FP_PANEL_TYPE					    (0xf << 0)
#define MQ_FP_PANEL_TYPE_TFT					    (0x0 << 0)
#define MQ_FP_PANEL_TYPE_STN					    (0x4 << 0)
#define MQ_FP_MONOCHROME_SELECT					    (1 << 4)
#define MQ_FP_FLAT_PANEL_INTERFACE    				    (7 << 5)
#define MQ_FP_FLAT_PANEL_INTERFACE_4_BIT    			    (0 << 5)
#define MQ_FP_FLAT_PANEL_INTERFACE_6_BIT    			    (1 << 5)
#define MQ_FP_FLAT_PANEL_INTERFACE_8_BIT    			    (2 << 5)
#define MQ_FP_FLAT_PANEL_INTERFACE_16_BIT    			    (3 << 5)
#define MQ_FP_DITHER_PATTERN					    (3 << 8)
#define MQ_FP_DITHER_PATTERN_1					    (1 << 8)
#define MQ_FP_DITHER_BASE_COLOR					    (7 << 12)
#define MQ_FP_DITHER_BASE_COLOR_DISABLE				    (7 << 12)
#define MQ_FP_DITHER_BASE_COLOR_3_BITS				    (3 << 12)
#define MQ_FP_DITHER_BASE_COLOR_4_BITS				    (4 << 12)
#define MQ_FP_DITHER_BASE_COLOR_5_BITS				    (5 << 12)
#define MQ_FP_DITHER_BASE_COLOR_6_BITS				    (6 << 12)
#define MQ_FP_ALTERNATE_WINDOW_CONTROL				    (1 << 15)
#define MQ_FP_FRC_CONTROL					    (3 << 16)
#define MQ_FP_FRC_CONTROL_2_LEVEL    				    (0 << 16)
#define MQ_FP_FRC_CONTROL_4_LEVEL    				    (1 << 16)
#define MQ_FP_FRC_CONTROL_8_LEVEL    				    (2 << 16)
#define MQ_FP_FRC_CONTROL_16_LEVEL    				    (3 << 16)
#define MQ_FP_POLY_SI_TFT_ENABLE    				    (1 << 19)
#define MQ_FP_POLY_SI_TFT_FIRST_LINE				    (1 << 20)
#define MQ_FP_POLY_SI_TFT_DISPLAY_DATA_CONTROL			    (1 << 21)
#define MQ_FP_APP_NOTE_SAYS_SET_THIS				    (1 << 22)
	    mq32    pin_control_1;
#define MQ_FP_DISABLE_FLAT_PANEL_PINS				    (1 << 0)
#define MQ_FP_DISPLAY_ENABLE					    (1 << 2)
#define MQ_FP_AC_MODULATION_ENABLE    				    (1 << 3)
#define MQ_FP_PWM_CLOCK_ENABLE					    (1 << 5)
#define MQ_FP_TFT_SHIFT_CLOCK_SELECT				    (1 << 6)
#define MQ_FP_SHIFT_CLOCK_MASK					    (1 << 7)
#define MQ_FP_FHSYNC_CONTROL					    (1 << 8)
#define MQ_FP_STN_SHIFT_CLOCK_CONTROL				    (1 << 9)
#define MQ_FP_STN_EXTRA_LP_ENABLE    				    (1 << 10)
#define MQ_FP_TFT_DISPLAY_ENABLE_SELECT				    (3 << 12)
#define MQ_FP_TFT_DISPLAY_ENABLE_SELECT_00    			    (0 << 12)
#define MQ_FP_TFT_DISPLAY_ENABLE_SELECT_01    			    (1 << 12)
#define MQ_FP_TFT_DISPLAY_ENABLE_SELECT_10    			    (2 << 12)
#define MQ_FP_TFT_DISPLAY_ENABLE_SELECT_11    			    (3 << 12)
#define MQ_FP_TFT_HORIZONTAL_SYNC_SELECT    			    (3 << 14)
#define MQ_FP_TFT_HORIZONTAL_SYNC_SELECT_00    			    (0 << 14)
#define MQ_FP_TFT_HORIZONTAL_SYNC_SELECT_01    			    (1 << 14)
#define MQ_FP_TFT_HORIZONTAL_SYNC_SELECT_10    			    (2 << 14)
#define MQ_FP_TFT_HORIZONTAL_SYNC_SELECT_11    			    (3 << 14)
#define MQ_FP_TFT_VERTICAL_SYNC_SELECT    			    (3 << 16)
#define MQ_FP_TFT_VERTICAL_SYNC_SELECT_00    			    (0 << 16)
#define MQ_FP_TFT_VERTICAL_SYNC_SELECT_01    			    (1 << 16)
#define MQ_FP_TFT_VERTICAL_SYNC_SELECT_10    			    (2 << 16)
#define MQ_FP_TFT_VERTICAL_SYNC_SELECT_11    			    (3 << 16)
#define MQ_FP_LINE_CLOCK_CONTROL    				    (1 << 18)
#define MQ_FP_ALTERNATE_LINE_CLOCK_CONTROL    			    (1 << 19)
#define MQ_FP_FMOD_CLOCK_CONTROL    				    (1 << 20)
#define MQ_FP_FMOD_FRAME_INVERSION    				    (1 << 21)
#define MQ_FP_FMOD_FREQUENCY_CONTROL 				    (1 << 22)
#define MQ_FP_FMOD_SYNCHRONOUS_RESET  				    (1 << 23)
#define MQ_FP_SHIFT_CLOCK_DELAY   				    (7 << 24)
#define MQ_FP_EXTENDED_LINE_CLOCK_CONTROL    			    (1 << 27)
	    mq32    output_control;
	    mq32    input_control;
#define MQ_FP_ENVDD				    (1 << 0)
#define MQ_FP_ENVEE				    (1 << 1)
#define MQ_FP_FD2				    (1 << 2)
#define MQ_FP_FD3				    (1 << 3)
#define MQ_FP_FD4				    (1 << 4)
#define MQ_FP_FD5				    (1 << 5)
#define MQ_FP_FD6				    (1 << 6)
#define MQ_FP_FD7				    (1 << 7)
#define MQ_FP_FD10				    (1 << 10)
#define MQ_FP_FD11				    (1 << 11)
#define MQ_FP_FD12				    (1 << 12)
#define MQ_FP_FD13				    (1 << 13)
#define MQ_FP_FD14				    (1 << 14)
#define MQ_FP_FD15				    (1 << 15)
#define MQ_FP_FD18				    (1 << 18)
#define MQ_FP_FD19				    (1 << 19)
#define MQ_FP_FD20				    (1 << 20)
#define MQ_FP_FD21				    (1 << 21)
#define MQ_FP_FD22				    (1 << 22)
#define MQ_FP_FD23				    (1 << 23)
#define MQ_FP_FSCLK				    (1 << 24)
#define MQ_FP_FDE				    (1 << 25)
#define MQ_FP_FHSYNC				    (1 << 26)
#define MQ_FP_FVSYNC				    (1 << 27)
#define MQ_FP_FMOD				    (1 << 28)
#define MQ_FP_FLCLK				    (1 << 29)
#define MQ_FP_PWM0				    (1 << 30)
#define MQ_FP_PWM1				    (1 << 31)
	    mq32    stn_panel_control;
	    mq32    polarity_control;
	    mq32    pin_output_select_0;
	    mq32    pin_output_select_1;
	    mq32    pin_output_data;
	    mq32    pin_input_data;
	    mq32    pin_weak_pull_down;
	    mq32    additional_pin_output_select;
	    mq32    test_control;
	    mq32    pulse_width_mod_control;
	    mq32    frc_pattern[32];
	    mq32    frc_weight;
	    mq32    pwm_clock_selector_c8;
	    mq32    pwm_clock_selector_cc;
	    mq32    pwm_clock_selector_d0;
	    mq32    pwm_clock_selector_d4;
	    mq32    frc_weight_d8;
	    mq32    frc_weight_dc;
	} s;
	mq32	a[0x80];
	mq8	size[512];
    } FP;
    /*
     * Color Palette 
     */
    union {
	struct {
	    mq32    palette[256];
	} s;
	mq8	size[1024];
    } CMAP;
    /*
     * Source FIFO Space 
     */
    union {
	mq8	size[1024];
    } FIFO;
    /*
     * USB Device 
     */
    union {
	mq8	size[128];
    } USBDevice;
} MqReg;

#define MQ1100_REG_SIZE	(8*1024)
#define MQ1100_FB_SIZE	(256*1024)

/*
 * Instead of attempting to figure out how to program this device,
 * just use canned values for the known display types.
 */
typedef struct _MqInitData {
    mq32    dc[0x6];
    mq32    cc[0x6];
    mq32    miu[0x6];
    mq32    gc[0x1b];
    mq32    fp[0x80];
    mq32    ge[0xc];
} MqInitData;

typedef struct _mqMap {
    volatile MqReg	    *reg;	/* registers */
    volatile unsigned char  *sync;	/* 256K synchronized to GPU */
    volatile unsigned char  *async;	/* 256K not synchronized to GPU */
} MqMap;

typedef int	MqBool;

#define MqTrue	1
#define MqFalse	0

extern MqInitData   mqInitSharp;
extern MqInitData   mqInitH5400;

typedef struct _MqBits {
    mq16    width;
    mq16    offset;
} MqBits;

typedef enum _MqVisual {
    MqVisualGray, MqVisualPseudo, MqVisualTrue
} MqVisual;

#define MQ_Rotate_0	1
#define MQ_Rotate_90	2
#define MQ_Rotate_180	4
#define MQ_Rotate_270	8

#define MQ_Reflect_X	16
#define MQ_Reflect_Y	32

typedef struct _MqFormat {
    mq16	width, height;
    MqVisual	visual;
    mq16	bpp;
    mq16	stride;
    mq16	orient;
    mq16	width_mm, height_mm;
} MqFormat;

MqBool
MqPowerGC (MqMap *mq, MqBool on);

MqBool
MqInit (MqMap *mq, MqInitData *md);

MqBool
MqDataToFormat (MqInitData *md, MqFormat *mf, mq16 ppm);

MqBool
MqReorientData (MqInitData *src, MqInitData *dst, mq16 orient);

struct MqFuncs
{
    MqInitData *(*mq1100_detect_lcd) (MqMap *mq);
    void (*mq1100_power) (MqBool on);
    void (*mq1100_lcd_enable) (MqBool on);
};

int __devinit
mq1100_probe (unsigned long io, unsigned long fbmem, struct MqFuncs *funcs);

void __devexit mq1100_cleanup (void);

#define mq1100_power(_f, _v)	\
	do { if (_f.funcs->mq1100_power) _f.funcs->mq1100_power(_v); } while (0)

#define mq1100_lcd_enable(_f, _v)	\
	do { if (_f.funcs->mq1100_lcd_enable) _f.funcs->mq1100_lcd_enable(_v); } while (0)

#endif /* _MQ1100_H_ */
