/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002, September 2002
*/

#include <linux/module.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/pm.h>
#include <linux/sysctl.h>
#include <linux/proc_fs.h>
#include <linux/ctype.h>
#include <linux/spi/spi.h>
#include <linux/delay.h>

#include <asm/irq.h>
#include <asm/arch/hardware.h>
#include <asm/arch-sa1100/h3600_hal.h>

#include "../mach-sa1100/h3600_asic_core.h"
#include "h3600_asic_battery.h"

#include <asm/arch-pxa/h5400-asic.h>
#include <asm/arch-pxa/h5400-gpio.h>

static void h5400_set_charger (int on)
{
	unsigned long flags;

	local_irq_save (flags);

	SET_H5400_GPIO (EXT_CHG_RATE, 0);
	SET_H5400_GPIO (USB_CHG_RATE, 0);
	
	if (on) {
		if (h5400_asic_read_register (H5400_ASIC_GPIO_GPA_DAT) & H5400_ASIC_GPIO_GPA_ADP_IN_STATUS) {
			printk (KERN_DEBUG "selected external charging rate\n");
			SET_H5400_GPIO (EXT_CHG_RATE, 1);
		} else {
			printk (KERN_DEBUG "selecting USB charging rate\n");
			SET_H5400_GPIO (USB_CHG_RATE, 1);
		}
		
		SET_H5400_GPIO (CHG_EN, 1);
	} else
		SET_H5400_GPIO (CHG_EN, 0);

	local_irq_restore (flags);
}

static int h5400_ac_power (void)
{
	return (h5400_asic_read_register (H5400_ASIC_GPIO_GPA_DAT) & (H5400_ASIC_GPIO_GPA_ADP_IN_STATUS | H5400_ASIC_GPIO_GPA_USB_DETECT)) ? 1 : 0;
}

static u8 h5400_owm_read_data (void)
{
	return h5400_asic_read_register (H5400_ASIC_OWM_Data);
}

static u8 h5400_owm_read_interrupt (void)
{
	return h5400_asic_read_register (H5400_ASIC_OWM_Interrupt);
}

static u8 h5400_owm_read_command (void)
{
	return h5400_asic_read_register (H5400_ASIC_OWM_Command);
}

static void h5400_owm_write_data (u8 val)
{
	h5400_asic_write_register (H5400_ASIC_OWM_Data, val);
}

static void h5400_owm_write_command (u8 val)
{
	h5400_asic_write_register (H5400_ASIC_OWM_Command, val);
}

static void h5400_owm_up (struct h3600_asic_owmdev *owm)
{
	int half_clk;

	half_clk = h5400_asic_read_register (H5400_ASIC_CPM_ClockSleep) & H5400_ASIC_CPM_CLKSLEEP_HALF_CLK;

	h5400_asic_clock_enable (H5400_ASIC_CPM_CLKCON_1WIRE_CLKEN, 1);
	h5400_asic_write_register (H5400_ASIC_OWM_ClockDivisor, half_clk ? 0x13 : 0x0f);
	h5400_asic_write_register (H5400_ASIC_OWM_InterruptEnable, 
				   OWM_INTEN_ERBF | OWM_INTEN_IAS | OWM_INTEN_EPD);
}

static void h5400_owm_down (struct h3600_asic_owmdev *owm)
{
	h5400_asic_write_register (H5400_ASIC_OWM_InterruptEnable, 0);
	h5400_asic_clock_enable (H5400_ASIC_CPM_CLKCON_1WIRE_CLKEN, 0);
}

struct asic2_battery_ops h5400_battery_ops = 
{
	owm_irq:		IRQ_H5400_ONEWIRE,
	
	owm_read_data:		h5400_owm_read_data,
	owm_read_interrupt:	h5400_owm_read_interrupt,
	owm_read_command:	h5400_owm_read_command,
	
	owm_write_data:		h5400_owm_write_data,
	owm_write_command:	h5400_owm_write_command,

	owm_up:			h5400_owm_up,
	owm_down:		h5400_owm_down,

	set_charger:		h5400_set_charger,
	ac_power:		h5400_ac_power
};
