/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002, Sept 2002
*/

#ifndef H3600_ASIC_BATTERY_H
#define H3600_ASIC_BATTERY_H

struct pt_regs;
struct ctl_table;

extern struct ctl_table h3600_asic_battery_table[];

void h3600_asic_ac_in_isr(int irq, void *dev_id, struct pt_regs *regs);

extern unsigned char *owm_state_names[];

#ifdef CONFIG_PROC_FS
int h3600_asic_proc_battery(char *, char **, off_t, int, int *, void *);
int h3600_asic_proc_battery_ds2760(char *, char **, off_t, int, int *, void *);
int h3600_asic_proc_battery_raw(char *, char **, off_t, int, int *, void *);
int h3600_asic_proc_wakeup_read(char *page, char **start, off_t off,
				int count, int *eof, void *data );
#endif

enum charging_state {
	CHARGING_STATE_INIT = 0,
	CHARGING_STATE_NO_AC,      /* No AC */
	CHARGING_STATE_ACTIVE,     /* Actively charging the battery */
	CHARGING_STATE_FULL        /* The battery is fully charged */
};

int  h3600_asic_battery_get_state(void);
void h3600_asic_battery_set_led( enum charging_state state );
int  h3600_asic_battery_read( struct h3600_battery *query );
int  h3600_asic_thermal_sensor( unsigned short *result );

/* common initialization/cleanup functions */

int  h3600_asic_owm_init(void); 
void h3600_asic_owm_cleanup(void);
int  h3600_asic_owm_suspend(void); 
void h3600_asic_owm_resume (void);

int  h3600_asic_battery_init(void); 
void h3600_asic_battery_cleanup(void);
int  h3600_asic_battery_suspend(void); 
void h3600_asic_battery_resume (void);

void h3600_asic_initiate_sleep (void);
int  h3600_asic_check_wakeup (void);

enum owm_state {
	OWM_STATE_IDLE = 0,
	OWM_STATE_RESET,
	OWM_STATE_WRITE,
	OWM_STATE_READ,
	OWM_STATE_DONE
};

struct h3600_asic_owmdev {
	struct semaphore  lock;
	wait_queue_head_t waitq;
	enum owm_state    state;
	unsigned long     shared;
	unsigned char     last;
};

struct asic2_battery_ops
{
	int owm_irq;

	u8 (*owm_read_data) (void);
	u8 (*owm_read_interrupt) (void);
	u8 (*owm_read_command) (void);

	void (*owm_write_data) (u8);
	void (*owm_write_command) (u8);

	void (*owm_up) (struct h3600_asic_owmdev *owm);
	void (*owm_down) (struct h3600_asic_owmdev *owm);

	void (*set_charger) (int);
	int (*ac_power) (void);
};

void h3600_asic_register_battery_ops (struct asic2_battery_ops *ops);

extern struct owm_statistics g_owm_statistics;

#endif /* H3600_ASIC_BATTERY_H */
