/*
 * Hardware definitions for Dell Axim X5
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * Author: Martin Demin.
 *
 * History:
 *
 * 2003-05-26   Martin Demin       Adapted for use on Dell Axim X5
 * 2003-05-14	Joshua Wise        Adapted for the HP iPAQ H1900
 * 2002-08-23   Jamey Hicks        Adapted for use with PXA250-based iPAQs
 * 2001-10-??   Andrew Christian   Added support for iPAQ H3800
 *                                 and abstracted EGPIO interface.
 *
 */
#include <linux/module.h>
#include <linux/init.h>

#include <asm/setup.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach-types.h>
#include <asm/io.h>
#include <asm/arch/axim-init.h>

#include "generic.h"

static void __init axim_init_irq (void)
{
	/* Initialize standard IRQs */
	pxa_init_irq();
}

static struct map_desc axim_io_desc[] __initdata = {
  /*  virtual    physical     length     domain     r  w  c  b */
  { 0xf4000000, 0x14000000, 0x00800000, DOMAIN_IO,  0, 1, 0, 0 }, /* MediaQ 1132 */
  LAST_DESC
};

unsigned *mq11xx_virt_base;
EXPORT_SYMBOL (mq11xx_virt_base);

static void __init axim_map_io(void)
{
	pxa_map_io();
	iotable_init(axim_io_desc);

	mq11xx_virt_base = (unsigned *)0xf4000000;

	/* Configure power management stuff. */
	PGSR0 = GPSRx_SleepValue;
	PGSR1 = GPSRy_SleepValue;
	PGSR2 = GPSRz_SleepValue;

	/* Wake up on CF/SD card insertion, Power and Record buttons */
	PWER = PWER_GPIO0 | PWER_GPIO6 | PWER_GPIO7 | PWER_GPIO10 | PWER_RTC;
	PFER = PWER_GPIO0 | PWER_GPIO6 | PWER_GPIO7 | PWER_RTC;
	PRER = PWER_GPIO10;
	PCFR = PCFR_OPDE;

	/* Set up GPIO direction and alternate function registers */
	GAFR0_L = GAFR0x_InitValue;
	GAFR0_U = GAFR1x_InitValue;
	GAFR1_L = GAFR0y_InitValue;
	GAFR1_U = GAFR1y_InitValue;
	GAFR2_L = GAFR0z_InitValue;
	GAFR2_U = GAFR1z_InitValue;
	
	GPDR0 = GPDRx_InitValue;
	GPDR1 = GPDRy_InitValue;
	GPDR2 = GPDRz_InitValue;
	
	GPCR0 = 0x0fffffff;       /* All outputs are set low by default */
	
	/* Add wakeup on AC plug/unplug */
	PWER  |= PWER_GPIO8;
	PFER  |= PWER_GPIO8;
	PRER  |= PWER_GPIO8;
}

MACHINE_START(AXIM, "Dell Axim X5")
	MAINTAINER("Martin Demin (demo@twincar.sk), Andrew Zabolotny (anpaza@mail.ru)")
	BOOT_MEM(0xa0000000, 0x40000000, io_p2v(0x40000000))
	BOOT_PARAMS(0xa0000100)
	MAPIO(axim_map_io)
	INITIRQ(axim_init_irq)
MACHINE_END
