/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#ifndef __appint_h_ok_
#define __appint_h_ok_

#define	ESSID_SIZE				32
#define WEP_KEY_SIZE			13

#define MAX_BSS_ENTRIES			9
#define MAX_IBSS_ENTRIES		9

typedef struct __BSS_INFO{
	UCHAR	Channel;
	UCHAR	SSID[ESSID_SIZE];
	UCHAR	SSIDsize;
	UCHAR	BSSID[6];
	UCHAR	RSSI;
	UCHAR	UsingWEP;
	UCHAR	PreambleType;
	USHORT  BeaconPeriod;
	UCHAR	BSStype;
}BSS_INFO;

typedef struct __IBSS_INFO{
	UCHAR	MACaddress[6];
}IBSS_INFO;

typedef struct __STATISTICS{
	ULONG	TxDataPacketsOk;
	ULONG	TxDataPacketsError;
	ULONG	TxMgmtPacketsOk;
	ULONG	TxMgmtPacketsError;

	ULONG	RxDataPacketsOk;
	ULONG	RxDataPacketsError;
	ULONG	RxMgmtPacketsOk;
	ULONG	RxMgmtPacketsError;

	ULONG	RxLost;
	ULONG	TxPacketsRejectedNotReady;
	ULONG	TxPacketsRejectedResources;
	ULONG	MatchingBeacons;
}STATISTICS;

typedef struct __DEVICE_CONFIGURATION
{
	UCHAR			OperatingMode;					//AD_HOC_MODE or INFRASTRUCTURE_MODE
	UCHAR			Channel;
	UCHAR			SSID[ESSID_SIZE];
	UCHAR			SSIDlength;
	UCHAR			TxRate;							//0-4
	UCHAR			PowerMgmtMode;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			InternationalRoaming;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			RadioIsOn;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE

	UCHAR			PreambleType;					// LONG_PREAMBLE or SHORT_PREAMBLE

	USHORT			FragmentationThreshold;
	USHORT			RtsCtsThreshold;

	UCHAR			BSSID[6];
	UCHAR			StationState;
	UCHAR			Rssi;
	UCHAR			LinkQuality;
	UCHAR			RegDomain;
        UCHAR                   ChannelVector[14];
	ULONG			MgmtErrorCode;
}DEVICE_CONFIGURATION, *PDEVICE_CONFIGURATION;

typedef struct __VERSION_INFO{
	UCHAR 	DriverMajorVersion;
	UCHAR 	DriverMinorVersion;
	UCHAR 	DriverSubVersion;
	USHORT	DriverBuild;
	USHORT	FwMajorVersion;
	USHORT	FwMinorVersion;
	USHORT	FwSubVersion;
	USHORT	FwBuild;
}VERSION_INFO;

typedef struct __WEP_INFO {
    UCHAR						WepKeyToUse;
	UCHAR						ExcludeUnencrypted;
	USHORT						AuthenticationType;
	UCHAR						EncryptionLevel;
	UCHAR						WepKey1[WEP_KEY_SIZE];
	UCHAR						WepKey2[WEP_KEY_SIZE];
	UCHAR						WepKey3[WEP_KEY_SIZE];
	UCHAR						WepKey4[WEP_KEY_SIZE];
} WEP_INFO, *PWEP_INFO;

typedef struct __SITE_SURVEY_INFO {
	BSS_INFO	BssInfo[MAX_BSS_ENTRIES];
	UCHAR		BSSInList;
	UCHAR		UserSelectedIndex;
	UCHAR		SiteSurveyState;
}SITE_SURVEY_INFO, *PSITE_SURVEY_INFO;
#endif //__appint_h_ok_
