/* $Id: rx.c,v 1.1 2003/12/13 18:55:20 pb Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "vnetusba.h"
#include "rx.h"
#include "frame.h"
#include "mib.h"
#include "stdinclude.h"

/*************************************************
	UsbRxInit : If Bulk In endpoint polling has
	started return or else start polling on it.
*************************************************/
int UsbRxInit(PVNet_ADAPTER Adapter)
{
	if (Adapter->rx_urb->status == -EINPROGRESS)
		return 0;	// bulk in polling ok return
	FILL_BULK_URB(Adapter->rx_urb,
		      Adapter->usb,
		      usb_rcvbulkpipe(Adapter->usb, Adapter->BulkInAddr),
		      (PVOID) & Adapter->RxInBuff,
		      VNET_MAX_WIRELESS_PACKET + 12, RxCallback, Adapter);

	if (usb_submit_urb(Adapter->rx_urb) != 0) {
		err("bulk-in polling initialization failed");
		return -1;
	}

	dbgcond(DBG_INIT, "bulk-in polling started\n");
	Adapter->flags &= ~STOPPED_RX;
	return 0;
}

VOID GetSSIDFromBeaconOrProbe(PUCHAR pSSID, PUCHAR Length, PUCHAR pFrame)
{
	*Length = *(pFrame + SSID_ELLEMENT_LENGTH_OFFSET);
	memcpy(pSSID, pFrame + SSID_ELLEMENT_OFFSET, *Length);
}

/************************************************************
	MgmtFrameProcessing : Processing of Received management
	frames. From here we get information for any Access Point
	or station in the area.	
************************************************************/
VOID MgmtFrameProcessing(PVNet_ADAPTER Adapter, UCHAR FrameSubType)
{
	PUCHAR DestinationAddress;
	PUCHAR SourceAddress;
	PUCHAR BSSID;
	PUCHAR FrameBody;
	PUCHAR AuthenticationFrame;
	USHORT CapabilityInformation;	// 2 bytes
	USHORT AssocID;
	UCHAR SupportedRatesLength;
	UCHAR SupportedRates[4];
	int i; //k, l;
	UCHAR tmpSSIDLen, tmpSRatesLen, tmpChannel;
	UCHAR ChallengeTextLength;
	UCHAR AssociationRespFrameBytesToGet;
	PUCHAR AssociationRspnsFrame;

	Adapter->Stats.RxMgmtPacketsOk++;

	DestinationAddress =
	    Adapter->RxInBuff.WirelessPacket + MGMT_FRAME_DA_OFFSET;
	SourceAddress =
	    Adapter->RxInBuff.WirelessPacket + MGMT_FRAME_SA_OFFSET;
	BSSID =
	    Adapter->RxInBuff.WirelessPacket +
	    WIRELESS_HEADER_ADDRESS3_OFFSET;
	FrameBody =
	    Adapter->RxInBuff.WirelessPacket + MGMT_FRAME_BODY_OFFSET;

	switch (FrameSubType) {
	case C80211_SUBTYPE_MGMT_BEACON:
	case C80211_SUBTYPE_MGMT_ProbeResponse:

		if (Adapter->RxInBuff.WLength < 41)
			break;

		/* the cap info is in little endian ... */
		CapabilityInformation =
		    (USHORT) FrameBody[CAPABILITY_INFO_IN_BEACON_OFFSET] |
		    ((USHORT)
		     FrameBody[CAPABILITY_INFO_IN_BEACON_OFFSET + 1]) << 8;

		tmpSSIDLen = *(FrameBody + SSID_ELLEMENT_LENGTH_OFFSET);
		tmpSRatesLen = *(FrameBody + tmpSSIDLen +
				 SUP_RATES_ELLEMENT_LENGTH_REL_OFFSET);
		tmpChannel = *(FrameBody + tmpSSIDLen +
			       tmpSRatesLen +
			       DS_PARAM_SET_ELLEMENT_REL_OFFSET);

		{
			char buf[2 * ESSID_SIZE + 1] __attribute__ ((unused));
			dbgcond(DBG_BEACON,
				"got beacon on ch %d, ssid %s, capa x%x, "
				"rssi %d, link qual %d, noise %d\n",
				tmpChannel, ssid2str(buf,
						     &FrameBody
						     [SSID_ELLEMENT_OFFSET],
						     MIN(ESSID_SIZE,
							 FrameBody
							 [SSID_ELLEMENT_LENGTH_OFFSET])),
				CapabilityInformation,
				Adapter->RxInBuff.RSSI,
				Adapter->RxInBuff.LinkQuality,
				Adapter->RxInBuff.NoiseLevel);
		}

		if (tmpSSIDLen > 32) {
			Adapter->Stats.RxMgmtPacketsError++;
			break;
		}
		switch (Adapter->StationState) {
		case STATION_STATE_SCANNING:

			dbgcond(DBG_SCAN, "found BSS ch %d, bssid "
				"%02x:%02x:%02x:%02x:%02x:%02x, "
				"cap x%04x, RSSI %d\n",
				tmpChannel, BSSID[0], BSSID[1], BSSID[2],
				BSSID[3], BSSID[4], BSSID[5],
				CapabilityInformation,
				Adapter->RxInBuff.RSSI);

			if (Adapter->SiteS.BSSInList < MAX_BSS_ENTRIES) {
				for (i = 0; i < Adapter->SiteS.BSSInList;
				     i++) {
					if (memcmp
					    (BSSID,
					     Adapter->SiteS.BssInfo[i].
					     BSSID, 6) == 0) {
						dbgcond(DBG_SCAN,
							"already in list\n");
						break;
					}
				}

				if (i == Adapter->SiteS.BSSInList) {
					/* BSS not in list yet */
					char buf[ESSID_SIZE + 1] __attribute__ ((unused));

					GetSSIDFromBeaconOrProbe(Adapter->
								 SiteS.
								 BssInfo
								 [Adapter->
								  SiteS.
								  BSSInList].
								 SSID,
								 &Adapter->
								 SiteS.
								 BssInfo
								 [Adapter->
								  SiteS.
								  BSSInList].
								 SSIDsize,
								 FrameBody);
					dbgcond(DBG_SCAN, "SSID: %s\n",
						ssid2str(buf,
							 Adapter->SiteS.
							 BssInfo[Adapter->
								 SiteS.
								 BSSInList].
							 SSID,
							 Adapter->SiteS.
							 BssInfo[Adapter->
								 SiteS.
								 BSSInList].
							 SSIDsize));

					Adapter->SiteS.BssInfo[Adapter->
							       SiteS.
							       BSSInList].
					    Channel = tmpChannel;
					memcpy(Adapter->SiteS.
					       BssInfo[Adapter->SiteS.
						       BSSInList].BSSID,
					       BSSID, 6);
					Adapter->SiteS.BssInfo[Adapter->
							       SiteS.
							       BSSInList].
					    RSSI = Adapter->RxInBuff.RSSI;
					if (CapabilityInformation &
					    C80211_MGMT_CAPABILITY_ShortPreamble)
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    PreambleType = 1;
					else
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    PreambleType = 0;

					if (CapabilityInformation &
					    C80211_MGMT_CAPABILITY_Privacy)
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    UsingWEP = 1;
					else
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    UsingWEP = 0;

					Adapter->SiteS.BssInfo[Adapter->
							       SiteS.
							       BSSInList].
					    BeaconPeriod =
					    *(PUSHORT) (FrameBody + 8);

					if (CapabilityInformation &
					    C80211_MGMT_CAPABILITY_ESS)
						//Infrastructure
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    BSStype = 2;
					else
						//Ad-Hoc
						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    BSStype = 1;

                                        /*
					if ((Adapter->SiteS.
					     BssInfo[Adapter->SiteS.
						     BSSInList].SSIDsize ==
					     1)
					    && (Adapter->SiteS.
						BssInfo[Adapter->SiteS.
							BSSInList].
						SSID[0] == 0x20)) {

						Adapter->SiteS.
						    BssInfo[Adapter->SiteS.
							    BSSInList].
						    SSIDsize = 6;
						for (l = 0, k = 3; k < 6;
						     k++) {
							Adapter->SiteS.
							    BssInfo
							    [Adapter->
							     SiteS.
							     BSSInList].
							    SSID[l++] =
							    BIN2HEX((BSSID
								     [k] >>
								     4) &
								    0xf);
							Adapter->SiteS.
							    BssInfo
							    [Adapter->
							     SiteS.
							     BSSInList].
							    SSID[l++] =
							    BIN2HEX(BSSID
								    [k] &
								    0xf);
						}
					}
                                */
					Adapter->SiteS.BSSInList++;
				}
			} else
				dbgcond(DBG_SCAN, "BSS list is full\n");
			break;

		case STATION_STATE_READY:
			if (FrameSubType == C80211_SUBTYPE_MGMT_BEACON) {
				if (memcmp(BSSID, Adapter->CurrentBSSID, 6)
				    != 0) {
					Adapter->Stats.
					    RxMgmtPacketsError++;
					return;
				}
				Adapter->Stats.MatchingBeacons++;
				Adapter->flags |= HeardBeacons;
			}
			break;
		default:
			break;
		}
		break;

	case C80211_SUBTYPE_MGMT_Authentication:

		dbgcond(DBG_AUTH, "Auth response from BSSID "
			"%02x:%02x:%02x:%02x:%02x:%02x, status %d, trans_seq x%x\n",
			BSSID[0], BSSID[1], BSSID[2], BSSID[3], BSSID[4],
			BSSID[5],
			Adapter->RxInBuff.
			WirelessPacket[MGMT_FRAME_BODY_OFFSET +
				       STATUS_IN_AUTHENTICATION_OFFSET],
			Adapter->RxInBuff.
			WirelessPacket[MGMT_FRAME_BODY_OFFSET +
				       TRANS_SEQ_NO_IN_AUTHENTICATION_OFFSET]);
		VnetTimer(Adapter, 0);
		if (memcmp(BSSID, Adapter->CurrentBSSID, 6) != 0) {
			dbgcond(DBG_AUTH, "wrong BSSID, expected: "
				"%02x:%02x:%02x:%02x:%02x:%02x\n",
				Adapter->CurrentBSSID[0],
				Adapter->CurrentBSSID[1],
				Adapter->CurrentBSSID[2],
				Adapter->CurrentBSSID[3],
				Adapter->CurrentBSSID[4],
				Adapter->CurrentBSSID[5]);
			Adapter->Stats.RxMgmtPacketsError++;
			return;
		}

		AuthenticationFrame =
		    Adapter->RxInBuff.WirelessPacket +
		    MGMT_FRAME_BODY_OFFSET;

		//jal: Is this not an _u16 value as with assoc response ???
		Adapter->ErrorCode =
		    AuthenticationFrame[STATUS_IN_AUTHENTICATION_OFFSET];

		if (Adapter->StationState == STATION_STATE_AUTHENTICATING) {

			switch (Adapter->ErrorCode) {

			case C80211_MGMT_SC_Success:
				if (Adapter->PrivacyInvoked
				    && (Adapter->WepInfo.
					AuthenticationType ==
					C80211_MGMT_AAN_SHAREDKEY)) {
					if (AuthenticationFrame
					    [TRANS_SEQ_NO_IN_AUTHENTICATION_OFFSET]
					    == Adapter->
					    ExpectedAuthentTransactionSeqNum)
					{
						if (AuthenticationFrame
						    [TRANS_SEQ_NO_IN_AUTHENTICATION_OFFSET]
						    == 0x0002) {
							if (AuthenticationFrame[CHALL_TEXT_EL_ID_IN_AUTHENTICATION_OFFSET] == C80211_MGMT_ElementID_ChallengeText) {
								ChallengeTextLength
								    =
								    AuthenticationFrame
								    [CHALL_TEXT_LENGTH_IN_AUTHENTICATION_OFFSET];
								SendAuthRequest
								    (Adapter,
								     &AuthenticationFrame
								     [CHALL_TEXT_IN_AUTHENTICATION_OFFSET],
								     ChallengeTextLength);
							}
						} else
						    if (AuthenticationFrame
							[TRANS_SEQ_NO_IN_AUTHENTICATION_OFFSET]
							== 0x0004) {
							Adapter->flags |=
							    StationIsAuthenticated;
							if (!
							    (Adapter->
							     flags &
							     StationWasAssociated))
							{
								Adapter->
								    AssociationRequestRetries
								    = 0;
								ChangeState
								    (Adapter,
								     STATION_STATE_ASSOCIATING);
								SendAssocRequest
								    (Adapter);
							} else {
								Adapter->
								    ReAssociationRequestRetries
								    = 0;
								ChangeState
								    (Adapter,
								     STATION_STATE_REASSOCIATING);
								SendReAssocRequest
								    (Adapter);
							}
						}
					}
				} else {
					Adapter->flags |=
					    StationIsAuthenticated;
					dbgcond(DBG_AUTH,
						"Authentication Response Success (no WEP)\n");
					if (!
					    (Adapter->
					     flags & StationWasAssociated))
					{
						Adapter->
						    AssociationRequestRetries
						    = 0;
						ChangeState(Adapter,
							    STATION_STATE_ASSOCIATING);
						SendAssocRequest(Adapter);
					} else {
						Adapter->
						    ReAssociationRequestRetries
						    = 0;
						ChangeState(Adapter,
							    STATION_STATE_REASSOCIATING);
						SendReAssocRequest
						    (Adapter);
					}
				}
				break;


			case C80211_MGMT_SC_Unspecified:
				DropPendingTxPackets(Adapter);
				ChangeState(Adapter,
					    STATION_STATE_SCANNING);
				UsbScan(Adapter);
				break;

			case C80211_MGMT_SC_AuthAlgNotSupported:	//WEP....
				Adapter->CurrentAuthentTransactionSeqNum =
				    0x0001;
				if (++Adapter->
				    AuthenticationRequestRetries >=
				    MAX_AUTHENTICATION_RETRIES) {
					dbgcond(DBG_AUTH,
						"max auth retries (%d) reached - giving up\n",
						MAX_AUTHENTICATION_RETRIES);
					DropPendingTxPackets(Adapter);
					ChangeState(Adapter,
						    STATION_STATE_SCANNING);
					UsbScan(Adapter);
				} else
					SendAuthRequest(Adapter, NULL, 0);
				break;

			case C80211_MGMT_SC_AuthTransSeqNumError:
				Adapter->CurrentAuthentTransactionSeqNum =
				    0x0001;

				if (++Adapter->
				    AuthenticationRequestRetries >=
				    MAX_AUTHENTICATION_RETRIES) {
					dbgcond(DBG_AUTH,
						"max auth retries (%d) reached - giving up\n",
						MAX_AUTHENTICATION_RETRIES);
					DropPendingTxPackets(Adapter);
					ChangeState(Adapter,
						    STATION_STATE_SCANNING);
					UsbScan(Adapter);
				} else
					SendAuthRequest(Adapter, NULL, 0);
				break;

			case C80211_MGMT_SC_AuthRejectTimeout:
				//jal: why not: 
				//Adapter->CurrentAuthentTransactionSeqNum = 0x0001;
				if (++Adapter->
				    AuthenticationRequestRetries >=
				    MAX_AUTHENTICATION_RETRIES) {
					dbgcond(DBG_AUTH,
						"max auth retries (%d) reached - giving up\n",
						MAX_AUTHENTICATION_RETRIES);
					DropPendingTxPackets(Adapter);
					ChangeState(Adapter,
						    STATION_STATE_SCANNING);
					UsbScan(Adapter);
				} else
					SendAuthRequest(Adapter, NULL, 0);
				break;

			case C80211_MGMT_SC_AuthRejectChallenge:
			default:
				ChangeState(Adapter,
					    STATION_STATE_MGMT_ERROR);

			}
		}		/* if(Adapter->StationState == STATION_STATE_AUTHENTICATING) */
		break;

	case C80211_SUBTYPE_MGMT_ASS_RESPONSE:
	case C80211_SUBTYPE_MGMT_REASS_RESPONSE:
		dbgcond(DBG_ASSOC, "%sAssoc response from BSSID "
			"%02x:%02x:%02x:%02x:%02x:%02x, status %u, assoc id %u\n",
			FrameSubType ==
			C80211_SUBTYPE_MGMT_REASS_RESPONSE ? "Re" : "",
			BSSID[0], BSSID[1], BSSID[2], BSSID[3], BSSID[4],
			BSSID[5],
			/* status is a _u16 in little endian format from arbitrary address 
			   jal TODO: find a nicer way to port the driver to big endian processors
			   and processors which cannot access _u16 at arbitrary addresses */
			Adapter->RxInBuff.
			WirelessPacket[MGMT_FRAME_BODY_OFFSET +
				       STATUS_IN_ASSOCIATION_RESP_OFFSET] |
			(Adapter->RxInBuff.
			 WirelessPacket[MGMT_FRAME_BODY_OFFSET +
					STATUS_IN_ASSOCIATION_RESP_OFFSET +
					1] << 8),
			Adapter->RxInBuff.
			WirelessPacket[MGMT_FRAME_BODY_OFFSET +
				       ASS_ID_IN_ASSOCIATION_RESP_OFFSET]);

		VnetTimer(Adapter, 0);

		if (memcmp(BSSID, Adapter->CurrentBSSID, 6) != 0) {
			dbgcond(DBG_ASSOC, "wrong BSSID, expected: "
				"%02x:%02x:%02x:%02x:%02x:%02x\n",
				Adapter->CurrentBSSID[0],
				Adapter->CurrentBSSID[1],
				Adapter->CurrentBSSID[2],
				Adapter->CurrentBSSID[3],
				Adapter->CurrentBSSID[4],
				Adapter->CurrentBSSID[5]);
			Adapter->Stats.RxMgmtPacketsError++;
			return;
		}
		if ((Adapter->StationState == STATION_STATE_ASSOCIATING) ||
		    (Adapter->StationState ==
		     STATION_STATE_REASSOCIATING)) {
			AssociationRespFrameBytesToGet =
			    MIN(Adapter->RxInBuff.WLength - 4, 16);
			AssociationRspnsFrame =
			    Adapter->RxInBuff.WirelessPacket +
			    MGMT_FRAME_BODY_OFFSET;

			(UCHAR) Adapter->ErrorCode =
			    (UCHAR) *
			    (PUSHORT) &
			    AssociationRspnsFrame
			    [STATUS_IN_ASSOCIATION_RESP_OFFSET];

			AssocID = *((PUSHORT) &(AssociationRspnsFrame [ASS_ID_IN_ASSOCIATION_RESP_OFFSET]));
			SupportedRatesLength =
			    AssociationRspnsFrame
			    [SUP_RATES_LENGTH_IN_ASSOCIATION_RESP_OFFSET];

			if (SupportedRatesLength > OPER_RATE_SIZE) {
				SupportedRatesLength = OPER_RATE_SIZE;
			}

			memcpy(SupportedRates,
			       &AssociationRspnsFrame
			       [SUP_RATES_IN_ASSOCIATION_RESP_OFFSET],
			       SupportedRatesLength);

			switch (Adapter->ErrorCode) {
			case C80211_MGMT_SC_Success:
				Adapter->flags |=
				    (StationWasAssociated |
				     StationIsAssociated | HeardBeacons);
				AssocID = AssocID & 0x3fff;	/* ??? */
				Adapter->AssocID = AssocID;
				Adapter->AssociationRequestRetries = 0;
				Adapter->ReAssociationRequestRetries = 0;
				VnetTimer(Adapter, 20);
				ChangeState(Adapter, STATION_STATE_READY);
				if(Adapter->PowerMgmtMode){
					SetAssocID(Adapter);
				}
				break;

			case C80211_MGMT_SC_Unspecified:
				//jal: If Access is denied, shouldn't we better go for another BSS ???
			case C80211_MGMT_SC_AssDenied:
			case C80211_MGMT_SC_AssDeniedHandleAP:
				if (FrameSubType ==
				    C80211_SUBTYPE_MGMT_ASS_RESPONSE) {
					assert(Adapter->StationState ==
					       STATION_STATE_ASSOCIATING);
					if (++Adapter->
					    AssociationRequestRetries >
					    MAX_ASSOCIATION_RETRIES) {
						DropPendingTxPackets
						    (Adapter);
						ChangeState(Adapter,
							    STATION_STATE_SCANNING);
						UsbScan(Adapter);
					} else {
						SendAssocRequest(Adapter);
					}
				} else {
					assert(Adapter->StationState ==
					       STATION_STATE_REASSOCIATING);
					if (++Adapter->
					    ReAssociationRequestRetries >
					    MAX_ASSOCIATION_RETRIES) {
						DropPendingTxPackets
						    (Adapter);
						ChangeState(Adapter,
							    STATION_STATE_SCANNING);
						UsbScan(Adapter);
					} else {
						SendReAssocRequest
						    (Adapter);
					}
				}
				break;

			case C80211_MGMT_SC_AssDeniedBSSRate:
			case C80211_MGMT_SC_SupportCapabilities:
			default:
				ChangeState(Adapter,
					    STATION_STATE_MGMT_ERROR);
			}	/* switch (Adapter->ErrorCode) */
		}		/* if ((Adapter->StationState == STATION_STATE_ASSOCIATING) ||
				   (Adapter->StationState == STATION_STATE_REASSOCIATING)) */
		break;

	case C80211_SUBTYPE_MGMT_DISASSOSIATION:

		dbgcond(DBG_DISASS, "Disassociation from BSSID "
			"%02x:%02x:%02x:%02x:%02x:%02x, flags x%lx, state %d, op mode %d\n",
			BSSID[0], BSSID[1], BSSID[2], BSSID[3], BSSID[4],
			BSSID[5], Adapter->flags, Adapter->StationState,
			Adapter->OperatingMode);

		if (!(Adapter->flags & StationIsAssociated) ||
		    Adapter->OperatingMode == AD_HOC_MODE)
			return;
		if (memcmp(BSSID, Adapter->CurrentBSSID, 6) != 0) {
			dbgcond(DBG_AUTH, "wrong BSSID, expected: "
				"%02x:%02x:%02x:%02x:%02x:%02x\n",
				Adapter->CurrentBSSID[0],
				Adapter->CurrentBSSID[1],
				Adapter->CurrentBSSID[2],
				Adapter->CurrentBSSID[3],
				Adapter->CurrentBSSID[4],
				Adapter->CurrentBSSID[5]);
			Adapter->Stats.RxMgmtPacketsError++;
			return;
		}

		ChangeState(Adapter, STATION_STATE_ASSOCIATING);
		Adapter->AssociationRequestRetries = 0;
		SendAssocRequest(Adapter);
		break;

	case C80211_SUBTYPE_MGMT_Deauthentication:

		dbgcond(DBG_DISASS, "Deauthentication from BSSID "
			"%02x:%02x:%02x:%02x:%02x:%02x, flags x%lx, state %d, op mode %d\n",
			BSSID[0], BSSID[1], BSSID[2], BSSID[3], BSSID[4],
			BSSID[5], Adapter->flags, Adapter->StationState,
			Adapter->OperatingMode);

		if (!(Adapter->flags & StationIsAuthenticated) ||
		    Adapter->OperatingMode == AD_HOC_MODE)
			return;

		if (memcmp(BSSID, Adapter->CurrentBSSID, 6) != 0) {
			dbgcond(DBG_AUTH, "wrong BSSID, expected: "
				"%02x:%02x:%02x:%02x:%02x:%02x\n",
				Adapter->CurrentBSSID[0],
				Adapter->CurrentBSSID[1],
				Adapter->CurrentBSSID[2],
				Adapter->CurrentBSSID[3],
				Adapter->CurrentBSSID[4],
				Adapter->CurrentBSSID[5]);
			Adapter->Stats.RxMgmtPacketsError++;
			return;
		}

		Adapter->CurrentAuthentTransactionSeqNum = 0x0001;
		Adapter->AuthenticationRequestRetries = 0;
		ChangeState(Adapter, STATION_STATE_AUTHENTICATING);
		SendAuthRequest(Adapter, NULL, 0);
		break;

	default:
		err("unknown frame subtype %d", FrameSubType);
	}			/* switch(FrameSubType) */
}

static const UCHAR SNAP_RFC1024[6] =
    { 0xaa, 0xaa, 0x03, 0x00, 0x00, 0x00 };
static const UCHAR SNAP_ETHERNETII[6] =
    { 0xaa, 0xaa, 0x03, 0x00, 0x00, 0xF8 };
static const UCHAR STATIC_ETHERTYPE_8137[2] = { 0x81, 0x37 };
static const UCHAR STATIC_ETHERTYPE_80F3[2] = { 0x80, 0xF3 };

void RxData(PVNet_ADAPTER Adapter)
{
	struct sk_buff *skb;
	USHORT PacketLength;
	UCHAR MoreFragments = 0;
	UCHAR PacketFragmentNo;
	UCHAR ProcessPacket = FALSE;
	USHORT PacketSequenceNo;
	BOOLEAN IP_packet;
	UCHAR DataOffset = 0;
	char buf[2 * 32 + 1] __attribute__ ((unused));

	//jal: RSSI, LinkQuality and NoiseLevel in RxInBuff contains zero ???
	dbgcond(DBG_RXDATA,
		"Wlen x%x, rate %d, newbss %d, frag %d, rssi %d,"
		" linkqual %d, noiselevel %d,"
		" data %s (Adapter->flags %lx, netdev->state %lx)\n",
		Adapter->RxInBuff.WLength, Adapter->RxInBuff.RxRate,
		Adapter->RxInBuff.newbss, Adapter->RxInBuff.Fragmentation,
		Adapter->RxInBuff.RSSI, Adapter->RxInBuff.LinkQuality,
		Adapter->RxInBuff.NoiseLevel, buf2str(buf,
						      Adapter->RxInBuff.
						      WirelessPacket,
						      (sizeof(buf) -
						       1) / 2),
		Adapter->flags, Adapter->net->state);

	MoreFragments = Adapter->RxInBuff.WirelessPacket[1] & 0x04;
	PacketFragmentNo = Adapter->RxInBuff.WirelessPacket[22] & 0x0f;
	PacketSequenceNo = (Adapter->RxInBuff.WirelessPacket[23] << 8) |
	    (Adapter->RxInBuff.WirelessPacket[22] & 0xf0);

	if ((MoreFragments == 0) && (PacketFragmentNo == 0)) {
		memcpy(&Adapter->RxBuffUp, &Adapter->RxInBuff,
		       12 + Adapter->RxInBuff.WLength);
		ProcessPacket = TRUE;
	} else {
		if ((MoreFragments != 0) && (PacketFragmentNo == 0)) {
			memcpy(&Adapter->RxBuffUp, &Adapter->RxInBuff,
			       Adapter->RxInBuff.WLength + 12 - 4);
		} else if ((MoreFragments != 0) &&
			   (memcmp(Adapter->RxBuffUp.WirelessPacket,
				   Adapter->RxInBuff.WirelessPacket + 16,
				   6) == 0)) {
			memcpy(Adapter->RxBuffUp.WirelessPacket +
			       Adapter->RxBuffUp.WLength,
			       Adapter->RxInBuff.WirelessPacket + 24,
			       Adapter->RxInBuff.WLength - 28);
			Adapter->RxBuffUp.WLength +=
			    Adapter->RxInBuff.WLength - 28;
		} else if ((MoreFragments == 0)
			   &&
			   (memcmp
			    (Adapter->RxBuffUp.WirelessPacket,
			     Adapter->RxInBuff.WirelessPacket + 16,
			     6) == 0)) {
			ProcessPacket = TRUE;
			memcpy(Adapter->RxBuffUp.WirelessPacket +
			       Adapter->RxBuffUp.WLength,
			       Adapter->RxInBuff.WirelessPacket + 24,
			       Adapter->RxInBuff.WLength - 28);
			Adapter->RxBuffUp.WLength +=
			    Adapter->RxInBuff.WLength - 28;
		}
	}

	if (!ProcessPacket) {
		dbgcond(DBG_RXDATA, "fragmented packet\n");
		return;
	}
	if (((memcmp
	      (Adapter->RxBuffUp.WirelessPacket + 24, SNAP_ETHERNETII,
	       6) == 0)
	     &&
	     (memcmp
	      (Adapter->RxBuffUp.WirelessPacket + 30,
	       STATIC_ETHERTYPE_8137, 2) == 0))
	    || ((Adapter->RxBuffUp.WirelessPacket[24] == 0xaa)
		&& (Adapter->RxBuffUp.WirelessPacket[25] == 0xaa)
		&&
		(memcmp
		 ((PUCHAR) Adapter->RxBuffUp.WirelessPacket + 30,
		  STATIC_ETHERTYPE_8137, 2) != 0)
		&&
		(memcmp
		 ((PUCHAR) Adapter->RxBuffUp.WirelessPacket + 30,
		  STATIC_ETHERTYPE_80F3, 2) != 0))) {
		IP_packet = TRUE;
	} else {
		Adapter->RxBuffUp.WirelessPacket[23] =
		    ((Adapter->RxBuffUp.WLength - 24 - 4) & 0x00FF);
		Adapter->RxBuffUp.WirelessPacket[22] =
		    ((Adapter->RxBuffUp.WLength - 24 - 4) >> 8);
		IP_packet = FALSE;
	}

	if (Adapter->OperatingMode == AD_HOC_MODE) {
		if (IP_packet) {
			memcpy(Adapter->RxBuffUp.WirelessPacket + 18,
			       Adapter->RxBuffUp.WirelessPacket + 4, 6);
			memcpy(Adapter->RxBuffUp.WirelessPacket + 24,
			       Adapter->RxBuffUp.WirelessPacket + 10, 6);
			PacketLength = Adapter->RxBuffUp.WLength - 18 - 4;
			DataOffset = 18;
		} else {
			memcpy(Adapter->RxBuffUp.WirelessPacket + 10,
			       Adapter->RxBuffUp.WirelessPacket + 4, 6);
			memcpy(Adapter->RxBuffUp.WirelessPacket + 16,
			       Adapter->RxBuffUp.WirelessPacket + 10, 6);
			PacketLength = Adapter->RxBuffUp.WLength - 10 - 4;
			DataOffset = 10;
		}
	} else if (Adapter->OperatingMode == INFRASTRUCTURE_MODE) {
		if (IP_packet) {
			memcpy(Adapter->RxBuffUp.WirelessPacket + 24,
			       Adapter->RxBuffUp.WirelessPacket + 16, 6);
			memcpy(Adapter->RxBuffUp.WirelessPacket + 18,
			       Adapter->RxBuffUp.WirelessPacket + 4, 6);
			PacketLength = Adapter->RxBuffUp.WLength - 22;	//18 - 4;
			DataOffset = 18;
		} else {
			memcpy(Adapter->RxBuffUp.WirelessPacket + 10,
			       Adapter->RxBuffUp.WirelessPacket + 4, 6);
			PacketLength = Adapter->RxBuffUp.WLength - 14;	//10 - 4;
			DataOffset = 10;
		}
	} else {
		assert(FALSE);
		return;
	}

	if (rx_kernel_part(Adapter, &skb, PacketLength, DataOffset) != 0) {
		Adapter->Stats.RxLost++;
		return;
	}

	Adapter->flags |= HeardBeacons;

	Adapter->net->last_rx = jiffies;
	Adapter->netstats->rx_packets++;
	Adapter->Stats.RxDataPacketsOk++;
	Adapter->netstats->rx_bytes += PacketLength;
	skb->dev = Adapter->net;
	skb->protocol = eth_type_trans(skb, Adapter->net);
	skb->ip_summed = CHECKSUM_NONE;
	netif_rx(skb);
}
