/*
 * linux/drivers/pcmcia/pxa_axim.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Copyright (c) 2003 Martin Demin
 *
 * Platform specific routines for Dell Axim PCMCIA.
 *
 */

#include <linux/kernel.h>
#include <linux/sched.h>

#include <pcmcia/ss.h>

#include <asm/hardware.h>
#include <asm/signal.h>

#include <asm/arch/pcmcia.h>
#include <asm/arch/irqs.h>
#include <asm/hardware/mq11xx.h>

#define AXIM_PCMCIA_SOCK0_IRQ	1
#define AXIM_PCMCIA_INS_GPIO	7
#define AXIM_PCMCIA_RDY_GPIO	8

static int 
pxa_axim_pcmcia_init(struct pcmcia_init *init)
{
	printk ("Dell Axim PCMCIA initialization\n");
//	GPSR0 = GPIO_bit(26);
//	GPSR1 =	GPIO_bit(63);

	set_GPIO_IRQ_edge (AXIM_PCMCIA_INS_GPIO, GPIO_BOTH_EDGES);
//	set_GPIO_IRQ_edge (AXIM_PCMCIA_RDY_GPIO, GPIO_BOTH_EDGES);

        if (request_irq (GPIO_2_80_TO_IRQ (AXIM_PCMCIA_INS_GPIO),
                         init->handler, SA_INTERRUPT, "PXA PCMCIA", NULL) < 0)
		return -1;

	return 1;
}


static int
pxa_axim_pcmcia_shutdown(void)
{
	free_irq (GPIO_2_80_TO_IRQ (AXIM_PCMCIA_INS_GPIO), NULL);
	return 0;
}

static int
pxa_axim_pcmcia_socket_state(struct pcmcia_state_array *state_array)
{
	state_array->state[0].detect = !((GPLR0>>7)&0x01);
	state_array->state[0].ready  = 1;
	state_array->state[0].bvd1   = 1;
	state_array->state[0].bvd2   = 1;
	state_array->state[0].wrprot = 0;
	state_array->state[0].vs_3v  = 1;
	state_array->state[0].vs_Xv  = 0;

	return 0;
}

static int
pxa_axim_pcmcia_get_irq_info(struct pcmcia_irq_info *info)
{
	info->irq = AXIM_IRQ_MQ1132_GPIO2;
	printk ("irq_info returns: %d\n",info->irq);
	return 0;
}

static int
pxa_axim_pcmcia_configure_socket(unsigned int sock, socket_state_t *state)
{
//	GPCR0 = GPIO_bit(26);
//	GPCR1 =	GPIO_bit(63);
	/* Apply power to socket */
	MQ11xx_SP08R |= 0x20;
	return 0;
}

struct pcmcia_low_level axim_pcmcia_ops = {
	pxa_axim_pcmcia_init,
	pxa_axim_pcmcia_shutdown,
	pxa_axim_pcmcia_socket_state,
	pxa_axim_pcmcia_get_irq_info,
	pxa_axim_pcmcia_configure_socket
};
