/*
 * Driver for iPAQ H5400 internal USB OHCI host controller
 *
 * Copyright 2003 Hewlett-Packard Company.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Jamey Hicks.
 *
 * History:
 *
 * 2003-03-19   Jamey Hicks        Created file.
 *
 */

#include <linux/module.h>
#include <linux/version.h>
#include <linux/config.h>
#include <linux/init.h>

#include <linux/slab.h>
#define CONFIG_PCI
#include <linux/pci.h> /* pci_pool defs */

#include <asm/arch/hardware.h>
#include <asm/arch-sa1100/h3600_hal.h>
#include <asm/irq.h>
#include <asm/arch-pxa/h5400-gpio.h>
#include <asm/arch-pxa/h5400-asic.h>
#include <asm/arch-pxa/h5400-irqs.h>

#include <linux/usb.h>
#include "usb-ohci.h"

extern int hc_add_ohci(struct pci_dev *dev, int irq, void *mem_base, unsigned long flags,
				 ohci_t **ohci, const char *name, const char *slot_name);
extern void hc_remove_ohci(ohci_t *ohci);

struct ohci *ohci;
void *mem_base;

void h5400_ohci_cleanup( void )
{
	if (ohci)
		hc_remove_ohci( ohci );

	iounmap(mem_base);

	h5400_asic_clock_enable (H5400_ASIC_CPM_CLKCON_USBHOST_CLKEN, 0);
}

static void msleep(unsigned int msec)
{
	current->state = TASK_INTERRUPTIBLE;
	schedule_timeout( (msec * HZ + 999) / 1000);
}

int h5400_ohci_init( void )
{
	struct pci_dev *dev = H5400_FAKE_PCIDEV;
	int irq = IRQ_H5400_USBH;
	unsigned long flags = 0;
	int result;
	int line = 0;

	mem_base = (void *)ioremap(H5400_ASIC_PHYS + _H5400_ASIC_USBHOST_Base, 0x10000);

	/* make sure the clocks are enabled */
	h5400_asic_write_register (H5400_ASIC_CPM_PllControl, 0x60002);	/* value from wince via bootblaster */
	h5400_asic_clock_enable (H5400_ASIC_CPM_CLKCON_USBHOST_CLKEN, 1);
	h5400_asic_clock_enable (H5400_ASIC_CPM_CLKCON_UCLK_EN, 0);

	msleep(250);

	result = hc_add_ohci(dev, irq, mem_base, flags, &ohci, "h5400-ohci", "asic");
	if (result) { line = __LINE__; goto init_fail; }

	return 0;

init_fail:
	printk("%s:%d: %s: FAILURE!  result=%d. Exiting...\n", __FILE__, line, __FUNCTION__, result);
	h5400_ohci_cleanup();
	return result;
}

void h5400_ohci_exit( void )
{
	h5400_ohci_cleanup();
}

module_init(h5400_ohci_init);
module_exit(h5400_ohci_exit);
