/*
 *  linux/arch/arm/mach-omap/time.c
 *
 * BRIEF MODULE DESCRIPTION
 *   MPU timer functions
 *
 * Copyright (C) 2000 RidgeRun, Inc. (http://www.ridgerun.com)
 * Author: RidgeRun, Inc.
 *         Greg Lonnon (glonnon@ridgerun.com) or info@ridgerun.com
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/module.h>

#include <asm/system.h>
#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/leds.h>
#include <asm/irq.h>
#include <asm/arch/ck.h>

#include <asm/arch/hwtimer.h>

static int mputimer_started[3] = {0,0,0};

static inline void __noinstrument timer_delay(void)
{
	int i;
	for (i=0; i<100000; i++) ;
}

void __noinstrument start_mputimer(int n, unsigned int ptv, 
						 unsigned long load_val)
{
	volatile mputimer_regs_t* timer = mputimer_base(n);

	mputimer_started[n] = 0;
	timer->cntl = MPUTIM_CLOCK_ENABLE | (ptv << 2);
	timer_delay();

	timer->load_tim = load_val;
	timer_delay();
	timer->cntl = (MPUTIM_CLOCK_ENABLE | (ptv << 2) | MPUTIM_AR | MPUTIM_ST);
	mputimer_started[n] = 1;
}

EXPORT_SYMBOL(start_mputimer);