/*
 *  linux/arch/arm/mach-omap/av500_fiq.S
 *
 * BRIEF MODULE DESCRIPTION
 *   FIQ handler function
 *
 * Copyright (C) 2004 Archos SA.
 * Author:
 *         Matthias Welwarsky <welwarsky@archos.com>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/linkage.h>
#include <asm/assembler.h>
#include <asm/hardware.h>
		.text

		.global	SYMBOL_NAME(irr_fiq_end)
		.global	SYMBOL_NAME(av500_fiq_handler)
ENTRY(irr_fiq_start)
		@ we have initialized a small stack for FIQ mode before,
		@ just push the non-banked registers plus LR to the stack
		@ correct LR before
		sub	lr, lr, #4			@ 0x0000
		stmfd	sp!, {r0-r7, lr}		@ 0x0004
		
		@ read the SIR_FIQ register ...
		ldr	r8, .Lih1_base			@ 0x0008
		ldr	r9, [r8, #IRQ_SIR_FIQ]		@ 0x000b
		@ ... and write to the control register to acknowledge the FIQ
		mov	r9, #2				@ 0x0010
		str	r9, [r8, #IRQ_CONTROL_REG]	@ 0x0014

		@ call C FIQ handler		
		mov	lr, pc				@ 0x0018
		ldr	pc, .Lfiq_handler		@ 0x001b
		ldmfd	sp!, {r0-r7, pc}^		@ 0x0020

		mov	r0, r0
		mov	r0, r0
		mov	r0, r0
		mov	r0, r0
.Lfiq_handler:	.long	SYMBOL_NAME(av500_fiq_handler)
.Lih1_base:	.long	OMAP_IH1_BASE
SYMBOL_NAME(irr_fiq_end):
