/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*/

#ifndef ASIC2_SHARED_H
#define ASIC2_SHARED_H

enum ASIC_SHARED {
	ASIC_SHARED_CLOCK_EX1 = 1,  /* Bit fields */
	ASIC_SHARED_CLOCK_EX2 = 2
};

void h3600_asic_shared_add( unsigned long *s, enum ASIC_SHARED v );
void h3600_asic_shared_release( unsigned long *s, enum ASIC_SHARED v );

int h3600_asic_shared_init (void);
void h3600_asic_shared_cleanup (void);
void h3600_asic_shared_debug (int *ex1, int *ex2);

void h3600_asic_clock_enable (unsigned long bit, int on);

#endif
