/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002, September 2002
*/

#include <linux/module.h>
#include <linux/version.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/pm.h>
#include <linux/sysctl.h>
#include <linux/proc_fs.h>
#include <linux/ctype.h>
#include <linux/spi/spi.h>
#include <linux/delay.h>

#include <asm/irq.h>
#include <asm/arch/hardware.h>
#include <asm/arch-sa1100/h3600_hal.h>

#include "../mach-sa1100/h3600_asic_core.h"
#include "h3600_asic_battery.h"

#ifdef CONFIG_SA1100_H3800
#include <asm/arch/h3600_asic.h>
#endif
#ifdef CONFIG_ARCH_H3900
#include <asm/arch/h3900_asic.h>
#include <asm/arch/h3900-gpio.h>
#endif

#include "asic2_shared.h"

static u8 rosella_owm_read_data (void)
{
	return H3800_ASIC2_OWM_Data;
}

static u8 rosella_owm_read_interrupt (void)
{
	return H3800_ASIC2_OWM_Interrupt;
}

static u8 rosella_owm_read_command (void)
{
	return H3800_ASIC2_OWM_Command;
}

static void rosella_owm_write_data (u8 val)
{
	H3800_ASIC2_OWM_Data = val;
}

static void rosella_owm_write_command (u8 val)
{
	H3800_ASIC2_OWM_Command = val;
}

static void rosella_owm_up (struct h3600_asic_owmdev *owm)
{
	h3600_asic_shared_add (&owm->shared, ASIC_SHARED_CLOCK_EX1);
	h3600_asic_clock_enable (ASIC2_CLOCK_OWM, 1);
	H3800_ASIC2_OWM_ClockDivisor      = 2;
	H3800_ASIC2_OWM_InterruptEnable   = OWM_INTEN_ERBF | OWM_INTEN_IAS | OWM_INTEN_EPD;
	H3800_ASIC2_INTR_MaskAndFlag     |= ASIC2_INTMASK_OWM; /* Turn on ASIC interrupts */
}

static void rosella_owm_down (struct h3600_asic_owmdev *owm)
{
	H3800_ASIC2_INTR_MaskAndFlag     &= ~ASIC2_INTMASK_OWM; /* Turn off ASIC interrupts */
	H3800_ASIC2_OWM_InterruptEnable   = 0;
	h3600_asic_clock_enable (ASIC2_CLOCK_OWM, 0);
	h3600_asic_shared_release (&owm->shared, ASIC_SHARED_CLOCK_EX1);
}

#ifdef CONFIG_ARCH_H3900

static void h3900_set_charger (int on)
{
	unsigned long flags;

	local_irq_save (flags);

	if (on)
		H3900_ASIC3_GPIO_B_OUT |= GPIO3_CH_TIMER;
	else
		H3900_ASIC3_GPIO_B_OUT &= ~GPIO3_CH_TIMER;

	local_irq_restore (flags);
}

static int h3900_ac_power (void)
{
	return (GPLR0 & GPIO_H3900_AC_IN_N) ? 0 : 1;
}

struct asic2_battery_ops h3900_battery_ops = 
{
	owm_irq:		IRQ_H3800_OWM,
	
	owm_read_data:		rosella_owm_read_data,
	owm_read_interrupt:	rosella_owm_read_interrupt,
	owm_read_command:	rosella_owm_read_command,
	
	owm_write_data:		rosella_owm_write_data,
	owm_write_command:	rosella_owm_write_command,

	owm_up:			rosella_owm_up,
	owm_down:		rosella_owm_down,

	set_charger:		h3900_set_charger,
	ac_power:		h3900_ac_power
};

#endif /* CONFIG_ARCH_H3900 */

#ifdef CONFIG_SA1100_H3800

static void h3800_set_charger (int on)
{
	unsigned long flags;

	local_irq_save (flags);

	if (on)
		H3800_ASIC1_GPIO_OUT |= GPIO1_CH_TIMER;
	else
		H3800_ASIC1_GPIO_OUT &= ~GPIO1_CH_TIMER;

	local_irq_restore (flags);
}

static int h3800_ac_power (void)
{
	return (GPLR & GPIO_H3800_AC_IN) ? 0 : 1;
}

struct asic2_battery_ops h3800_battery_ops = 
{
	owm_irq:		IRQ_H3800_OWM,
	
	owm_read_data:		rosella_owm_read_data,
	owm_read_interrupt:	rosella_owm_read_interrupt,
	owm_read_command:	rosella_owm_read_command,
	
	owm_write_data:		rosella_owm_write_data,
	owm_write_command:	rosella_owm_write_command,

	owm_up:			rosella_owm_up,
	owm_down:		rosella_owm_down,

	set_charger:		h3800_set_charger,
	ac_power:		h3800_ac_power
};

#endif /* CONFIG_SA1100_H3800 */

