/*
 * arch/arm/arch-s3c2410/dma-s3c2410.c
 *
 * Copyright (C) 2002 SAMSUNG ELECTRONIS 
 *             SW.LEE  <hithcar@sec.samsung.com>
 *     
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

/************************************************
 *
 *Name
 *
 *Purpose
 *
 *Entry
 *
 *Exception
 *
 *************************************************/


#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/spinlock.h>
#include <linux/slab.h>
#include <linux/errno.h>
#include <linux/delay.h>

#include <asm/system.h>
#include <asm/irq.h>
#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/dma.h>
#include <asm/mach/dma.h>

#ifdef DEBUG
#define DPRINTK( s, arg... )  printk( "dma<%s>: " s, dma->device_id , ##arg )
#define swldebug(x...)   printk( ##x )
#else
#define DPRINTK( x... )
#define swldebug( x... )
#endif

static s3c2410_dma_t s3c2410_dma_chan[MAX_S3C2410_DMA_CHANNELS];




static void dmaDev_buf_enable(int dma_type)
{
        switch (dma_type ) {
	default:
	        rIISCON |= 0x1;		/* IIS Interface start */
	}
}


static void dmaDev_pause_on(int dma_type)
{
        switch (dma_type ) {
	default:
	        rIISCON = (rIISCON&~(1<<3))|(1<<3); /* Pause Tx */
	}
}

static void dmaDev_pause_stop(int dma_type)
{
        switch (dma_type ) {
	default:
	        rIISCON = (rIISCON&~(1<<3))|(0<<3); /* Stop Pause*/
	}
}

static void IIS_Interface_init(void);
static void dmaDev_Config(int dma_type)
{
         switch (dma_type ) {
	/*
	 * switch (){
	 * case A:
	 * case B:
	 * }
	 */
         default:
                 IIS_Interface_init();
	 }
}

/* 
 * This functions cann't be called in s3c2410_dma_flush_all(dmach_t channel)
 * and I don't know where to use this function
 * Please let me know~~
 */
static void dmaDev_finished(s3c2410_dma_t * dma)
{

        switch (dma->device ) {
	default:
                rIISCON =  0;	/* reset value */
		dma->regs->DMASKTRIG = (1<<2);
		rIISFCON = 0x0;		/* For FIFO flush */
	}
}


static inline int s3c2410_start_dma(s3c2410_dma_t * dma)
{
	dma_buf_t *buf;
	dma_regs_t *regs = dma->regs;

	swldebug(__FUNCTION__  "      Starting   \n");

	if (dma->tail->size> MAX_DMA_TRANSFER_SIZE ) 
	        printk(__FUNCTION__" DMA size over \n");

        regs->DISRC = dma->tail->dma_start;
	
	regs->DCON  = (regs->DCON&~(0xfffff)) | dma->tail->size/2;
	regs->DMASKTRIG = (0<<2)|(1<<1)|0; /* no stop, DMA2 channe on, no-sw trigger */
	dmaDev_buf_enable(1);

	buf = dma->tail;
	if(!buf) {
	        printk(__FUNCTION__"\n\n  ONE BUFFER DATA ---> UNEXPECTED CASE   \n\n");
		return 0;
	}
	dma->curr = buf;
	dma->tail = buf->next;

	swldebug("               s  CURRC 0X%08X  \n",dma->regs->DCSRC );
	swldebug("               s  DISRC 0X%08X  \n",dma->regs->DISRC );
	swldebug("               s  DSTAT 0X%08X  \n",dma->regs->DSTAT&0xfffff);

	while( (regs->DSTAT&0xfffff)==0 );

	regs->DISRC       = dma->tail->dma_start;
	regs->DCON        = (regs->DCON&~(0xfffff)) |dma->tail->size/2;

	swldebug("               t  CURRC 0X%08X  \n",dma->regs->DCSRC );
	swldebug("               t  DISRC 0X%08X  \n",dma->regs->DISRC );
	swldebug("               t  DSTAT 0X%08X  \n",dma->regs->DSTAT&0xfffff);
	       
	return 0;		                  /* Succesful Return value */
}


/* This must be called with IRQ disabled */
static void dmaDone_irq_handler(int irq, void *dev_id, struct pt_regs *regs)
{
	s3c2410_dma_t *dma = (s3c2410_dma_t *) dev_id;
	dma_buf_t *buf=dma->curr;
	
	swldebug("               0  CURRC 0X%08X  \n",dma->regs->DCSRC );
	swldebug("               0  DISRC 0X%08X  \n",dma->regs->DISRC );
	swldebug("               0  DSTAT 0X%08X  \n",dma->regs->DSTAT&0xfffff);
	dma->usedQueueCnt++;

	if(!dma->callback) { 
	        printk(__FUNCTION__ "\n\n  WHERE IS MY CALLBACK FUNCTION ?  \n\n");
		return;
	}
	
				/* MAKE SURE TO CORRECT SIZE  */
	dma->callback(buf->id,buf->size);/* wake up current done buffer  */
	if(buf) kfree(buf);

	/*------------------------------------*/
	// Waiting ....let next buffer loaded
	while( ((dma->regs->DSTAT&0xfffff)== 0) && dma->tail);
	/*------------------------------------*/

	dma->curr = dma->tail;

	swldebug("               1  CURRC 0X%08X  \n",dma->regs->DCSRC );
	swldebug("               1  DISRC 0X%08X  \n",dma->regs->DISRC );
	swldebug("               1  DSTAT 0X%08X   \n",dma->regs->DSTAT&0xfffff);

	if(!dma->curr){ 
          	swldebug(__FUNCTION__ " ONE BUFFER CASE DATA END      \n");
		s3c2410_dma_flush_all(2);
		s3c2410_free_dma(2);
		return;
	}

	dma->tail = dma->tail->next;
	buf       = dma->tail;

	if(!buf) {
	        swldebug(__FUNCTION__ " OVER TWO,THREE  BUFFER CASE DATA END   \n");
		return;
	}

	dma->regs->DISRC =  buf->dma_ptr;
	dma->regs->DCON  = (dma->regs->DCON&~(0xfffff))|buf->size/2 ;

	swldebug("               2  CURRC 0X%08X  \n",dma->regs->DCSRC );
	swldebug("               2  DISRC 0X%08X  \n",dma->regs->DISRC );
	swldebug("               2  DSTAT 0X%08X   \n",dma->regs->DSTAT&0xfffff);

}


/* 
 * if channel id defined, 
 * IRQ Number is consequently defined  by  s3c2410_init_dma() 
 * 
 */
int s3c2410_request_dma (dmach_t channel, const char *device_id,
			dma_device_t device)
{
	s3c2410_dma_t *dma = NULL;
	int err= 0;

	if (s3c2410_dma_chan[channel].in_use) {
	         printk(" Request DMA Channel already used channel %d \n",channel);
		 return  -EBUSY;
	} else {
	         dma = &s3c2410_dma_chan[channel]; 
		 dma->in_use = 1;    /* IRQ NO already assigned in  s3c2410_dma_init */
        } 
	
	err=request_irq(dma->irq,dmaDone_irq_handler,SA_INTERRUPT,device_id,(void *) dma);
	if (err) {
	         printk(KERN_ERR"%s: unable to request IRQ %d for DMA channel\n",
		       device_id, dma->irq);
		 return err;
	}
	dma->device_id = device_id;
	dma->device = device;
	dma->callback = NULL;

#ifdef FULL_DMA_DEVICE_SUPPORT
	switch(dma->device) {
	        case A: break;
	        case B: break;
	        default:
	}
#else  /* Only Sound */
	dma->regs->DISRCC = (0<<1)|(0<<0); /* AHB,Address increment  */
	dma->regs->DIDSTC = (1<<1)|(1<<0); /* Destination peripheral BUS s address fixed */
#endif
	dma->regs->DIDST = (unsigned long )dma->device;
	/*
	 * DCON[19:0] initial Transfer count: assigned by s3c2410_start_dma funtion 
	 */
	dma->regs->DCON =
	  (1<<31)+(0<<30)+(1<<29)+(0<<28)+(0<<27)+(0<<24)+(1<<23)+(0<<22)+(1<<20);
	/* handshake, sync PCLK, TC int, single tx, single service, I2SSDO, I2S request, 
           auto-reload,half-word , size missing */
	dmaDev_Config(1);
	return 0;
}

int s3c2410_dma_set_callback(dmach_t channel, dma_callback_t cb)
{
	s3c2410_dma_t *dma = &s3c2410_dma_chan[channel];

	if ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS || !dma->in_use)
		return -EINVAL;
	dma->callback = cb;
	DPRINTK("cb = %p\n", cb);
	return 0;
}



/*
 * data  : the buffer's physical address 
 */

int s3c2410_dma_queue_buffer(dmach_t channel, void *buf_id,
			    dma_addr_t data, int size)
{
	s3c2410_dma_t *dma;
	dma_buf_t *buf;
	int flags;

	dma = &s3c2410_dma_chan[channel];


	if ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS || !dma->in_use)
		return -EINVAL;

	buf = kmalloc(sizeof(*buf), GFP_ATOMIC);
	if (!buf)return -ENOMEM;

	buf->next = NULL;
	buf->dma_ptr = buf->dma_start = data;
	buf->size = size;
	buf->id = buf_id;
	
	swldebug("queueing b=%#x a=%#x s=%d\n", (unsigned int)buf_id, data, size);

	switch(dma->queueCnt) {
	case 0:			/* first call */
	         swldebug( "============> first call    \n");
		 dma->queueCnt++;
		 dma->head = buf;
		 dma->tail = buf;
		 return 0;

	case 1:			/* second call */
	         swldebug( "============> second call        \n");
		 dma->queueCnt++;
		 dma->tail->next = buf;
		 dma->head = buf;
		 s3c2410_start_dma(dma);
		 return 0;

	default:
	         break;
	}

	local_irq_save(flags);
	dma->queueCnt++;
	if (dma->head) {
	         dma->head->next = buf;
	}
	dma->head = buf;
	if (!dma->tail) {
	         dma->tail = buf;
	}
	local_irq_restore(flags);
	return 0;
}


int s3c2410_dma_stop(dmach_t channel)
{
	s3c2410_dma_t *dma = &s3c2410_dma_chan[channel];
	int flags;

	if (dma->stopped)
		return 0;
	local_irq_save(flags);
	dma->stopped = 1;

	dmaDev_pause_on(1);
#if 0
	if (dma->curr) {
		dma_buf_t *buf = dma->curr;
		dma->tail = buf;
		dma->curr = NULL;
	}
#endif
	local_irq_restore(flags);
	return 0;
}


int s3c2410_dma_resume(dmach_t channel)
{
	s3c2410_dma_t *dma = &s3c2410_dma_chan[channel];

	if ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS || !dma->in_use)
		return -EINVAL;

	if (dma->stopped) {
		int flags;
		save_flags_cli(flags);
		dma->stopped = 0;
		dmaDev_pause_stop(1);
		restore_flags(flags);
	}
	return 0;
}



int s3c2410_dma_set_spin(dmach_t channel, dma_addr_t addr, int size)
{
	s3c2410_dma_t *dma = &s3c2410_dma_chan[channel];
	int flags;

	if ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS || !dma->in_use)
		return -EINVAL;

	DPRINTK("set spin %d at %#x\n", size, addr);
	local_irq_save(flags);
	dma->spin_addr = addr;
	dma->spin_size = size;
	local_irq_restore(flags);
	return 0;
}

int s3c2410_dma_flush_all(dmach_t channel)
{
	s3c2410_dma_t *dma = &s3c2410_dma_chan[channel];
	dma_buf_t *buf, *next_buf;
	int flags;

	if ( ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS)|| !dma->in_use)
		return -EINVAL;

	local_irq_save(flags);
	buf = dma->tail;
	if (!buf) buf = dma->tail;
	dma->head = dma->tail = dma->curr = NULL;
	dma->stopped = 0;
	local_irq_restore(flags);
	while (buf) {
		next_buf = buf->next;
		kfree(buf);
		buf = next_buf;
	}
  	swldebug("%s[%d] %s :  flushed  \n", __FILE__,__LINE__,__FUNCTION__);
	return 0;
}


void s3c2410_free_dma(dmach_t channel)
{
	s3c2410_dma_t *dma;

	if ((unsigned)channel >= MAX_S3C2410_DMA_CHANNELS) return;
 	swldebug("%s[%d] %s :   \n", __FILE__,__LINE__,__FUNCTION__);
	dma = &s3c2410_dma_chan[channel];
	if (!dma->in_use) {
		swldebug(KERN_ERR "Trying to free free DMA%d\n", channel);
		return;
	}
	
	s3c2410_dma_flush_all(channel);
	dmaDev_finished(dma);

	free_irq(IRQ_DMA0 + channel, (void *) dma);
	dma->in_use = 0;
	dma->queueCnt = 0;
	dma->usedQueueCnt = 0;
}


EXPORT_SYMBOL(s3c2410_request_dma);
EXPORT_SYMBOL(s3c2410_dma_set_callback);
EXPORT_SYMBOL(s3c2410_dma_set_spin);
EXPORT_SYMBOL(s3c2410_dma_queue_buffer);
EXPORT_SYMBOL(s3c2410_dma_stop);
EXPORT_SYMBOL(s3c2410_dma_resume);
EXPORT_SYMBOL(s3c2410_dma_flush_all);
EXPORT_SYMBOL(s3c2410_free_dma);


	/* 
	 * IIS DMA,FIFO Prescaler Setting
	 * Where is IIS_Interface_init() in place ?
         *    1. DMA module  arm/arch/mach-s3c2410/dma.c
         *    2. audio module drivers/sound/s3c2410-audio.c
         *    3. l3 module   drivers/l3/l3-s3c2410.c 
         *    4. uda1341 module drivers/sound/s3c2410-uda1341.c
         *
         * as far as I know, 4 *^^* see below 
         */

static void IIS_Interface_init(void)
{
  /*  rIISPSR  moved into s3c2410-uda1341.c ioctl functions */
  
  /*  Trasmit DMA FIFO  service request , 
   *  Rx idle,II Prescaler Enable, IIS INTERFACE DISABLE 
   */
    rIISCON = (1<<5) + (1<<2) + (1<<1);        

   /* Master mode[8],Tx mode[7:6],Low for Left Channel[5],IIS format[4]
    * 16bit ch.[3],CDCLK 256fs[2],IISCLK 32fs[1:0] 
    */
#if (AUDIO_CODEC_CLOCK == 256)	
    rIISMOD = (0<<8) + (2<<6) + (0<<5) + (0<<4) + (1<<3) + (0<<2) + (1<<0);
#else
    rIISMOD = (0<<8) + (2<<6) + (0<<5) + (0<<4) + (1<<3) + (1<<2) + (1<<0);
#endif	
    
    rIISFCON = (1<<15) + (1<<13);        //Tx DMA,Tx FIFO --> start piling....
}


static int __init s3c2410_init_dma(void)
{
	int channel;
	for (channel = 0; channel < MAX_S3C2410_DMA_CHANNELS; channel++) {
	     s3c2410_dma_chan[channel].regs =  (dma_regs_t *)ARRAY_DISRC(channel);
	     s3c2410_dma_chan[channel].irq  = IRQ_DMA0 + channel;
	}
	return 0;
}

__initcall(s3c2410_init_dma);
