/*
 *  linux/bootldr/bootldr.c
 *
 *  Copyright (C) 2003 Joshua Wise
 *  Bootloader port to Linux Kernel, April 30, 2003
 *
 *  cli for LAB
 */

#include <linux/init.h>
#include <asm/dma.h>
#include <asm/io.h>
#include <linux/config.h>
#include <linux/slab.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/unistd.h>
#include <linux/ctype.h>
#include <linux/blk.h>
#include <linux/fd.h>
#include <linux/fs.h>
#include <linux/tty.h>
#include <linux/termios.h>

void setbaud(int baud);
extern void putstr(char* string);
//#ifdef CONFIG_ARCH_SA1110
#define MAJOR 204
#define MINOR 5
//#else
//#define MAJOR 10
//#define MINOR 240
//#endif

asmlinkage long sys_mknod(char *name, int mode, dev_t dev);
//asmlinkage long sys_open(const char * filename, int flags, int mode);

extern void bootldr_main();

int labserfd;

void lab_run()
{
	int err;
	
	printk(KERN_INFO /* need it to display. */ "lab: Starting LAB [Linux As Bootloader]\n");
	printk(KERN_INFO "lab: Mounting ramfs...\n");
	err = sys_mount("none","/root","ramfs",0,"");
	if (err)
	{
		printk(KERN_ERR "lab: Failed to mount ramfs! err=%d\n", err);
		printk(KERN_ERR "lab: RAMFS mount failed, bombing out!");
		while(1);
	};
	err = sys_chdir("/root");
	if (err)
	{
		printk(KERN_ERR "lab: chdir /root failed for some reason. bombing out!");
		while(1);
	};
	
	printk(KERN_INFO "lab: Chrooting into ramfs...\n");
	err = sys_mount(".", "/", NULL, MS_MOVE, NULL);
	if (err)
	{
		printk(KERN_ERR "lab: mount portion failed, bombing out!");
		while(1);
	};
	sys_chroot(".");
	
	printk(KERN_INFO "lab: Creating devices...\n");
	err = sys_mkdir("/dev");
	if (err)
	{
		printk(KERN_ERR "lab: mkdir /dev failed, bombing out!");
		while(1);
	};
	err = sys_mknod("/dev/serial",S_IFCHR|0600,MKDEV(MAJOR,MINOR));
	if (err)
	{
		printk(KERN_ERR "lab: mknod /dev/serial failed, bombing out!");
		while(1);
	};
		
	
	labserfd = -1;
	while(labserfd < 0)
	{
		delay_seconds(10);
		printk(KERN_INFO "lab: Opening /dev/serial...\n");
		labserfd=sys_open("/dev/serial", O_RDWR | O_SYNC,0);
		if (labserfd < 0){
			printk(KERN_INFO "lab: Unable to open /dev/serial!\n");
		};
	};
	
	printk(KERN_INFO "lab: Done! Switching to /dev/serial. FD: %d\n", labserfd);

	setbaud(B115200);

	putstr("lab: On /dev/serial.\r\n");
	putstr("lab: Starting bootldr_main()...\r\n");
	bootldr_main();
	while(1);
	
}

void setbaud(int baud)
{
	struct termios term;
	int err;
	
	// get termios data
	if (err=sys_ioctl(labserfd,0x5401,&term) < 0)
		printk(KERN_INFO "lab: ioctl failed! errno: %d", err);
		
	// set actual baud
	term.c_cflag &= ~CBAUD;
	term.c_cflag |= baud;
	
	// make raw, 8n1
	term.c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|ICRNL|IXON);
	term.c_oflag &= ~OPOST;
	term.c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG|IEXTEN);
	term.c_cflag &= ~(CSIZE|PARENB|CSTOPB);
	term.c_cflag |= CS8;
	
	// save termios data
	if (err=sys_ioctl(labserfd,0x5403,&term) <0)
		printk(KERN_INFO "lab: ioctl failed! errno: %d", err);
	
};
