/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#ifndef __mib_h_OK__
#define __mib_h_OK__

#define ADDRESS_LENGTH    	6
#define OPER_RATE_SIZE		4

typedef UCHAR  MACADDR[ADDRESS_LENGTH];
#if defined (R505) || defined (R505_2958)
typedef struct __HW_CFG {
  UCHAR CR39Values[14];
  UCHAR   Reserved1[14];
  UCHAR BB_CR[14];
  UCHAR   PIDVID[4];
  UCHAR   MacAddress[6];
  UCHAR   RegulatoryDomain;
  UCHAR   Reserved2[14];
  UCHAR CR15Values[14];
  UCHAR   Reserved3[3];
}HW_CFG, *PHW_CFG;
#elif defined(RFMD)
typedef struct __HW_CFG {
	UCHAR	CR20Values[14]; 
	UCHAR 	CR21Values[14]; 
	UCHAR	BB_CR[14]; 
	UCHAR 	PIDVID[4]; 
	UCHAR 	MacAddress[6]; 
	UCHAR 	RegulatoryDomain; 
	UCHAR 	LowPowerValues[14];	
	UCHAR 	NormalPowerVlues[14]; 
	UCHAR 	Reserved1[3];	
}HW_CFG, *PHW_CFG;
#else
typedef struct __HW_CFG{
	UCHAR	MacAddress[6];
	UCHAR	CR31[14];
	UCHAR	CR58[14];
	UCHAR	VIDPID[4];
	UCHAR	RegDomain;
	UCHAR	Reserved[1];
}HW_CFG, *PHW_CFG;
#endif

typedef struct __MAC_WEP_MIB{
  BOOLEAN    PrivacyInvoked;
  UCHAR      WEPDefaultKeyID;
  UCHAR      WEPKeyMappingLength;
  BOOLEAN    ExcludeUnencrypted;
  ULONG      WEPICErrorCount;
  ULONG      WEPExcludedCount;
  UCHAR      WEPDefaultKeyValue[4][13];
  UCHAR      EncryptionLevel;
  UCHAR      Reserved[3];
}MAC_WEP_MIB;

#define PrivacyInvoked_OFFSET		0
#define WEPDefaultKeyID_OFFSET		1
#define ExcludeUnencrypted_OFFSET	3

#define WEP_KEY_ONE_OFFSET			12
#define WEP_KEY_TWO_OFFSET			25
#define WEP_KEY_THREE_OFFSET		38
#define WEP_KEY_FOUR_OFFSET			51

#define EncryptionLevel_OFFSET		64

typedef struct __MAC_ADDRESS_MIB{
  UCHAR      MACAddress[6];
  UCHAR      Res[2];
  MACADDR    GroupAddresses[4];
  UCHAR      GroupAddressesStatus[4];
}MAC_ADDRESS_MIB;

#define MACAddress_OFFSET	0
typedef struct __MAC_MIB{
  ULONG      MaxTransmitMSDULifeTime;
  ULONG      MaxReceivedLifeTime;

  USHORT     FragmentationThreshold;
  USHORT     RtsThreshold;
  USHORT     CwMin;
  USHORT     CwMax;

  UCHAR      ShortRetryLimit;
  UCHAR      LongRetryLimit;
  UCHAR      ScanType;
  UCHAR      ScanChannel;

  USHORT     ProbeDelay;
  USHORT     MinChannelTime;
  USHORT     MaxChannelTime;
  USHORT     Reserved1;

  UCHAR      DesiredSSID[32];
  MACADDR    DesiredBSSID;
  UCHAR      DesiredBSSType;
  UCHAR      Reserved2;
}MAC_MIB;

#define Fragmentation_OFFSET	8
#define RTS_OFFSET				10	

typedef struct __MAC_MGMT_MIB {
  USHORT     BeaconPeriod;
  USHORT     CFPMaxDuration;
  USHORT     MediumOccpancyLimit;
  USHORT     StationID;
  USHORT     ATIMWindow;
  UCHAR      CFPMode;
  BOOLEAN    PrivacyOptionImplemented;
  UCHAR      DTIMPeriod;
  UCHAR      CFPPeriod;
  MACADDR    CurrentBSSID;
  UCHAR      CurrentSSID[32];
  UCHAR      CurrentBSSType;
  UCHAR      Power_Mgmt_Mode;

#if (defined RFMD) || (defined R505) || (defined R505_2958)
  UCHAR      IBSSChange; //1 BYTE
  UCHAR      res;//1 byte
  UCHAR	     MultiDomainCapabilityImplemented;//1 byte
  UCHAR	     MultiDomainCapabilityEnabled;//1byte
  UCHAR      CountryString[3];//3 bytes
  UCHAR      Reserved[3];//1 byte
#else
  UCHAR      Reserved[2];
#endif
}MAC_MGMT_MIB;


#define PowerMgmtMode_OFFSET            53
#define ListenInterval_OFFSET           30
#define AssocID_OFFSET                   6
#define IRoaming_OFFSET			57
#define IBSSChange_OK_OFFSET			54
#define PrivacyOptionImplemented_OFFSET	11
typedef struct __PHY_MIB {
  ULONG      EDThreshold;
  
  USHORT     SlotTime;
  USHORT     SifsTime;
  USHORT     PreambleLength;
  USHORT     PLCPHeaderLength;
  USHORT     MPDUMaxLength;
  USHORT     CCAModeSupported;
  
  UCHAR      OperationRateSet[4];
  UCHAR      ChannelID;
  UCHAR      CurrentCCAMode;
  UCHAR      PHYType;
  UCHAR      CurrentRegDomain;
}PHY_MIB;

typedef struct __LOCAL_MIB {
  USHORT     Reserved0;
  BOOLEAN    BeaconEnable;
  UCHAR      TxAutoRateFallBack;
  UCHAR      Reserved1;
  UCHAR      SSID_Size;
  UCHAR      PromiscuousMode;
  USHORT     Reserved2;
  UCHAR      PreambleType;
  USHORT     Reserved3;
}LOCAL_MIB;

typedef struct __MDOMAIN_MIB {
        UCHAR       TransmitPowerLevel[14];
        UCHAR       ChannelList[14];
}MDOMAIN_MIB;

#define PreambleType_OFFSET			9
#define TxAutoRateFallBack_OFFSET	3
typedef struct __FW_VERSION_MIB {
  	UCHAR       MajorFw;
  	UCHAR       MinorFw;
  	UCHAR       reserved;
  	UCHAR       FwBuild;
}FW_VERSION_MIB;

#define SetMibLocal     0x01
#define SetMibMACAdd    0x02
#define SetMibMAC       0x03
#define SetMibMACMgmt   0x05
#define SetMibMACWEP    0x06
#define SetMibPHY       0x07

#define GetMibLocal     0x01
#define GetMibMACAdd    0x02
#define GetMibMAC       0x03
#define GetMibMACMgmt   0x05
#define GetMibMACWEP    0x06
#define GetMibPHY       0x07
#define GetMibMDOMAIN   0x09

typedef struct __SET_MIB {
        UCHAR       Type;
        UCHAR       Size;
        UCHAR       Index;
        UCHAR       Reserved;
        UCHAR       Data[72];
}SET_MIB, * PSET_MIB;

#endif // __mib_h_OK__
