
#include <linux/config.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <net/protocol.h>
#include <net/ipv6.h>
#include <net/addrconf.h>
#include <net/ip6_route.h>
#include <net/ndisc.h>
#include <net/mipglue.h>

EXPORT_SYMBOL(ipv6_addr_type);
EXPORT_SYMBOL(icmpv6_send);
EXPORT_SYMBOL(icmpv6_statistics);
EXPORT_SYMBOL(icmpv6_err_convert);
EXPORT_SYMBOL(ndisc_mc_map);
EXPORT_SYMBOL(register_inet6addr_notifier);
EXPORT_SYMBOL(unregister_inet6addr_notifier);
EXPORT_SYMBOL(ip6_route_output);
#ifdef CONFIG_NETFILTER
EXPORT_SYMBOL(ip6_route_me_harder);
#endif
EXPORT_SYMBOL(addrconf_lock);
EXPORT_SYMBOL(ipv6_setsockopt);
EXPORT_SYMBOL(ipv6_getsockopt);
EXPORT_SYMBOL(inet6_register_protosw);
EXPORT_SYMBOL(inet6_unregister_protosw);
EXPORT_SYMBOL(inet6_add_protocol);
EXPORT_SYMBOL(inet6_del_protocol);
EXPORT_SYMBOL(ip6_xmit);
EXPORT_SYMBOL(inet6_release);
EXPORT_SYMBOL(inet6_bind);
EXPORT_SYMBOL(inet6_getname);
EXPORT_SYMBOL(inet6_ioctl);
EXPORT_SYMBOL(ipv6_get_saddr);
EXPORT_SYMBOL(ipv6_chk_addr);
EXPORT_SYMBOL(in6_dev_finish_destroy);
EXPORT_SYMBOL(ipv6_skip_exthdr);

#if defined(CONFIG_IPV6_TUNNEL_MODULE) || defined(CONFIG_IPV6_MOBILITY_MODULE)
EXPORT_SYMBOL(ip6_build_xmit);
EXPORT_SYMBOL(rt6_lookup);
EXPORT_SYMBOL(ipv6_ext_hdr);
#endif
#ifdef CONFIG_IPV6_MOBILITY_MODULE
EXPORT_SYMBOL(mipv6_functions);
EXPORT_SYMBOL(mipv6_invalidate_calls);
#if defined(CONFIG_IPV6_MOBILITY_HA_MODULE) || defined(CONFIG_IPV6_MOBILITY_MN_MODULE)
EXPORT_SYMBOL(ip6_route_add);
EXPORT_SYMBOL(ip6_route_del);
EXPORT_SYMBOL(ipv6_get_lladdr);
EXPORT_SYMBOL(ipv6_get_ifaddr);
EXPORT_SYMBOL(nd_tbl);
EXPORT_SYMBOL(ndisc_send_ns);
EXPORT_SYMBOL(ndisc_send_na);
EXPORT_SYMBOL(ndisc_next_option);
EXPORT_SYMBOL(inet6_ifa_finish_destroy);
#endif
#ifdef CONFIG_IPV6_MOBILITY_HA_MODULE
EXPORT_SYMBOL(ipv6_dev_ac_dec);
EXPORT_SYMBOL(ipv6_dev_ac_inc);
EXPORT_SYMBOL(ipv6_dev_mc_dec);
EXPORT_SYMBOL(ipv6_dev_mc_inc);
EXPORT_SYMBOL(ip6_forward);
EXPORT_SYMBOL(ip6_input);
EXPORT_SYMBOL(ipv6_chk_acast_addr);
#endif
#ifdef CONFIG_IPV6_MOBILITY_MN_MODULE
#endif
EXPORT_SYMBOL(addrconf_add_ifaddr);
EXPORT_SYMBOL(addrconf_del_ifaddr);
EXPORT_SYMBOL(addrconf_dad_start);
EXPORT_SYMBOL(ip6_del_rt);
EXPORT_SYMBOL(ip6_routing_table);
EXPORT_SYMBOL(rt6_get_dflt_router);
EXPORT_SYMBOL(rt6_purge_dflt_routers);
EXPORT_SYMBOL(rt6_lock);
EXPORT_SYMBOL(ndisc_send_rs);
EXPORT_SYMBOL(fib6_clean_tree);
EXPORT_SYMBOL(ipv6_del_addr);
EXPORT_SYMBOL(ipv6_generate_eui64);
EXPORT_SYMBOL(ipv6_inherit_eui64);
#endif
