#!/bin/bash
#
# test-gconf.sh
# ====
#
# Tests gconf key shortcut settings.
#
# TODO
# - need to test more keys
# - figure out how to make in non-interactive
#     - cmp screen shots after moving ?


if [ -z $(matchbox -h | grep gconf | grep yes) ]; then
   echo "$0: matchbox appears to lack gconf support. Exiting test."
   exit 2 # 2 indicates mis-setup 
fi
if [ -z $(which gconftool-2|grep "/gconftool-2") ]; then
   echo "$0: 'gconftool-2' missing."
   exit 2
fi
if [ \! -x sendkey ]; then
   echo "$0: 'sendkey' test utility missing, compile it first!"
   exit 2
fi

echo "Initial matchbox settings"
echo "===="
gconftool-2 -R /apps/matchbox
echo 
echo "===="
echo

echo "Now Setting cycle windows key to <alt>n"
gconftool-2 --set /apps/matchbox/global_keybindings/cycle_windows '<alt>n' --type string

echo "Checking it works ( focused window should change ) - hit RETURN"
read
./sendkey +alt n 

echo "Now Setting cycle windows key to <alt>N"
gconftool-2 --set /apps/matchbox/global_keybindings/cycle_windows '<alt>N' --type string

echo "Checking it works ( focused window should change ) - hit RETURN"
read
./sendkey +alt +shift n 

exit 0

