/* 
   This is a very simple example of a hung application handler. 

   Run matchbox like;

   matchbox -ping_handler /path/to/test-hung-ping-handler

   On detection of a hung application, matchbox will run this 
   application passing PID, and WindowID as argv[1], argv[2]

   The idea would be to write a handler that pops up a dialog and 
   questions the user if he wants to kill the application. 

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

int 
main (int argc, char **argv)
{
  pid_t pid;
  if (argc < 3) 
    {
      fprintf(stderr, "Expected %s <PID> <Window XID>\n", argv[0]);
      exit(1);
    }

  printf("%s: started\n", argv[0]);
  printf("%s: Got PID: %s, Window: %s\n",  argv[0], argv[1], argv[2]);
  printf("%s: Sleeping for 10 seconds\n", argv[0]);
  sleep(10);
  pid = atoi(argv[1]);
  printf("%s Now killing -9 %i\n", argv[0], pid);

  if (kill (pid, 9) < 0)
    fprintf(stderr, "%s: kill 9 %i failed.\n", argv[0], pid);

  exit(0);
}
