/*

  Copyright (C) 2000, The MITRE Corporation

  Use of this software is subject to the terms of the GNU General
  Public License version 2.

  Please read the file LICENSE for the exact terms.

*/

/*
 * Test program that allows a user to type messages to a Unix socket
 * and see responses.
 *
 * Author: Kevin H. Grace, kgrace@mitre.org
 *         The MITRE Corporation
 *         202 Burlington Rd
 *         Bedford, MA  01730
 *         
 *
 * $Id: dbUnix.C,v 1.1.1.1 2003/10/24 10:34:57 br1 Exp $
 *  
 */

#include <UtUnixSocket.h>

int main(int argc, char* argv[]) {
  if((argc != 2) && (argc != 3)) {
    cerr << "Usage: dbUnix <server path> [client]" << endl;
  }
  
  String serverPath = String(argv[1]);
  UnixAddr serverAddr(serverPath);
  bool isClient = (argc == 3);
  
  String listen = (isClient ? argv[2] : serverPath);

  UnixSocket sock(listen);
  
  // Find the max number of file descriptors for this process
  int fdlimit = sock.Fd() + 1;

  while(1) {
    fd_set fds;
    FD_ZERO(&fds);
    if(isClient) FD_SET(0,&fds);
    FD_SET(sock.Fd(),&fds);
    fd_set xfds = fds;
    int n;
    if((n=select(fdlimit, &fds, 0, &xfds, 0)) == -1) {
      cerr << "Call to select() failed! - " << strerror(errno) << endl;
      return 1;
    }
    
    if(n > 0) {
      if(FD_ISSET(sock.Fd(),&fds)) {
	// Handle receive
	UnixDatagram dg = sock.Recv();
	cerr << "From:  " << String(dg.GetAddr()) << " '" << dg.GetData() << "'\n";
	if(!isClient) {
	  String s = listen + " heard '" + dg.GetData() + "'";
	  UnixDatagram reply(s, dg.GetAddr());
	  sock.Send(reply);
	}
      }
      if(isClient && FD_ISSET(0,&fds)) {
	String s;
	s.Getline(cin);
	cerr << "Sending: '" << s << "'" << endl;
	UnixDatagram dg(s, serverAddr);
	sock.Send(dg);
      }
      if(FD_ISSET(sock.Fd(),&xfds)) {
	cerr << "Exceptional condition occurred! \n";
      }
    }
  }
  return(0);
}

