/****************************************************************************
 * A server socket receiving anything returning /var/run/mobilemesh/dotter.dot
 * calls script mm_getdot which has to copy 
 * /var/run/mobilemesh/topology-20471.dot to dotter.dot
 * 4G Systeme GmbH, Ronald Bock 13.12.2003 
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include <wait.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <linux/unistd.h>

#define false 0
#define true  1


typedef struct {       	int i_listensocket;
			int i_clientsocket;
			struct sockaddr_in lsock;
			struct sockaddr_in csock;
			socklen_t i_accepted;
			char *data_in;
			char *data_out;
}  TSOCK;

TSOCK tsocket;


int socket_create();
int socket_listen( char *hostip ,long  port );
int socket_accept(); 
int socket_send( char *data, int len, unsigned int flag);
int socket_receive( char *data, int len); 
int socket_close();
int socket_unlink();

/*
void
sig_chld(int signo)
{
	pid_t	pid;
	int	stat;

	pid = wait(&stat);
	// printf("child %d terminated\n", pid);
	return;
}
*/

void
sig_chld(int signo)
{
	pid_t	pid;
	int		stat;

	while ( (pid = waitpid(-1, &stat, WNOHANG)) > 0)
		// printf("child %d terminated\n", pid);
	return;
}

char *huhu="HTTP/1.1 200 OK\nContent-Type: text/html\n\n<html><head><title>Hallo</title></head><body><h1>Huhu!!!</h1></body></html>\n\n";


int
socket_create() {
		// create socket
		tsocket.i_listensocket = socket( AF_INET, SOCK_STREAM, 0 );
		if ( tsocket.i_listensocket < 0 )  {
			perror( "Error Create Socket");
			return false;
		}
		return true;
}


int 
socket_listen( char *hostip , long port ) {
		int i_result;
		tsocket.lsock.sin_port = htons(port);
		// Listen to all addresses or
		 if( *hostip == '\0' )
			tsocket.lsock.sin_addr.s_addr = 0;
		 else
		 	tsocket.lsock.sin_addr.s_addr = inet_addr( hostip ) ;

			
		if( bind( tsocket.i_listensocket, (struct sockaddr *) &tsocket.lsock, sizeof(tsocket.lsock)) < 0 ) {
		        perror( "Error Binding Socket");
			return false;
		}
		

		i_result = listen( tsocket.i_listensocket, 20 );	 	
		if ( i_result < 0 ){ 
			perror( "Error to claim Listen Mode");
			return false;
		}
		return true;
}


int 
socket_accept() {
		tsocket.i_accepted = sizeof(tsocket.csock);
		tsocket.i_clientsocket = accept( tsocket.i_listensocket, (struct sockaddr *) &tsocket.csock, &tsocket.i_accepted); 
		if(tsocket.i_clientsocket < 0 ) { 
			perror( "Error during Accept");
			return false;

		}
		return true;

}

int 
socket_send(char *data, int len, unsigned int flag) {
	int i_result;
	tsocket.data_out = data;
	i_result = send(tsocket.i_clientsocket, tsocket.data_out, len , flag );
	if ( i_result < 0 ){ 
			perror( "Error Send Data");
			return false;
		}

	return true;

}

int 
socket_receive( char *data, int len) {
	int i_result;
	tsocket.data_in = data;
	i_result = recv(tsocket.i_clientsocket, tsocket.data_in, len , MSG_DONTWAIT );
	if ( i_result == -1  ) return false;
	return true;

}

int
socket_close() {
	int i_result;
	i_result = close(tsocket.i_clientsocket);
	if ( i_result < 0 ){ 
			perror( "Error to close");
			return false;
		}

	return true;

}


int
socket_unlink() { 
	int i_result;
	i_result = close(tsocket.i_listensocket);
	if ( i_result < 0 ){ 
			perror( "Error to unlink socket");
			return false;
		}

	return true;

}

int 
main ()  {
	double i;
	int result;
	int wlan_socket, ether_socket;
	char buffer[500];
	char keybuffer[4096];
	char certbuffer[4096];
	char tempkeyname[256];
	char cmdbuffer[256];
	int keyfile;
	int keylen;

	pid_t kind;
	
	// printf("Create Socket -> ");
	result = socket_create();
	if( result == true ) 
		;
	//	printf("Socket erstellt\n");
	else
	 	{ perror("Fehler beim Socket erstellen TOT\n");
		  exit(1); }
		
	// printf("Initialize Listen Socket\n");
	result = socket_listen("", 20473L);
	if( result == true ) 
		;
	//	printf("Socket is listening\n");
	else
	 	{ perror("Can not get port restart please\n");
		  exit(1); }

	signal(SIGCHLD, sig_chld);

		
	// printf("Waiting for incomming connections (accept) \n");
/* Beginn der Sprungschleife */
hunde_marke:
	result = socket_accept();
	kind = fork();
	if( kind != 0 )
		{  if( kind < 0)
			{
			  perror("Error to fork child\n");
			  exit(1);
			}
		   else {
		   		result = socket_close();
			/*	if( result == true ) printf("Daemon hat socket geschlossen\n");
				else printf("Daemon konnte socket nicht schliessen\n"); */
				goto hunde_marke;
		   }
		 }
		
/* Ende des wartenden Daemons */		

/* Bin im Kind   */	
	socket_unlink();

	if( result == true )
		;
		// printf("Connection bound to clientsocket\n");
	else
	 	{ perror("Socket was not accpted by child\n");
		  exit(1); }
	
	memset(certbuffer, '\0', sizeof(certbuffer));
	i=0;
	while(1) { // avoid goto
	result = socket_receive( certbuffer, sizeof(certbuffer) );
	
	if ( result == 1 ) { 
		memset(tempkeyname, '\0', sizeof(tempkeyname));
		memset(cmdbuffer, '\0', sizeof(cmdbuffer));
		
		sprintf(tempkeyname, "/var/run/mobilemesh/dottXXXXXX");
		keyfile = mkstemp(tempkeyname);
		// printf("file %s %d\n", tempkeyname, keyfile);
		/* on error exit silently */
		if(keyfile < 0) break;
		write( keyfile, certbuffer, strlen(certbuffer));
		close (keyfile);
		/* prepare call verification */
		sprintf(cmdbuffer, "mm_getdot %s\n", tempkeyname);	
		/* call verification process */
		result = system(cmdbuffer);
		if(result == 0) { 
		/*	Tempfile now filled with encrypted transkey */
			memset(certbuffer, '\0', sizeof(certbuffer));
			keyfile = open ( tempkeyname, O_RDONLY);
fastfix:
			result = read( keyfile, certbuffer, sizeof(certbuffer));
			if( result > 0 ) {
				socket_send( certbuffer, result , 0); 
			}
			if( result == sizeof(certbuffer)) goto fastfix;
			close(keyfile);
			unlink(tempkeyname);

			}		
		break;
	} // end if
	} // end while
        socket_close();
	exit(0);

}



	
