/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef __Control_H__
#define __Control_H__

#include NXAGENT_NX_INCLUDE

#define MAX_CONNECTIONS 256

extern unsigned long nxagentStartTime;

extern Bool nxagentStrictControl;

extern unsigned int nxagentSyncCounter;
extern unsigned int nxagentSyncModulo;

extern long nxagentKarmaQueue[MAX_CONNECTIONS];

extern long nxagentStopKarmaSz;
extern long nxagentStopImgSz;

extern Bool          nxagentUsesFocusKarma;
extern Bool          nxagentFocusKarmaOnStart;
extern Bool          nxagentFocusKarma;
extern unsigned long nxagentFocusKarmaTimeOut;

extern long nxagentStopKarmaSleep;
extern long nxagentStopKarmaSzDefault;
extern long nxagentStopKarmaSzCheck;

extern int nxagentClientPrivateIndex;

/*
 * Show an alert in the case a persistent
 * cache was not loaded by NX proxy at
 * startup.
 */

extern const char *nxagentNoCacheDialogText;
extern int         nxagentNoCacheDialogEnable;
extern int         nxagentNoCacheDialogTimeout;

extern void nxagentSetNoCacheDialogTimeout(int linkType);

extern void nxagentShowNoCacheDialog();

/*
 * Proxy sends a ClientMessage event to agent in case
 * it is not able to send more data on the proxy link.
 * Agent should stop accepting data from its clients
 * until the condition is ceased.
 */

extern Bool nxagentCongestion;

/*
 * Proxy informs agent when it is going through a reset.
 * This is intended to help agent to detect any X error
 * arising due to incomplete or completely lost requests.
 */

extern Bool nxagentReset;


typedef struct{
#ifdef NXAGENT_RECONNECT
  Bool is_ignored;
#endif
  pointer GetIFReply;
} nxagentPrivClient;

#define nxagentClientPriv(pClient) \
  ((nxagentPrivClient*)((pClient)->devPrivates[nxagentClientPrivateIndex].ptr))

#define nxagentWriteReplyToClient(pClient, size, pReply) { \
   if ((pClient)->swapped) \
      (*ReplySwapVector[X_GetInputFocus]) \
           (pClient, (int)(size), pReply); \
      else (void) WriteToClient(pClient, (int)(size), (char *)(pReply)); }

/*
 * Update the proxy congestion flag by
 * checking if any congestion event is
 * become available.
 */

void nxagentCheckCongestion();

/*
 * Wakeup the sleeping clients.
 */

void nxagentWakeupByReconnect();
void nxagentWakeupByDecongestion();

/*
 * Set karma threshold according to
 * congestion state.
 */

void nxagentAdjustKarma();

/*
 * Suspend client or the entire agent.
 */

void nxagentCheckKarma(ClientPtr client, unsigned long now);

Bool nxSleepByBigReq(ClientPtr client);
Bool nxEndBigReq(ClientPtr client);
Bool nxCommitBigRequest(unsigned char request, unsigned int position);
Bool nxWakeByBigRequest(ClientPtr client);

Bool nxSleepByGetIFocus(ClientPtr client, unsigned int mode, pointer rep);
Bool nxWakeByGetIFocus(ClientPtr client);
int  nxProcGetInputFocus(ClientPtr client);

Bool nxSleepByKarma(ClientPtr client);
Bool nxWakeByKarma(ClientPtr client);
Bool nxWakeByError(ClientPtr client);

/*
 * Used in PutImages bigger than MAX_REQUEST_SIZE(GCOps.c:Pixmap.c).
 */

#ifndef NXAGENT_MAX_REQUEST_EFF_SIZE
# define NXAGENT_MAX_REQUEST_EFF_SIZE \
    ( (MAX_REQUEST_SIZE << 2) - sizeof(xPutImageReq) )
#else
# error  NXAGENT_MAX_REQUEST_EFF_SIZE already defined !!
#endif

#ifndef MIN
# define MIN(A,B) \
    ( (A) < (B) ? (A) : (B) )
#endif

#endif /* __Control_H__ */
