/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "X.h"
#include "Xproto.h"
#include "screenint.h"
#include "input.h"
#include "misc.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "servermd.h"
#include "mi.h"
#include "fontstruct.h"

#include "Agent.h"

#include "Display.h"
#include "Screen.h"
#include "Pointer.h"
#include "Keyboard.h"
#include "Handlers.h"
#include "Init.h"
#include "Args.h"
#include "Control.h"
#include "Options.h"
#include "Drawable.h"
#include "GC.h"
#include "Font.h"

#ifdef NXAGENT_INIT_DEBUG

#include <sys/types.h>
#include <unistd.h>

static void nxagentPrintSymbols(void);

#endif

/*
 * ProcVector array defined in tables.c.
 */

#define NXAGENT_VERSION  "1.3.2"

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG

extern int (* ProcVector[256])(
#if NeedNestedPrototypes
        ClientPtr /* client */
#endif
);

#ifdef NXAGENT_BAKSTR
int nxagentBackingStore;
int nxagentSaveUnder;
#endif

#ifdef NXAGENT_ERRORH
#include "Error.h"
#endif

Bool nxagentDoFullGeneration = True;

/*
 * Note about nxagentDoFullGeneration variable. It is defined
 * above and declared in Init.h. It's True at startup and
 * set to the value of nxagentFullGeneration at the end of
 * InitInput.
 *
 * It is checked in nxagentOpenDisplay, nxagentCloseDisplay,
 * nxagentOpenScreen. nxagentOpenDisplay and nxagentCloseDisplay
 * return immediately if it is False. nxagentOpenScreen creates
 * Xlib windows only if True.
 *
 * main
 *   InitOutput
 *      nxagentOpenDisplay (if nxagentDoFullGeneration)
 *         nxagentCloseDisplay (if (nxagentDoFullGeneration && nxagentDisplay))
 *            nxagentFree*
 *      nxagentListRemoteFonts
 *      AddScreen
 *         nxagentOpenScreen
 *   InitInput
 */

void InitOutput(screenInfo, argc, argv)
     ScreenInfo *screenInfo;
     int argc;
     char *argv[];
{
  int i;
  char *nxAuth;

#ifdef __sun
  char * envBuffer;
#endif

# ifdef NXAGENT_RECONNECT
  extern RESTYPE RT_NX_PIXMAP;
  extern int nxagentDestroyNewPixmapResourceType(pointer, XID);
  extern RESTYPE RT_NX_FONT;
  extern int nxagentDestroyNewFontResourceType(pointer, XID);
# endif
  
#if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)

extern int nxagentClientPrivateIndex;

#endif

#ifdef NXAGENT_INIT_DEBUG

  /*
   * Print NXAGENT_* defined symbols.
   */

  nxagentPrintSymbols();

#endif

  if ((nxAuth = getenv("NX_XAUTHORITY")))
  {
    #ifdef __sun

    envBuffer = malloc(15 + strlen(nxAuth));

    sprintf(envBuffer, "XAUTHORITY=%s", nxAuth);

    if (putenv(envBuffer) < 0)

    #else

    if (setenv("XAUTHORITY", nxAuth, True) < 0)

    #endif

    {
      fprintf(stderr, "Couldn't set XAUTHORITY environment variable [%s]\n", nxAuth);
    }
  }

  nxagentOpenDisplay(argc, argv);

  #ifdef DEBUG

  if (nxagentOption(Rootless) == True)
  {
    fprintf(stderr, "InitOutput: WARNING! Setting synchronized mode to true.\n");

    XSynchronize(nxagentDisplay, True);
  }

  #endif

#ifdef NXAGENT_BAKSTR
  nxagentBackingStore = XDoesBackingStore(DefaultScreenOfDisplay(nxagentDisplay));
  nxagentSaveUnder = XDoesSaveUnders(DefaultScreenOfDisplay(nxagentDisplay));
# ifdef NXAGENT_BAKSTR_DEBUG
  fprintf(stderr, "Remote display backingstore: %d\n", nxagentBackingStore);
  fprintf(stderr, "Remote display saveunder: %d\n", nxagentSaveUnder);
# endif /* NXAGENT_BAKSTR_DEBUG */
#endif

  /*
   * Initialize the basic screen info.
   */

  nxagentSetScreenInfo(screenInfo);

  /*
   * Initialize pixmap formats for this screen
   * matching the pixmap formats made available
   * by the remote X server.
   */

  nxagentSetPixmapFormats(screenInfo);

  /*
   * Get our own privates' index.
   */

  nxagentWindowPrivateIndex = AllocateWindowPrivateIndex();
  nxagentGCPrivateIndex = AllocateGCPrivateIndex();
  nxagentFontPrivateIndex = AllocateFontPrivateIndex();
# ifdef NXAGENT_RECONNECT
  RT_NX_FONT = CreateNewResourceType(nxagentDestroyNewFontResourceType); 
# endif
#if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)
  nxagentClientPrivateIndex = AllocateClientPrivateIndex();
#endif
  nxagentPixmapPrivateIndex = AllocatePixmapPrivateIndex();
# ifdef NXAGENT_RECONNECT
  RT_NX_PIXMAP = CreateNewResourceType(nxagentDestroyNewPixmapResourceType); 
# endif

#ifdef NXAGENT_MVFB
 {
   extern int mfbGCPrivateIndex;
   mfbGCPrivateIndex = AllocateGCPrivateIndex();
 }
#endif

#ifdef NXAGENT_FONTMATCH
/* retrieve remote font list */
/* nxagentListRemoteFonts("*",32767); */

#endif /* NXAGENT_FONTMATCH */

  if (!nxagentNumScreens) nxagentNumScreens = 1;

  for (i = 0; i < nxagentNumScreens; i++)
    AddScreen(nxagentOpenScreen, argc, argv);

#ifdef NXAGENT_HSCREEN
  nxagentNumScreens = screenInfo->numScreens - 1;
/*   nxagentNumScreens = screenInfo->numScreens; */
#else
  nxagentNumScreens = screenInfo->numScreens;
#endif

  nxagentDoFullGeneration = nxagentFullGeneration;
}

void InitInput(argc, argv)
     int argc;
     char *argv[];
{
  pointer ptr, kbd;

  ptr = AddInputDevice(nxagentPointerProc, TRUE);
  kbd = AddInputDevice(nxagentKeyboardProc, TRUE);

  RegisterPointerDevice(ptr);
  RegisterKeyboardDevice(kbd);

  mieqInit(kbd, ptr);

  AddEnabledDevice(XConnectionNumber(nxagentDisplay));

  RegisterBlockAndWakeupHandlers(nxagentBlockHandler, nxagentWakeupHandler, NULL);

  /* set the GetInputFocus handler */
#ifdef NXAGENT_GETIFOCUS
  ProcVector[43] = nxProcGetInputFocus;
#endif
}

/*
 * DDX - specific abort routine.  Called by AbortServer().
 */
void AbortDDX()
{
  nxagentDoFullGeneration = True;
  nxagentCloseDisplay();
}

/* Called by GiveUp(). */
void ddxGiveUp()
{
  AbortDDX();
}

#ifdef __DARWIN__
void
DarwinHandleGUI(int argc, char *argv[])
{
}
void GlxExtensionInit();
void GlxWrapInitVisuals(void *procPtr);

void
DarwinGlxExtensionInit()
{
    GlxExtensionInit();
}

void
DarwinGlxWrapInitVisuals(
    void *procPtr)
{
    GlxWrapInitVisuals(procPtr);
}
#endif

void OsVendorInit()
{
    return;
}

void OsVendorFatalError()
{
    return;
}

/* this is just to get the server to link on AIX */
#ifdef AIXV3
int SelectWaitTime = 10000; /* usec */
#endif

#ifdef DPMSExtension
/**************************************************************
 * DPMSSet(), DPMSGet(), DPMSSupported()
 *
 * stubs
 *
 ***************************************************************/

void DPMSSet (level)
    int level;
{
}

int DPMSGet (level)
    int* level;
{
    return -1;
}

Bool DPMSSupported ()
{
    return FALSE;
}
#endif

#ifdef NXAGENT_INIT_DEBUG

static void nxagentPrintSymbols(void)
{
  if (nxagentDoFullGeneration) {

    fprintf(stderr, "\nNXAGENT - Version " NXAGENT_VERSION "\n\n");
    fprintf(stderr, "Copyright (C) 2001, 2004 NoMachine.\n");
    fprintf(stderr, "See http://www.nomachine.com/ for more information.\n\n");

    fprintf(stderr, "Info: Agent running with pid '%d'.\n", getpid());

#ifdef NXAGENT_PRINT_SYMBOLS

    fprintf(stderr, "NXAGENT: Compiled with the following symbols:\n\n");

#ifdef NXAGENT_INIT_DEBUG
    fprintf(stderr, "NXAGENT_INIT_DEBUG\n");
#endif

#ifdef NXAGENT_QUERYBSIZE
    fprintf(stderr, "NXAGENT_QUERYBSIZE\n");
#endif

#ifdef NXAGENT_QUERYBSIZE_DEBUG
    fprintf(stderr, "NXAGENT_QUERYBSIZE_DEBUG\n");
#endif

#ifdef  NXAGENT_CONSTRAINCURSOR
    fprintf(stderr, "NXAGENT_CONSTRAINCURSOR\n");
#endif

#ifdef  NXAGENT_CONSTRAINCURSOR_DEBUG
    fprintf(stderr, "NXAGENT_CONSTRAINCURSOR_DEBUG\n");
#endif

#ifdef  NXAGENT_FONTCACHE
    fprintf(stderr, "NXAGENT_FONTCACHE\n");
#endif

#ifdef  NXAGENT_FONTCACHE_DEBUG
    fprintf(stderr, "NXAGENT_FONTCACHE_DEBUG\n");
#endif

#ifdef NXAGENT_PIXMAPCACHE
    fprintf(stderr, "NXAGENT_PIXMAPCACHE\n");
#endif

#ifdef NXAGENT_PIXMAPCACHE_DEBUG
    fprintf(stderr, "NXAGENT_PIXMAPCACHE_DEBUG\n");
#endif

#ifdef NXAGENT_EXPOSURES
    fprintf(stderr, "NXAGENT_EXPOSURES\n");
#endif

#ifdef NXAGENT_EXPOSURES_DEBUG
    fprintf(stderr, "NXAGENT_EXPOSURES_DEBUG\n");
#endif

#ifdef NXAGENT_BAKSTR
    fprintf(stderr, "NXAGENT_BAKSTR\n");
#endif

#ifdef NXAGENT_BAKSTR_DEBUG
    fprintf(stderr, "NXAGENT_BAKSTR_DEBUG\n");
#endif

#ifdef NXAGENT_SHAPE
    fprintf(stderr, "NXAGENT_SHAPE\n");
#endif

#ifdef NXAGENT_SHAPE_DEBUG
    fprintf(stderr, "NXAGENT_SHAPE_DEBUG\n");
#endif

#ifdef NXAGENT_GLYPHCACHE
    fprintf(stderr, "NXAGENT_GLYPHCACHE\n");
#endif

#ifdef NXAGENT_GLYPHCACHE_DEBUG
    fprintf(stderr, "NXAGENT_GLYPHCACHE_DEBUG\n");
#endif

#ifdef NXAGENT_SHAPE2
    fprintf(stderr, "NXAGENT_SHAPE2\n");
#endif

#ifdef NXAGENT_SHAPE2_DEBUG
    fprintf(stderr, "NXAGENT_SHAPE2_DEBUG\n");
#endif

#ifdef NXAGENT_STOPBIGREQ
    fprintf(stderr, "NXAGENT_STOPBIGREQ\n");
#endif

#ifdef NXAGENT_STOPBIGREQ_DEBUG
    fprintf(stderr, "NXAGENT_STOPBIGREQ_DEBUG\n");
#endif

#ifdef NXAGENT_GETIFOCUS
    fprintf(stderr, "NXAGENT_GETIFOCUS\n");
#endif

#ifdef NXAGENT_GETIFOCUS_DEBUG
    fprintf(stderr, "NXAGENT_GETIFOCUS_DEBUG\n");
#endif

#ifdef NXAGENT_XLIBPARAMS
    fprintf(stderr, "NXAGENT_XLIBPARAMS\n");
#endif

#ifdef NXAGENT_XLIBPARAMS_DEBUG
    fprintf(stderr, "NXAGENT_XLIBPARAMS_DEBUG\n");
#endif

#ifdef NXAGENT_FONTMATCH
    fprintf(stderr, "NXAGENT_FONTMATCH\n");
#endif

#ifdef NXAGENT_FONTMATCH_DEBUG
    fprintf(stderr, "NXAGENT_FONTMATCH_DEBUG\n");
#endif

#ifdef NXAGENT_FIXKEYS
    fprintf(stderr, "NXAGENT_FIXKEYS\n");
#endif

#ifdef NXAGENT_FIXKEYS_DEBUG
    fprintf(stderr, "NXAGENT_FIXKEYS_DEBUG\n");
#endif

#ifdef NXAGENT_ERRORH
    fprintf(stderr, "NXAGENT_ERRORH\n");
#endif

#ifdef NXAGENT_ERRORH_DEBUG
    fprintf(stderr, "NXAGENT_ERRORH_DEBUG\n");
#endif

#ifdef NXAGENT_NOEXPOSEOPTIMIZE
    fprintf(stderr, "NXAGENT_NOEXPOSEOPTIMIZE\n");
#endif

#ifdef NXAGENT_NOEXPOSEOPTIMIZE_DEBUG
    fprintf(stderr, "NXAGENT_NOEXPOSEOPTIMIZE_DEBUG\n");
#endif

#ifdef NXAGENT_CLIPBOARD
    fprintf(stderr, "NXAGENT_CLIPBOARD\n");
#endif

#ifdef NXAGENT_MOTION
    fprintf(stderr, "NXAGENT_MOTION\n");
#endif

#ifdef NXAGENT_MOTION_DEBUG
    fprintf(stderr, "NXAGENT_MOTION_DEBUG\n");
#endif

#ifdef NXAGENT_GCOPTIMIZE
    fprintf(stderr, "NXAGENT_GCOPTIMIZE\n");
#endif

#ifdef NXAGENT_GCOPTIMIZE_DEBUG
    fprintf(stderr, "NXAGENT_GCOPTIMIZE_DEBUG\n");
#endif

#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
    fprintf(stderr, "NXAGENT_CONFWINOPTIMIZE\n");
#endif

#ifdef NXAGENT_CONFWINOPTIMIZE_DEBUG
    fprintf(stderr, "NXAGENT_CONFWINOPTIMIZE_DEBUG\n");
#endif

#ifdef NXAGENT_ONEXIT
    fprintf(stderr, "NXAGENT_ONEXIT\n");
#endif

#ifdef NXAGENT_ONEXIT_DEBUG
    fprintf(stderr, "NXAGENT_ONEXIT_DEBUG\n");
#endif

    fprintf(stderr, "\n\n");
#endif /* NXAGENT_PRINT_SYMBOLS */
  }

  return;
}

#endif /* NXAGENT_INIT_DEBUG */
