/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef ReadBuffer_H
#define ReadBuffer_H

#include "Misc.h"
#include "Timestamp.h"

class Transport;

#define WARNING

class ReadBuffer
{
  public:

  ReadBuffer(Transport *transport, unsigned int initialReadSize,
                 unsigned int maximumReadSize);

  virtual ~ReadBuffer();

  int setSize(int initialReadSize, int maximumReadSize)
  {
    initialReadSize_  = initialReadSize;
    maximumReadSize_  = maximumReadSize;

    #if defined(INFO) || defined(TEST)
    *logofs << "ReadBuffer: WARNING! Set buffer parameters to "
            << initialReadSize_ << "/" << maximumReadSize_
            << " for object at "<< this << ".\n"
            << logofs_flush;
    #endif

    return 1;
  }

  int readMessage();

  const unsigned char *getMessage(unsigned int &dataLength)
  {
    unsigned int controlLength;

    return getMessage(controlLength, dataLength);
  }

  const unsigned char *getMessage(unsigned int &controlLength,
                                      unsigned int &dataLength);

  unsigned int getLength() const
  {
    return length_;
  }

  void partialReset();

  void fullReset();

  //
  // Check if there is any data
  // left in the buffer.
  //

  virtual int checkMessage() = 0;

  protected:

  virtual int locateMessage(const unsigned char *start,
                                const unsigned char *end,
                                    unsigned int &controlLength,
                                        unsigned int &dataLength,
                                            unsigned int &trailerLength) = 0;

  Transport *transport_;

  unsigned char *buffer_;

  unsigned int length_;
  unsigned int size_;
  unsigned int start_;

  unsigned int initialReadSize_;
  unsigned int maximumReadSize_;
};

#endif /* ReadBuffer_H */
