/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2006 NoMachine, http://www.nomachine.com/.         */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef NXalert_H
#define NXalert_H

#define ALERT_CAPTION_PREFIX                                 "NX - "

#define INTERNAL_ERROR_ALERT                                 1
#define INTERNAL_ERROR_ALERT_TYPE                            "error"
#define INTERNAL_ERROR_ALERT_STRING                          \
"\
An unrecoverable internal error was detected.\n\
Press OK to terminate the current session.\n\
"

#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT                 2
#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT_TYPE            "yesno"
#define CLOSE_DEAD_X_CONNECTION_CLIENT_ALERT_STRING          \
"\
One of the applications currently in use is not responding.\n\
Do you want to terminate the current session?\n\
"

#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT                 3
#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT_TYPE            "yesno"
#define CLOSE_DEAD_X_CONNECTION_SERVER_ALERT_STRING          \
"\
One of the applications did not behave correctly and caused\n\
the X server to stop responding in a timely fashion. Do you\n\
want to terminate the current session?\n\
"

#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT             4
#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT_TYPE        NULL
#define CLOSE_DEAD_PROXY_CONNECTION_CLIENT_ALERT_STRING      NULL

#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT             5
#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT_TYPE        "yesno"
#define CLOSE_DEAD_PROXY_CONNECTION_SERVER_ALERT_STRING      \
"\
No response received from the remote server.\n\
Do you want to terminate the current session?\n\
"

#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT           6
#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT_TYPE      NULL
#define RESTART_DEAD_PROXY_CONNECTION_CLIENT_ALERT_STRING    NULL

#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT           7
#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT_TYPE      "yesno"
#define RESTART_DEAD_PROXY_CONNECTION_SERVER_ALERT_STRING    \
"\
Connection with remote server was shut down. NX will try\n\
to establish a new server connection. Session could have\n\
been left in a unusable state. Do you want to terminate\n\
the session?\n\
"

#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT                    8
#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT_TYPE               "panic"
#define CLOSE_UNRESPONSIVE_X_SERVER_ALERT_STRING             \
"\
You pressed the key sequence CTRL+ALT+SHIFT+ESC.\n\
This is probably because your X server has become\n\
unresponsive. Session will be terminated in 30\n\
seconds unless you abort the procedure by pressing\n\
the Cancel button.\n\
"

#define WRONG_PROXY_VERSION_ALERT                            9
#define WRONG_PROXY_VERSION_ALERT_TYPE                       "ok"
#define WRONG_PROXY_VERSION_ALERT_STRING                     \
"\
Local NX libraries version " VERSION " do not match the NX\n\
version of the remote server. Please check the error\n\
log on the server to find out which client version you\n\
need to install to be able to access this server.\n\
"

#define FAILED_PROXY_CONNECTION_CLIENT_ALERT                 10
#define FAILED_PROXY_CONNECTION_CLIENT_ALERT_TYPE            NULL
#define FAILED_PROXY_CONNECTION_CLIENT_ALERT_STRING          NULL

#define FAILED_PROXY_CONNECTION_SERVER_ALERT                 11
#define FAILED_PROXY_CONNECTION_SERVER_ALERT_TYPE            "yesno"
#define FAILED_PROXY_CONNECTION_SERVER_ALERT_STRING          \
"\
Could not yet establish the connection to the remote\n\
proxy. Do you want to terminate the current session?\n\
"

#define MISSING_PROXY_CACHE_ALERT                            12
#define MISSING_PROXY_CACHE_ALERT_TYPE                       "ok"
#define MISSING_PROXY_CACHE_ALERT_STRING                     \
"\
NX was unable to negotiate a cache for this session.\n\
This may happen if this is the first time you run a\n\
session on this server or if cache was corrupted or\n\
produced by an incompatible NX version.\n\
"

#define ABORT_PROXY_CONNECTION_ALERT                         13
#define ABORT_PROXY_CONNECTION_ALERT_TYPE                    "ok"
#define ABORT_PROXY_CONNECTION_ALERT_STRING                  \
"\
The connection with the remote server was shut down.\n\
Please check the state of your network connection.\n\
"

/*
 * The one below is a special alert, used to close
 * a previous alert that is running on the given
 * side. This can be used to get rid of a message
 * that has ceased to hold true.
 */

#define DISPLACE_MESSAGE_ALERT                               14
#define DISPLACE_MESSAGE_ALERT_TYPE                          NULL
#define DISPLACE_MESSAGE_ALERT_STRING                        NULL

/*
 * These are the other alert messages that were
 * added in the 1.5.0 release. The first is never
 * shown and is intended just for testing.
 */

#define GREETING_MESSAGE_ALERT                               15
#define GREETING_MESSAGE_ALERT_TYPE                          "ok"
#define GREETING_MESSAGE_ALERT_STRING                        \
"\
Welcome to NX from the NoMachine team. We really\n\
hope you will enjoy this wonderful software as much\n\
as we had fun making it ;-).\n\
"

/*
 * These alerts are intended to notify the user
 * of the reason why the agent failed to resume
 * the session.
 */

#define START_RESUME_SESSION_ALERT                           16
#define START_RESUME_SESSION_ALERT_TYPE                      "ok"
#define START_RESUME_SESSION_ALERT_STRING                    \
"\
You appear to run your NX session across a slow network\n\
connection. Resuming the session may require some time.\n\
Please wait.\
"

#define FAILED_RESUME_DISPLAY_ALERT                          17
#define FAILED_RESUME_DISPLAY_ALERT_TYPE                     "error"
#define FAILED_RESUME_DISPLAY_ALERT_STRING                   \
"\
Failed to open the display. Can't resume the NX\n\
session on this display.\n\
"

#define FAILED_RESUME_DISPLAY_BROKEN_ALERT                   18
#define FAILED_RESUME_DISPLAY_BROKEN_TYPE                    "error"
#define FAILED_RESUME_DISPLAY_BROKEN_STRING                  \
"\
The display connection was broken while trying to\n\
resume the session. Please, check your network\n\
connection and try again.\n\
"

#define FAILED_RESUME_VISUALS_ALERT                          19
#define FAILED_RESUME_VISUALS_ALERT_TYPE                     "error"
#define FAILED_RESUME_VISUALS_ALERT_STRING                   \
"\
Failed to restore all the required visuals.\n\
Can't resume the NX session on this display.\n\
"

#define FAILED_RESUME_COLORMAPS_ALERT                        20
#define FAILED_RESUME_COLORMAPS_ALERT_TYPE                   "error"
#define FAILED_RESUME_COLORMAPS_ALERT_STRING                 \
"\
The number of available colormaps is different\n\
on the new display. Can't resume the NX session\n\
on this display.\n\
"

#define FAILED_RESUME_PIXMAPS_ALERT                          21
#define FAILED_RESUME_PIXMAPS_ALERT_TYPE                     "error"
#define FAILED_RESUME_PIXMAPS_ALERT_STRING                   \
"\
Failed to restore all the required pixmap formats.\n\
Can't resume the NX session on this display.\n\
"

#define FAILED_RESUME_DEPTHS_ALERT                           22
#define FAILED_RESUME_DEPTHS_ALERT_TYPE                      "error"
#define FAILED_RESUME_DEPTHS_ALERT_STRING                    \
"\
Failed to restore all the required screen depths.\n\
Can't resume the NX session on this display.\n\
"

#define FAILED_RESUME_RENDER_ALERT                           23
#define FAILED_RESUME_RENDER_ALERT_TYPE                      "error"
#define FAILED_RESUME_RENDER_ALERT_STRING                    \
"\
The render extension is missing or an incompatible\n\
version was detected on your X server. Can't resume\n\
the NX session on this display.\n\
"

#define FAILED_RESUME_FONTS_ALERT                            24
#define FAILED_RESUME_FONTS_ALERT_TYPE                       "error"
#define FAILED_RESUME_FONTS_ALERT_STRING                     \
"\
One or more of the fonts that are in use by the\n\
session are missing. Can't resume the NX session\n\
on this display.\n\
"

/*
 * These alerts are intended for network errors
 * encountered while connecting to a remote ser-
 * ver providing a foreign desktop protocol, as
 * RDP or RFB.
 */

#define REMOTE_SERVER_RDP_NOT_FOUND_ALERT                    25
#define REMOTE_SERVER_RDP_NOT_FOUND_TYPE                     "error"
#define REMOTE_SERVER_RDP_NOT_FOUND_STRING                   \
"\
The NX server was unable to determine the IP address of\n\
the RDP server you have configured. Please verify that\n\
the host name is correct.\n\
"

#define REMOTE_SERVER_RFB_NOT_FOUND_ALERT                    26
#define REMOTE_SERVER_RFB_NOT_FOUND_TYPE                     "error"
#define REMOTE_SERVER_RFB_NOT_FOUND_STRING                   \
"\
The NX server was unable to determine the IP address of\n\
the VNC server you have configured. Please verify that\n\
the host name is correct.\n\
"

#define REMOTE_SERVER_RDP_REFUSED_ALERT                      27
#define REMOTE_SERVER_RDP_REFUSED_TYPE                       "error"
#define REMOTE_SERVER_RDP_REFUSED_STRING                     \
"\
The connection to the remote RDP server was refused.\n\
Please verify that the RDP service is running on the\n\
host and port you have configured.\n\
"

#define REMOTE_SERVER_RFB_REFUSED_ALERT                      28
#define REMOTE_SERVER_RFB_REFUSED_TYPE                       "error"
#define REMOTE_SERVER_RFB_REFUSED_STRING                     \
"\
The connection to the remote VNC server was refused.\n\
Please verify that the VNC service is running on the\n\
host and port you have configured.\n\
"

#define REMOTE_SERVER_RDP_CONNECT_ALERT                      29
#define REMOTE_SERVER_RDP_CONNECT_TYPE                       "error"
#define REMOTE_SERVER_RDP_CONNECT_STRING                     \
"\
A network error was encountered while trying to connect\n\
to the RDP server. Please verify that the RDP server is\n\
reachable on the host and port you have configured.\n\
"

#define REMOTE_SERVER_RFB_CONNECT_ALERT                      30
#define REMOTE_SERVER_RFB_CONNECT_TYPE                       "error"
#define REMOTE_SERVER_RFB_CONNECT_STRING                     \
"\
A network error was encountered while trying to connect\n\
to the VNC server. Please verify that the VNC server is\n\
reachable on the host and port you have configured.\n\
"

#define REMOTE_SERVER_RDP_SHUTDOWN_ALERT                     31
#define REMOTE_SERVER_RDP_SHUTDOWN_TYPE                      "error"
#define REMOTE_SERVER_RDP_SHUTDOWN_STRING                    \
"\
The connection to the RDP server was shut down.\n\
Please verify that the NX server can still reach\n\
the RDP service on the given host and port and\n\
retry.\n\
"

#define REMOTE_SERVER_RFB_SHUTDOWN_ALERT                     32
#define REMOTE_SERVER_RFB_SHUTDOWN_TYPE                      "error"
#define REMOTE_SERVER_RFB_SHUTDOWN_STRING                    \
"\
The connection to the VNC server was shut down.\n\
Please verify that the NX server can still reach\n\
the VNC service on the given host and port and\n\
retry.\n\
"

#define REMOTE_SERVER_RDP_PROTOCOL_ALERT                     33
#define REMOTE_SERVER_RDP_PROTOCOL_TYPE                      "error"
#define REMOTE_SERVER_RDP_PROTOCOL_STRING                    \
"\
Can't establish a connection to the requested RDP\n\
server. The requested RDP server doesn't support a\n\
compatible version of the RDP protocol.\n\
"

#define REMOTE_SERVER_RFB_PROTOCOL_ALERT                     34
#define REMOTE_SERVER_RFB_PROTOCOL_TYPE                      "error"
#define REMOTE_SERVER_RFB_PROTOCOL_STRING                    \
"\
Can't establish a connection to the requested VNC\n\
server. The requested VNC server doesn't support a\n\
compatible version of the RFB protocol.\n\
"

#define REMOTE_SERVER_RDP_AUTHENTICATION_ALERT               35
#define REMOTE_SERVER_RDP_AUTHENTICATION_TYPE                "error"
#define REMOTE_SERVER_RDP_AUTHENTICATION_STRING              \
"\
The login to the RDP server failed. Please check\n\
the username and password you provided and retry.\n\
"

#define REMOTE_SERVER_RFB_AUTHENTICATION_ALERT               36
#define REMOTE_SERVER_RFB_AUTHENTICATION_TYPE                "error"
#define REMOTE_SERVER_RFB_AUTHENTICATION_STRING              \
"\
The login to the VNC server failed. Please check\n\
the username and password you provided and retry.\n\
"

#define REMOTE_SERVER_RDP_COLOR_LIMIT_ALERT                  37
#define REMOTE_SERVER_RDP_COLOR_LIMIT_TYPE                   "ok"
#define REMOTE_SERVER_RDP_COLOR_LIMIT_STRING                 \
"\
The RDP server is limiting the number of colors that are\n\
made available to this session. The session will continue\n\
normally but it will use less colors compared to what you\n\
originally requested.\n\
"

#define REMOTE_SERVER_RFB_COLOR_LIMIT_ALERT                  38
#define REMOTE_SERVER_RFB_COLOR_LIMIT_TYPE                   "ok"
#define REMOTE_SERVER_RFB_COLOR_LIMIT_STRING                 \
"\
The VNC server is limiting the number of colors that are\n\
made available to this session. The session will continue\n\
normally but it will use less colors compared to what you\n\
originally requested.\n\
"

#define REMOTE_SERVER_RDP_GEOMETRY_LIMIT_ALERT               39
#define REMOTE_SERVER_RDP_GEOMETRY_LIMIT_TYPE                "ok"
#define REMOTE_SERVER_RDP_GEOMETRY_LIMIT_STRING              \
"\
The RDP server is imposing the size of your remote desktop.\n\
This means that the session will continue normally but it\n\
normally but it will use a different geometry compared to\n\
what you originally requested.\n\
"

#define REMOTE_SERVER_RFB_GEOMETRY_LIMIT_ALERT               40
#define REMOTE_SERVER_RFB_GEOMETRY_LIMIT_TYPE                "ok"
#define REMOTE_SERVER_RFB_GEOMETRY_LIMIT_STRING              \
"\
The VNC server is imposing the size of your remote desktop.\n\
This means that the session will continue normally but it\n\
normally but it will use a different geometry compared to\n\
what you originally requested.\n\
"

/*
 * These are more specific RDP errors that may be
 * selected when receiving an error code from the
 * remote server.
 */

#define REMOTE_SERVER_RDP_TERMINATED_ALERT                   41
#define REMOTE_SERVER_RDP_TERMINATED_TYPE                    "error"
#define REMOTE_SERVER_RDP_TERMINATED_STRING                  \
"\
The session was terminated by the remote server.\n\
"

#define REMOTE_SERVER_RDP_MANDATED_DISCONNECT_ALERT          42
#define REMOTE_SERVER_RDP_MANDATED_DISCONNECT_TYPE           "error"
#define REMOTE_SERVER_RDP_MANDATED_DISCONNECT_STRING         \
"\
The session was terminated by the remote server.\n\
This probably means that the system administrator\n\
mandated the end of your remote session.\n\
"

#define REMOTE_SERVER_RDP_LOGOFF_DISCONNECT_ALERT            43
#define REMOTE_SERVER_RDP_LOGOFF_DISCONNECT_TYPE             "error"
#define REMOTE_SERVER_RDP_LOGOFF_DISCONNECT_STRING           \
"\
The session was terminated due to a logoff on\n\
the remote server. The system administrator or\n\
another user may have disconnected your remote\n\
session.\n\
"

#define REMOTE_SERVER_RDP_IDLE_DISCONNECT_ALERT              44
#define REMOTE_SERVER_RDP_IDLE_DISCONNECT_TYPE               "error"
#define REMOTE_SERVER_RDP_IDLE_DISCONNECT_STRING             \
"\
The session was terminated due to idle timeout.\n\
"

#define REMOTE_SERVER_RDP_LOGON_DISCONNECT_ALERT             45
#define REMOTE_SERVER_RDP_LOGON_DISCONNECT_TYPE              "error"
#define REMOTE_SERVER_RDP_LOGON_DISCONNECT_STRING            \
"\
The session was terminated because of a logon\n\
timeout.\n\
"

#define REMOTE_SERVER_RDP_ADMIN_DISCONNECT_ALERT             46
#define REMOTE_SERVER_RDP_ADMIN_DISCONNECT_TYPE              "error"
#define REMOTE_SERVER_RDP_ADMIN_DISCONNECT_STRING            \
"\
The session has been terminated. Maybe the remote\n\
access service was suspended or the administrator\n\
requested complete access to the system resources.\n\
"

#define REMOTE_SERVER_RDP_MEMORY_DISCONNECT_ALERT            47
#define REMOTE_SERVER_RDP_MEMORY_DISCONNECT_TYPE             "error"
#define REMOTE_SERVER_RDP_MEMORY_DISCONNECT_STRING           \
"\
The session was terminated because not enough\n\
memory is available on the remote server.\n\
"

#define REMOTE_SERVER_RDP_DENIED_DISCONNECT_ALERT            48
#define REMOTE_SERVER_RDP_DENIED_DISCONNECT_TYPE             "error"
#define REMOTE_SERVER_RDP_DENIED_DISCONNECT_STRING           \
"\
The session was terminated because the remote\n\
server denied the connection.\n\
"

#define REMOTE_SERVER_RDP_SECURITY_DISCONNECT_ALERT          49
#define REMOTE_SERVER_RDP_SECURITY_DISCONNECT_TYPE           "error"
#define REMOTE_SERVER_RDP_SECURITY_DISCONNECT_STRING         \
"\
The session was terminated because of the security\n\
restrictions set on the remote server.\n\
"

#define REMOTE_SERVER_RDP_FORBIDDEN_DISCONNECT_ALERT         50
#define REMOTE_SERVER_RDP_FORBIDDEN_DISCONNECT_TYPE          "error"
#define REMOTE_SERVER_RDP_FORBIDDEN_DISCONNECT_STRING        \
"\
The session was terminated by the remote server. The\n\
server is not licensed to accept remote connections.\n\
"

#define REMOTE_SERVER_RDP_PROTOCOL_DISCONNECT_ALERT          51
#define REMOTE_SERVER_RDP_PROTOCOL_DISCONNECT_TYPE           "error"
#define REMOTE_SERVER_RDP_PROTOCOL_DISCONNECT_STRING         \
"\
The session was terminated. An error was encountered\n\
in the application protocol.\n\
"

#define REMOTE_SERVER_RDP_INVALID_LICENSE_DISCONNECT_ALERT   52
#define REMOTE_SERVER_RDP_INVALID_LICENSE_DISCONNECT_TYPE    "error"
#define REMOTE_SERVER_RDP_INVALID_LICENSE_DISCONNECT_STRING  \
"\
The session was terminated due to the inability of\n\
the remote server to validate the client access\n\
license.\n\
"

#define REMOTE_SERVER_RDP_NETWORK_LICENSE_DISCONNECT_ALERT   53
#define REMOTE_SERVER_RDP_NETWORK_LICENSE_DISCONNECT_TYPE    "error"
#define REMOTE_SERVER_RDP_NETWORK_LICENSE_DISCONNECT_STRING  \
"\
The session was terminated due to the inability of\n\
the remote server to contact the license manager.\n\
"

#define REMOTE_SERVER_RDP_NO_LICENSE_DISCONNECT_ALERT        54 
#define REMOTE_SERVER_RDP_NO_LICENSE_DISCONNECT_TYPE         "error"
#define REMOTE_SERVER_RDP_NO_LICENSE_DISCONNECT_STRING       \
"\
The session was terminated due to the unavailability\n\
of a valid client access license. Please check if your\n\
license has expired or the maximum number of allowed\n\
connections has been exceeded.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_MESSAGE_DISCONNECT_ALERT   55
#define REMOTE_SERVER_RDP_LICENSE_MESSAGE_DISCONNECT_TYPE    "error"
#define REMOTE_SERVER_RDP_LICENSE_MESSAGE_DISCONNECT_STRING  \
"\
The session was terminated. An invalid license message\n\
was received from the server.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_SYSTEM_DISCONNECT_ALERT    56
#define REMOTE_SERVER_RDP_LICENSE_SYSTEM_DISCONNECT_TYPE     "error"
#define REMOTE_SERVER_RDP_LICENSE_SYSTEM_DISCONNECT_STRING   \
"\
The session was terminated. A system error was\n\
encountered while trying to access the license\n\
certificate.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_ERROR_DISCONNECT_ALERT     57
#define REMOTE_SERVER_RDP_LICENSE_ERROR_DISCONNECT_TYPE      "error"
#define REMOTE_SERVER_RDP_LICENSE_ERROR_DISCONNECT_STRING    \
"\
The session was terminated. The license certificate\n\
on the remote server doesn't appear to be valid.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_PROTO_DISCONNECT_ALERT     58
#define REMOTE_SERVER_RDP_LICENSE_PROTO_DISCONNECT_TYPE      "error"
#define REMOTE_SERVER_RDP_LICENSE_PROTO_DISCONNECT_STRING    \
"\
The session was terminated. An error was encountered\n\
while trying to negotiate a valid license.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_ABORT_DISCONNECT_ALERT     59
#define REMOTE_SERVER_RDP_LICENSE_ABORT_DISCONNECT_TYPE      "error"
#define REMOTE_SERVER_RDP_LICENSE_ABORT_DISCONNECT_STRING    \
"\
The session was terminated by the remote server. The\n\
server failed to complete the negotiation of a valid\n\
license.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_FORMAT_DISCONNECT_ALERT    60
#define REMOTE_SERVER_RDP_LICENSE_FORMAT_DISCONNECT_TYPE     "error"
#define REMOTE_SERVER_RDP_LICENSE_FORMAT_DISCONNECT_STRING   \
"\
The session was terminated by the remote server. The\n\
server detected an incorrect license format or the\n\
license was encrypted by by means of an unsupported\n\
algorithm.\n\
"

#define REMOTE_SERVER_RDP_LICENSE_UPGRADE_DISCONNECT_ALERT   61
#define REMOTE_SERVER_RDP_LICENSE_UPGRADE_DISCONNECT_TYPE    "error"
#define REMOTE_SERVER_RDP_LICENSE_UPGRADE_DISCONNECT_STRING  \
"\
The session was terminated by the remote server. The\n\
license on the server is invalid and can't be upgraded\n\
nor renewed.\n\
"

#define ABORT_PROXY_NEGOTIATION_ALERT                        62
#define ABORT_PROXY_NEGOTIATION_ALERT_TYPE                   "ok"
#define ABORT_PROXY_NEGOTIATION_ALERT_STRING                 \
"\
The remote proxy closed the connection while negotiating\n\
the session. This may be due to the wrong authentication\n\
credentials passed to the server.\n\
"

#define REMOTE_SERVER_RDP_REPLACED_DISCONNECT_ALERT          63
#define REMOTE_SERVER_RDP_REPLACED_DISCONNECT_TYPE           "error"
#define REMOTE_SERVER_RDP_REPLACED_DISCONNECT_STRING         \
"\
The session was terminated. Probably another session has\n\
been started using the same Windows account.\n\
"

#define ABORT_PROXY_SHUTDOWN_ALERT                           64
#define ABORT_PROXY_SHUTDOWN_ALERT_TYPE                      "ok"
#define ABORT_PROXY_SHUTDOWN_ALERT_STRING                    \
"\
No response received from the remote proxy while\n\
waiting for the session shutdown.\n\
"

#define FAILED_XDMCP_CONNECTION_ALERT                        65
#define FAILED_XDMCP_CONNECTION_ALERT_TYPE                   "ok"
#define FAILED_XDMCP_CONNECTION_ALERT_STRING                 \
"\
The XDM host that was contacted by the NX server doesn't\n\
seem to be able to start the session. Please check your\n\
server configuration.\n\
"

/*
 * Used to handle the backward compatibility.
 * Add a new protocol version adn update the
 * numbers if you add a new alert. 
 */

#define LAST_PROTO_STEP_5_ALERT  13
#define LAST_PROTO_STEP_6_ALERT  63

#endif /* NXalert_H */
