/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2003 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rigths reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#ifndef Tight_H
#define Tight_H

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>

#define MIN_SPLIT_RECT_SIZE            4096
#define MIN_SOLID_SUBRECT_SIZE         2048
#define MAX_SPLIT_TILE_SIZE              16


extern int NXEncodeTightInit(
#if NeedFunctionPrototypes
    Display*                /* display */,
    Drawable                /* drawable */,
    Visual*                 /* visual */,
    void*                   /* GC */,
    XImage*                 /* image */,
    unsigned int            /* method */,
    unsigned int            /* mask_method */
#endif
);

extern void NXEncodeTightUninit(
#if NeedFunctionPrototypes
    void
#endif
);

extern int  GetEncodeTightInitStatus(
#if NeedFunctionPrototypes
    void
#endif
);

extern void IncreaseRecDepth(
#if NeedFunctionPrototypes
    void
#endif
);

extern void DecreaseRecDepth(
#if NeedFunctionPrototypes
    void
#endif
);

extern int  GetEncodeTightMaxRows(
#if NeedFunctionPrototypes
    int
#endif                      /* width */
);

extern void FindBestSolidArea(
#if NeedFunctionPrototypes
    int                     /* x */,
    int                     /* y */,
    int                     /* width */,
    int                     /* height */,
    CARD32                  /* color_value */,
    int*                    /* result_width */,
    int*                    /* result_height */
#endif
);

extern void ExtendSolidArea(
#if NeedFunctionPrototypes
    int                     /* x */,
    int                     /* y */,
    int                     /* width */,
    int                     /* height */,
    CARD32                  /* color_value */,
    int*                    /* result_x */,
    int*                    /* result_y */,
    int*                    /* result_width */,
    int*                    /* result_height */
#endif
);

extern Bool CheckSolidTile(
#if NeedFunctionPrototypes
    int                     /* x */,
    int                     /* y */,
    int                     /* width */,
    int                     /* height */,
    CARD32*                 /* color */,
    Bool                    /* need_same_color */
#endif
);

extern Bool SendRectSimple(
#if NeedFunctionPrototypes
    int                     /* src_x */,
    int                     /* src_y */,
    int                     /* dst_x */,
    int                     /* dst_y */,
    int                     /* width */,
    int                     /* height */
#endif
);

extern Bool SendSubrect(
#if NeedFunctionPrototypes
    int                     /* src_x */,
    int                     /* src_y */,
    int                     /* dst_x */,
    int                     /* dst_y */,
    int                     /* width */,
    int                     /* height */
#endif
);

extern Bool SendSolidRect(
#if NeedFunctionPrototypes
    int                     /* src_x */,
    int                     /* src_y */,
    int                     /* dst_x */,
    int                     /* dst_y */,
    int                     /* width */,
    int                     /* height */
#endif
);

#ifdef __cplusplus
}
#endif

#endif /* Tight_H */

