/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "KWIQCGContext.h"
#include "KWIQCGContextFactory.h"
#include "GdkHelpers.h"

#include "KWQLogging.h"


void CGContextFlush(CGContextRef ref) {
  ref->flush();
}

void CGContextSaveGState(CGContextRef ref) {
  ref->saveGraphicsState();
}

void CGContextRestoreGState(CGContextRef ref) {
  ref->restoreGraphicsState();
}

void CGContextSetLineCap (CGContextRef ref, CGLineCap cap) {
  ref->setLineCap(cap);
}

void CGContextSetLineJoin (CGContextRef ref, CGLineJoin join) {
  ref->setLineJoin(join);
}

void CGContextSetLineWidth (CGContextRef ref, float width) {
  ref->setLineWidth(width);
}

void CGContextSetMiterLimit (CGContextRef ref, float limit) {
  ref->setMiterLimit(limit);
}

void CGContextSetRGBStrokeColor(CGContextRef ref, float red, float green, float blue, float alpha) {
  ref->setRGBStrokeColor(red, green, blue, alpha);
}

void CGContextSetRGBFillColor(CGContextRef ref, float red, float green, float blue, float alpha)  {
  ref->setRGBFillColor(red, green, blue, alpha);
}

void CGContextSetGrayStrokeColor(CGContextRef ref, float gray, float alpha) {
  ref->setGrayStrokeColor(gray, alpha);
}

void CGContextSetGrayFillColor(CGContextRef ref, float gray, float alpha)  {
  ref->setGrayFillColor(gray, alpha);
}

void CGContextSetCMYKStrokeColor(CGContextRef ref, float c, float m, float y, float k, float alpha) {
  ref->setCMYKStrokeColor(c, m, y, k, alpha);
}

void CGContextSetCMYKFillColor(CGContextRef ref, float c, float m, float y, float k, float alpha) {
  ref->setCMYKFillColor(c, m, y, k, alpha);
}

void CGContextAddArc (CGContextRef ref, float x, float y, float radius,
                      float startAngle, float endAngle, int clockwise) {
    ref->addArc(x, y, radius, startAngle, endAngle, clockwise);
}
 
void CGContextAddArcToPoint (CGContextRef ref, float x1, float y1,
                             float x2, float y2, float radius) {
    ref->addArcToPoint(x1, y1, x2, y2, radius);
}

void CGContextAddCurveToPoint (CGContextRef ref, float cp1x, float cp1y,
                               float cp2x, float cp2y, float x, float y) {
    ref->addCurveToPoint(cp1x, cp1y, cp2x, cp2y, x, y);
}

void CGContextAddLineToPoint (CGContextRef ref, float x, float y) {
    ref->addLineToPoint(x, y);
}

void CGContextAddQuadCurveToPoint (CGContextRef ref, float cpx, float cpy,
                                   float x, float y) {
    ref->addQuadCurveToPoint(cpx, cpy, x, y);
}

void CGContextAddRect (CGContextRef ref, float x, float y, float width, float height) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) width, (int) height);
  ref->addRect(&rect);
}

void CGContextBeginPath(CGContextRef ref) {
  ref->beginPath();
}

void CGContextClosePath(CGContextRef ref) {
  ref->closePath();
}

void CGContextMoveToPoint (CGContextRef ref, float x, float y) {
  ref->moveToPoint(x, y);
}

void CGContextClearRect (CGContextRef ref, float x, float y, float width, float height) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) width, (int) height);
  ref->clearRect(&rect);
}

void CGContextFillPath (CGContextRef ref) {
  ref->fillPath();
}

void CGContextFillRect (CGContextRef ref, float x, float y, float width, float height) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) width, (int) height);
  ref->fillRect(&rect);
}

void CGContextStrokePath (CGContextRef ref) {
  ref->strokePath();
}

void CGContextStrokeRect (CGContextRef ref, float x, float y, float width, float height) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) width, (int) height);
  ref->strokeRect(&rect);
}

void CGContextStrokeRectWithWidth (CGContextRef ref, float x, float y, float rectWidth, float rectHeight, float strokeWidth) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) rectWidth, (int) rectHeight);
  ref->strokeRectWithWidth(&rect, strokeWidth);
}

void CGContextClip (CGContextRef ref) {
  ref->clip();
}

void CGContextSetAlpha (CGContextRef ref, float alpha) {
  ref->setAlpha(alpha);
}


void CGContextSetShadow (CGContextRef ref, CGSize offset, float blur) {
  ref->setShadow(offset, blur);
}

void CGContextSetShadowWithColor (CGContextRef ref, CGSize offset, float blur, CGColorRef colorRef) {
  ref->setShadowWithColor(offset, blur, colorRef);
}

void CGContextRotateCTM (CGContextRef ref, float angle) {
  ref->rotateCTM(angle); }

void CGContextScaleCTM (CGContextRef ref, float sx, float sy) {
  ref->scaleCTM(sx, sy);
}

void CGContextTranslateCTM (CGContextRef ref, float tx, float ty) {
  ref->translateCTM(tx, ty);
}

CGSize CGSizeMake(float width, float height) {
  CGSize size;
  size.width = width;
  size.height = height;  
  return size;
}

CGContextRef CGBitmapContextCreate(int cWidth, int cHeight, int depth) {
  return CGContextFactory::sharedFactory()->createBitmapContext(cWidth, cHeight, depth);
}

CGImageRef CGBitmapContextCreateImage(CGContextRef context) {
  return context->createImage();
}

void CGContextDrawImage (CGContextRef context, float x, float y, float width, float height, CGImageRef image) {
  GdkRectangle rect;
  fillGdkRectangle(&rect, (int) x, (int) y, (int) width, (int) height);
  context->drawImage(&rect, image);
}


GdkDrawable* CGContext::realDrawable()
{
    return 0;
}

void CGContext::realTranslate( int *x, int *y)
{

}
