#ifdef DESKTOP_VERSION
#include <qprocess.h>
#else
#include <qtopia/qprocess.h>
#endif
#include <qapplication.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qtextview.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstring.h>
#include <stdlib.h>
#include "qpkg.h"
#ifdef DESKTOP_VERSION
#include "config.h"
#else
#include <qtopia/config.h>
#endif
#ifdef QWS
#include <qtopia/qcopenvelope_qws.h>
#endif

#include <stdlib.h>
#include <sys/vfs.h>

qpkg::qpkg( QWidget *parent, const char *name )
    : qpkgBase( parent, name ), ipkgRunning(false)
{
    proc = new QProcess( this );
    connect( proc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
    connect( proc, SIGNAL(readyReadStderr()), this, SLOT(readFromStderr()) );
    connect( proc, SIGNAL(processExited()), this, SLOT(ipkgFinished()) );

    ipkg_listview->clear();
    updateListView("/");
    updateListView("/mnt/card");
    updateListView("/mnt/cf");
    updateListView("/mnt/net");
    updateListView("/mnt/user");
    updateNewListView();
    
    Config *conf = new Config("Packager");
    conf->setGroup("Feeds");
    int numf = conf->readNumEntry("NumFeeds", 0);
    FeedListBox->clear();
    if (numf) {
	for (int i = 0; i < numf; i++) {
	    QString xxx = "Feed"+ QString::number(i);
	    QString feedstr = conf->readEntry(xxx);
	    FeedListBox->insertItem(feedstr);
	}
	conf->setGroup("Default");
	numf = conf->readNumEntry("CurrentFeed");
	FeedListBox->setCurrentItem(numf);
    } else {
#ifdef QT_QWS_IPAQ
	FeedListBox->insertItem("http://mirror1.pdaXrom.org/current-ipaq/feed/");
#elif QT_QWS_SL5XXX
	FeedListBox->insertItem("http://mirror1.pdaXrom.org/current-collie/feed/");
#else
	FeedListBox->insertItem("http://mirror1.pdaXrom.org/current/feed/");
#endif
    }
    conf->setGroup("Proxy");
    httpProxyLine->setText(conf->readEntry("Http",""));
    ftpProxyLine->setText(conf->readEntry("Ftp",""));
    loginLine->setText(conf->readEntry("Username",""));
    passwdLine->setText(conf->readEntry("Password",""));
    httpProxyEnable->setChecked(conf->readBoolEntry("HttpOn"));
    ftpProxyEnable->setChecked(conf->readBoolEntry("FtpOn"));
    delete conf;
    update_iconf();
    update_storages();
}

qpkg::~qpkg()
{
    Config *conf = new Config("Packager");
    conf->setGroup("Default");
    conf->writeEntry("CurrentFeed", FeedListBox->currentItem());
    conf->setGroup("Feeds");
    conf->clearGroup();
    conf->writeEntry("NumFeeds", (int)FeedListBox->count());
    for (unsigned int i=0; i<FeedListBox->count(); i++) {
	QString xxx = "Feed"+ QString::number(i);
        conf->writeEntry(xxx, FeedListBox->text(i));
    }
    conf->setGroup("Proxy");
    conf->clearGroup();
    conf->writeEntry("Http", httpProxyLine->text());
    conf->writeEntry("Ftp", ftpProxyLine->text());
    conf->writeEntry("Username", loginLine->text());
    conf->writeEntry("Password", passwdLine->text());
    conf->writeEntry("HttpOn", httpProxyEnable->isChecked());
    conf->writeEntry("FtpOn", ftpProxyEnable->isChecked());
    delete conf;
}

void qpkg::update_storages()
{
    dest_box->clear();
    update_storage("/"        );
    update_storage("/mnt/cf"  );
    update_storage("/mnt/hd"  );
    update_storage("/mnt/card");
    update_storage("/mnt/net" );
    update_storage("/mnt/user");
}

void qpkg::update_storage( QString disk)
{
    struct statfs buf;
    QString str;
    if (disk == "/mnt/user") str = "mount | grep '/home'";
    else str = "mount | grep '" + disk + "'";
    if ((!statfs(disk, &buf)) && (system(str) == 0)) {
	//long free = buf.f_bavail;
	//long bs = buf.f_bsize;
	//fprintf(stderr, "%ld %ld\n", free, bs);
	int s = buf.f_bavail * buf.f_bsize / 1024;
	QString size;
	if (s > 1024*4) {
	    s /= 1024;
	    size.setNum(s);
	    size.append(" MB");
	} else {
	    size.setNum(s);
	    size.append(" KB");
	}
	dest_box->insertItem(disk + " (" + size + ")" );
    }
}

void qpkg::install_ipkg()
{
#ifndef QT_NO_FILEDIALOG
    if (ipkgRunning) return;
    QString fn = QFileDialog::getOpenFileName( QString::null, /*QString::null*/"Packages (*.ipk *.deb)", this );
    if ( !fn.isEmpty() ) {
        //qDebug("package: " + fn);
	proc->clearArguments();
	proc->addArgument( "ipkg-install" );

	QString dest = dest_box->currentText();
	dest.truncate(dest.find(' '));
	proc->addArgument( dest );
	
	proc->addArgument( fn );
	ipkgRunning = true;
	if ( !proc->start() ) {
	    QMessageBox::critical( 0,
		tr("Fatal error"),
		tr("Could not start the ipkg command."),
		tr("Quit") );
	    ipkgRunning = false;
	    return;
	}
	install_button->setEnabled(false);
	go_button->setEnabled(false);
	reload_button->setEnabled(false);
	dest_box->setEnabled(false);
    }
#else
    update_storages();
    return;
#endif
}

void qpkg::netinstall_ipkg()
{
    if (ipkgRunning) return;

    proc->clearArguments();
    proc->addArgument( "ipkg-install" );
    
    QString dest = dest_box->currentText();
    dest.truncate(dest.find(' '));
    proc->addArgument( dest );

    bool argsOk = false;
    QListViewItem *item = new_listview->firstChild();
    while (item) {
	if (((QCheckListItem *)item)->isOn()) { proc->addArgument( item->text(0) ); argsOk = true; }
	item = item->nextSibling();
    }
    if (!argsOk) {
	QMessageBox::information(0, tr("Warning!"), tr("No package(s) selected!"), QMessageBox::Ok);
	return;
    }

    new_listview->clearSelection();

    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::go_ipkg()
{
    switch(tab_window->currentPageIndex()) {
	case 0: remove_ipkg(); break;
	case 1: netinstall_ipkg(); break;
	default: break;
    }
}

void qpkg::remove_ipkg()
{
    if (ipkgRunning) return;
    
    proc->clearArguments();
    proc->addArgument( "ipkg-uninstall" );
    
    QString spisok="";
    bool argsOk = false;
    QListViewItem *item = ipkg_listview->firstChild();
    while (item) {
	if (((QCheckListItem *)item)->isOn()) { proc->addArgument( item->text(0) ); argsOk = true; spisok += " " + item->text(0); }
	item = item->nextSibling();
    }
    if (!argsOk) {
	QMessageBox::information(0, tr("Warning!"), tr("No package(s) selected!"), QMessageBox::Ok);
	return;
    }

    QMessageBox mb(tr("Package manager"), tr("Remove packages "+spisok+"?"), 
		    QMessageBox::NoIcon, QMessageBox::Yes, QMessageBox::No | QMessageBox::Default, 0);
    if ( mb.exec() != QMessageBox::Yes ) return;
    
    ipkg_listview->clearSelection();

    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::readFromStdout()
{
    log_view->append( proc->readStdout() );
}

void qpkg::readFromStderr()
{
    log_view->append( proc->readStderr() );
}

void qpkg::ipkgFinished()
{
#ifdef QWS
    QCopEnvelope e("QPE/System", "linkChanged(QString)");
    QString lf = QString::null;
    e << lf;
#else
/*
 * matchbox hack for update icons on desktop and menu
 */
    system("killall -HUP matchbox-desktop");
    system("killall -HUP mb-applet-menu-launcher");
#endif
    ipkgRunning = false;
    ipkg_listview->clear();
    updateListView("/");
    updateListView("/mnt/card");
    updateListView("/mnt/cf");
    updateListView("/mnt/net");
    updateListView("/mnt/user");
    new_listview->clear();
    updateNewListView();
    install_button->setEnabled(true);
    go_button->setEnabled(true);
    reload_button->setEnabled(true);
    dest_box->setEnabled(true);
    update_storages();
}

void qpkg::updateListView(QString path)
{
    QFile f( QString( path + "/usr/lib/ipkg/status").latin1() );
    if (!f.exists()) {
	//qDebug("!status");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", dst_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		QListViewItem *tmp  = new QCheckListItem(ipkg_listview, /*dst_str + " " + */ pkg_str /* + " " + ver_str */, QCheckListItem::CheckBox);
		tmp->setText(1, ver_str);
		tmp->setText(2, dst_str);
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Root:",0)) >= 0) {
	    dst_str = str.right(str.length() - pos - 6);
	    dst_str.truncate(dst_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	QListViewItem *tmp  = new QCheckListItem(ipkg_listview, /*dst_str + " " + */ pkg_str /* + " " + ver_str */, QCheckListItem::CheckBox);
	tmp->setText(1, ver_str);
	tmp->setText(2, dst_str);
    }
    f.close();
}

bool qpkg::checkInst(QString &str)
{
    QListViewItem *item = ipkg_listview->firstChild();
    while (item) {
	if (str == item->text(0)) return true;
	item = item->nextSibling();
    }
    return false;
}

void qpkg::updateNewListView()
{
    system("ipkg info>/tmp/qpkg_packages.123");
    QFile f( QString("/tmp/qpkg_packages.123").latin1() );
    if (!f.exists()) {
	//qDebug("!status ap");
	return;
    }
    f.open( IO_ReadOnly );
    QString str="", pkg_str="", ver_str="", desc_str="", deps_str="";
    bool found = false;
    int pos;
    while(!f.atEnd()) {
	f.readLine(str, 80);
	if ((pos = str.find("Package:",0)) >= 0) {
	    if (found) {
		if (!checkInst(pkg_str)) {
		    QListViewItem *tmp  = new QCheckListItem(new_listview, pkg_str /* + " " + ver_str*/, QCheckListItem::CheckBox);
		    tmp->setText(1, ver_str);
		    tmp->setText(2, desc_str);
		    tmp->setText(3, deps_str);
		}
		pkg_str=""; 
		ver_str="";
		desc_str="";
		deps_str="";
	    }
	    pkg_str = str.right(str.length() - pos - 9);
	    pkg_str.truncate(pkg_str.length() - 1);
	    found = true;
	} else if ((pos = str.find("Version:",0)) >= 0) {
	    ver_str = str.right(str.length() - pos - 9);
	    ver_str.truncate(ver_str.length() - 1);
	} else if ((pos = str.find("Description:",0)) >= 0) {
	    desc_str = str.right(str.length() - pos - 13);
	    desc_str.truncate(desc_str.length() - 1);
	} else if ((pos = str.find("Depends:",0)) >= 0) {
	    deps_str = str.right(str.length() - pos - 9);
	    deps_str.truncate(deps_str.length() - 1);
	}
    }
    if (found) {
	found = false;
	if (!checkInst(pkg_str)) {
	    QListViewItem *tmp  = new QCheckListItem(new_listview, pkg_str /* + " " + ver_str*/, QCheckListItem::CheckBox);
	    tmp->setText(1, ver_str);
	    tmp->setText(2, desc_str);
	    tmp->setText(3, deps_str);
	}
    }
    f.close();
    system("rm -f /tmp/qpkg_packages.123");
}

void qpkg::reload_ipkg()
{
//    qDebug("-- "+QString::number(tab_window->currentPageIndex()));
    if (ipkgRunning) return;
    proc->clearArguments();
    proc->addArgument( "ipkg" );
    proc->addArgument( "update" );
    ipkgRunning = true;
    if ( !proc->start() ) {
	QMessageBox::critical( 0,
	    tr("Fatal error"),
	    tr("Could not start the ipkg command."),
	    tr("Quit") );
	ipkgRunning = false;
	return;
    }
    install_button->setEnabled(false);
    go_button->setEnabled(false);
    reload_button->setEnabled(false);
    dest_box->setEnabled(false);
}

void qpkg::add_feed()
{
    FeedListBox->insertItem(NewFeedLineEdit->text());
    NewFeedLineEdit->setText("");
    FeedListBox->setCurrentItem(FeedListBox->count()-1);
    update_iconf();
}

void qpkg::remove_feed()
{
    FeedListBox->removeItem(FeedListBox->currentItem());
    update_iconf();
}

void qpkg::edit_feed()
{
    NewFeedLineEdit->setText(FeedListBox->currentText());
}

void qpkg::update_iconf()
{
    QFile options("/etc/ipkg.conf");
    if ( options.open(IO_WriteOnly) ) {
	QTextStream opt(&options);
	for (unsigned int i=0; i<FeedListBox->count(); i++) {
	    opt << "src feed" << i << " " << FeedListBox->text(i) << "\n";
	}

	opt << "dest root /\n";
	opt << "dest cf /mnt/cf\n";
	opt << "dest sd /mnt/card\n";
	opt << "dest net /mnt/net\n";
	opt << "dest ide /mnt/ide\n";
	opt << "dest user /mnt/user\n";

	opt << "dest tmpinst /home/tmp/ipkg/inst\n";
	if (!httpProxyLine->text().isEmpty() && httpProxyEnable->isChecked()) {
	    opt << "option http_proxy " << httpProxyLine->text() << "\n";
	}
	if (!ftpProxyLine->text().isEmpty() && ftpProxyEnable->isChecked()) {
	    opt << "option ftp_proxy " << ftpProxyLine->text() << "\n";
	}
	if (!loginLine->text().isEmpty()) {
	    opt << "option proxy_username " << loginLine->text() << "\n";
	    opt << "option proxy_password " << passwdLine->text() << "\n";
	}	
    }
}

void qpkg::proxy_apply()
{
    update_iconf();
}
