#!/usr/bin/python
#
# Copyright (c) 2005, Florent Pillet.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Library General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
# 
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
# General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public License
# along with this library; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
# $Id: setup-standalone.py.in,v 1.3 2005/05/12 20:07:25 fpillet Exp $

from distutils.core import setup, Extension
import sys

if sys.platform.startswith('darwin'):
    # additional link options for Mac OS X
    link_options = ['-framework','Carbon','-framework','System','-framework','IOKit']
else:
    # TODO: test on other platforms and add options as appropriate
    link_options = None

setup(name = "python-libpisock",
      version = "0.12.0",
      description = "Python bindings for the pisock library linked in a standalone module (not requiring the libpisock shared lib).",
      author = "Florent Pillet",
      author_email = "pilot-link@florentpillet.com",
      url = "http://www.pilot-link.org/",

      ext_modules = [Extension("_pisock", ["src/pisock_wrap.c"],
                               include_dirs = ['../../include'],
                               extra_objects = ['../../libpisock/.libs/libpisock.a'],
                               extra_link_args = link_options
                               )
                     ],
      package_dir = {'': 'src'},
      py_modules = ["pisock","pisockextras"])
