#include <qlineedit.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qslider.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qregexp.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qwidget.h>
#include <qdir.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "pppconfig.h"

static QString stringQuote(const QString& s)
{
    QString r="\"";
    for (int i=0; i<(int)s.length(); i++) {
	char c = s[i].latin1();
	switch (c) {
	    case '\\': case '"':
		r+="\\";
	}
	r += s[i];
    }
    r += "\"";
    return r;
}

static bool setSecret( QFile &paps, const QString& user, const QString& server, const QString& secret, const QString& address)
{
    QString id = user + " " + server + " ";
    QString entry = id + stringQuote(secret);
    if ( !address.isEmpty() )
	entry += " " + address;
    QStringList secrets;
    if ( paps.open(IO_ReadOnly) ) {
	{
	    QTextStream s(&paps);
	    while ( !s.eof() ) {
		QString se = s.readLine();
		if ( se == entry )
		    return TRUE; // already in there
		if ( se.left(id.length()) != id )
		    secrets.append(se);
	    }
	}
	paps.close();
    }
    if ( !secret.isNull() ) // null for deleting secrets
	secrets.append(entry);
    if ( paps.open(IO_WriteOnly) ) {
	fchmod(paps.handle(),0600);
	{
	    QTextStream s(&paps);
	    s << secrets.join("\n") << "\n";
	}
	paps.close();
	return TRUE;
    }
    return FALSE;
}

static bool setPapSecret(const QString& user, const QString& server, const QString& secret, const QString& address)
{
    bool retval = TRUE;
    // joespc    server    "joe's secret" joespc.my.net
    QFile paps("/etc/ppp/pap-secrets" );
    if ( !setSecret( paps, user, server, secret, address ) )
	retval = FALSE;
    QFile chaps( "/etc/ppp/chap-secrets" );
    if ( !setSecret( chaps, user, server, secret, address ) )
	retval = FALSE;
    return retval;
}


PPPConfig::PPPConfig(QWidget *parent, const char *name):
    PPPConfigBase(parent, name)
{

    QString dir = QString(getenv("HOME")) + QString("/Choices/common/");
    QDir d(dir);

    acname->clear();

    bool found = false;

    d.setFilter( QDir::Files );
    d.setNameFilter("Network-PPP-*.conf");
    for (unsigned int i = 0; i < d.count(); i++) {
	if (d[i] != "Network-PPP-.conf") {
	    Config cfg(dir + d[i], Config::File);
	    cfg.setGroup("Info");
	    addConfig(cfg.readEntry("name"));
	    found = true;
	}
    }

    if (found) {
	Config *config = new Config("Network-PPP-" + acname->currentText());
	readConfig(config);
	delete config;
    } else {
	deviceList->setEnabled(false);
	btPin->setEnabled(false);
	searchDevice->setEnabled(false);
    }
}

PPPConfig::~PPPConfig()
{
//    delete config;
}

void PPPConfig::serial_selected()
{
    btdevice->setText("/dev/ttyS0");
    deviceList->setEnabled(false);
    btPin->setEnabled(false);
    searchDevice->setEnabled(false);
}

void PPPConfig::irda_selected()
{
    btdevice->setText("/dev/ircomm0");
    deviceList->setEnabled(false);
    btPin->setEnabled(false);
    searchDevice->setEnabled(false);
}

void PPPConfig::bt_selected()
{
    btdevice->setText("/dev/rfcomm0");
    deviceList->setEnabled(true);
    btPin->setEnabled(true);
    searchDevice->setEnabled(true);
}

void PPPConfig::Apply()
{
    Config *config = new Config("Network-PPP-" + acname->currentText());
    writeConfig(config);
    delete config;
    addConfig(acname->currentText());
}

void PPPConfig::delete_account()
{
    QString file = QString(getenv("HOME")) + "/Choices/common/Network-PPP-" + acname->currentText()  + ".conf";
    QFile f(file);
    if (f.exists()) f.remove();
    QFile c("/etc/ppp/peers/" + acname->currentText());
    if (c.exists()) c.remove();
    removeConfig(acname->currentText());
}

void PPPConfig::new_account(const QString &str)
{
    QString file = QString(getenv("HOME")) + "/Choices/common/Network-PPP-" + str  + ".conf";
    QFile f(file);
    if (f.exists()) {
	config = new Config("Network-PPP-" + str);
	readConfig(config);
	delete config;
    }
    addConfig(str);
}

void PPPConfig::removeConfig(QString n)
{
    for (int i = 0; i < acname->count(); i++) {
	if (n == acname->text(i)) {
	    acname->removeItem(i);
	}
    }
}

void PPPConfig::addConfig(QString n)
{
    removeConfig(n);
    acname->insertItem(n);
    acname->setCurrentItem(acname->count()-1);
}

void PPPConfig::writeConfig(Config *conf)
{
    conf->setGroup("Info");
    conf->writeEntry("name", acname->currentText());

    conf->setGroup("Properties");
    conf->writeEntry("username", username->text());
    conf->writeEntry("password", password->text());
    conf->writeEntry("phone", phone->text());

    conf->writeEntry("Serial", serial_button->isChecked());
    conf->writeEntry("IrDA", irda_button->isChecked());
    conf->writeEntry("Bluetooth", bluetooth_button->isChecked());
    conf->writeEntry("device", btdevice->text());
    conf->writeEntry("atdial", atdial->text());
    conf->writeEntry("speed", speed->currentText());
    conf->writeEntry("crtscts", crtscts->isChecked());
    conf->writeEntry("connectdelay", connectdelay->value()*1000);
    conf->writeEntry("BTDUN", deviceList->currentText());
    conf->writeEntry("BTPIN", btPin->text());
    conf->writeEntry("dialmode", dialmode->id(dialmode->selected()));
    conf->writeEntry("idletime", idletime->value());

    conf->writeEntry("defaultroute", defaultroute->isChecked());
    conf->writeEntry("gateway", gateway->text());
    conf->writeEntry("usepeerdns", usepeerdns->isChecked());
    conf->writeEntry("dns1", dns1->text());
    conf->writeEntry("dns2", dns2->text());
    
    QString acid = acname->currentText();
    
    mkdir("/etc/ppp/peers",0700);
    QFile options("/etc/ppp/peers/"+acid);
    if ( options.open(IO_WriteOnly) ) {
	QTextStream opt(&options);
	opt << btdevice->text() << "\n";
	opt << speed->currentText() << "\n";
	QString dial = atdial->text();
	//opt << "debug\n";
	opt << "connect '/usr/sbin/chat " // No tr
	        "-s -v "
		"ABORT \"NO CARRIER\" " // No tr
		"ABORT \"NO DIALTONE\" " // No tr
		"ABORT \"BUSY\" " // No tr
		"\"\" "
		+ dial.replace(QRegExp("[\"]"),"\\\\\"").replace(QRegExp("[\\]"),"\\\\") + " OK " // No tr
		+ "ATDT" + phone->text() + " CONNECT'\n";
	if ( crtscts->isChecked() )
	    opt << "crtscts\n";
	else
	    opt << "nocrtscts\n";
	opt << "noipdefault\n";
	opt << "modem\n"; // No tr
	QString user = username->text();
	if ( !user.isEmpty() )
	    opt << "user " << stringQuote(user) << "\n"; // No tr
	int dmode = dialmode->id(dialmode->selected());
	if ( dmode == 2 )
	    opt << "demand\n"; // No tr
	int idlet = idletime->value();
	if ( dmode > 0 && idlet )
	    opt << "idle " << idlet << "\n"; // No tr
	if ( usepeerdns->isChecked()  )
	    opt << "usepeerdns\n";
	if ( defaultroute->isChecked() )
	    opt << "defaultroute\n";
	int cdel = connectdelay->value()*1000;
	if ( cdel )
	    opt << "connect-delay " << cdel << "\n";
	if ( !acid.isEmpty() )
	    opt << "remotename " << acid << "\n";
	QString pw = password->text();
//	if ( prev_user != user )
//	    setPapSecret(prev_user,acid,QString::null,"");
	if ( !pw.isEmpty() )
	    setPapSecret(user,acid,pw,"");
	else
	    setPapSecret(user,acid,QString::null,"");
	//return TRUE;
    }

    if (bluetooth_button->isChecked()) saveBtInfo();
}

void PPPConfig::readConfig(Config *conf)
{
    conf->setGroup("Info");
    addConfig(conf->readEntry("name", "DialUp connection"));
//    acname->insertItem(conf->readEntry("name", "DialUp connection"));
//    acname->setCurrentItem(acname->count() - 1);

    conf->setGroup("Properties");
    username->setText(conf->readEntry("username"));
    password->setText(conf->readEntry("password"));
    phone->setText(conf->readEntry("phone"));

    serial_button->setChecked(conf->readBoolEntry("Serial"));
    irda_button->setChecked(conf->readBoolEntry("IrDA"));
    bluetooth_button->setChecked(conf->readBoolEntry("Bluetooth"));
    btdevice->setText(conf->readEntry("device", "/dev/ttyS0"));
    atdial->setText(conf->readEntry("atdial", "ATZ"));
    QString spd = conf->readEntry("speed");
    if (!spd.isEmpty()) {
	speed->insertItem(spd);
	speed->setCurrentItem(speed->count()-1);
    }
    crtscts->setChecked(conf->readBoolEntry("crtscts"));
    connectdelay->setValue(conf->readNumEntry("connectdelay", 0)/1000);
    deviceList->insertItem(conf->readEntry("BTDUN", ""));
    btPin->setText(conf->readEntry("BTPIN", ""));

    dialmode->setButton(conf->readNumEntry("dialmode", 0));
    idletime->setValue(conf->readNumEntry("idletime",120));

    if (!conf->readBoolEntry("defaultroute")) {
	gateway->setText(conf->readEntry("gateway"));
	defaultroute->setChecked(false);
    } else {
	defaultroute->setChecked(true);
    }
    if (!conf->readBoolEntry("usepeerdns")) {
	dns1->setText(conf->readEntry("dns1"));
	dns2->setText(conf->readEntry("dns2"));
	usepeerdns->setChecked(false);
    } else {
	usepeerdns->setChecked(true);
    }
    if (bluetooth_button->isChecked()) {
	deviceList->setEnabled(true);
	btPin->setEnabled(true);
	searchDevice->setEnabled(true);
    } else {
	deviceList->setEnabled(false);
	btPin->setEnabled(false);
	searchDevice->setEnabled(false);
    }
}

void PPPConfig::btSearchClicked()
{
    QString mac_addr;
    QString chan_num;
    int cnt = 0;
    bool ready = false;

    deviceList->clear();
    system("/usr/bin/sdptool browse 2>/tmp/napsearch.err >/tmp/napsearch.txt");

    FILE *f = fopen("/tmp/napsearch.txt", "rb");
    if (f) {
	char bufr[256];
	while (!feof(f)) {
	    fgets(bufr, 64, f);
	    char *buf = bufr;
	    
	    while ((*buf == ' ') && (buf != (buf +  strlen(buf)))) {
		buf++;
	    }
	    
	    if (strncmp(buf, "Browsing", 8) == 0) {
		char mac[32];
		strncpy(mac, buf+9, 17);
		mac[17] = 0;
		if ((mac[2]==':') && (mac[5]==':') && (mac[8]==':') && (mac[11]==':') && (mac[14]==':')) {
		    //btAddress->setText(mac);
		    //fclose(f);
		    //unlink("/tmp/napsearch.txt");
		    //unlink("/tmp/napsearch.err");
		    //return;
		    mac_addr = mac;
		}
	    }
	    if (strncmp(buf, "Service Name:", 13) == 0) {
		if (ready) {
		    deviceList->insertItem(mac_addr + "," + chan_num);
		    ready = false;
		    mac_addr = "";
		    chan_num = "";
		    cnt++;
		}	    
	    }
	    if (strncmp(buf, "Service Name: Dial-up", 21) == 0) {
		ready = true;
	    }
	    if (strncmp(buf, "Channel:", 8) == 0) {
		char chan[6];
		memset(chan, 0, 6);
		strcpy(chan, buf+9);
		chan[strlen(chan) - 1] = 0;
		chan_num = chan;
	    }
	}
	fclose(f);
    }
    if (ready) {
	deviceList->insertItem(mac_addr + "," + chan_num);
	cnt++;
    }	    

    unlink("/tmp/napsearch.txt");
    unlink("/tmp/napsearch.err");
    if (cnt == 0) QMessageBox::information(this, tr("DUN Search"), tr("Can't get DUN info."));
}

void PPPConfig::saveBtInfo()
{
    FILE *f = fopen("/etc/bluetooth/rfcomm.conf", "wb");
    QString str = btdevice->text().mid(5, btdevice->text().length() - 5);
    fprintf(f, "%s {\n", str.ascii());
    fprintf(f, "    bind yes;\n");
    str = deviceList->currentText().left(17);
    fprintf(f, "    device %s;\n", str.ascii());
    str = deviceList->currentText().mid(18, deviceList->currentText().length() - 17);
    fprintf(f, "    channel %s;\n", str.ascii());
    fprintf(f, "    comment \"Generated by BT dial-up network applet.\";\n"),
    fprintf(f, "}\n");
    fclose(f);

    f = fopen("/etc/bluetooth/pin", "wb");
    str = btPin->text();
    fprintf(f, "%s\n", str.ascii());
    fclose(f);

    system("/etc/rc.d/init.d/bluetooth restart");
}
