/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the motif module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QMOTIF_H
#define QMOTIF_H

#include <qabstracteventdispatcher.h>
#include <X11/Intrinsic.h>

class QMotifPrivate;

class QMotif : public QAbstractEventDispatcher
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(QMotif)

public:
    QMotif(const char *applicationClass, XtAppContext context = NULL,
           XrmOptionDescRec *options = 0, int numOptions = 0);
    ~QMotif();

    XtAppContext applicationContext() const;

    static Display *display();
    static XEvent *lastEvent();

    static void registerWidget(QWidget *);
    static void unregisterWidget(QWidget *);
    static bool redeliverEvent(XEvent *event);

    // QAbstractEventDispatcher interface
    bool processEvents(QEventLoop::ProcessEventsFlags flags);
    bool hasPendingEvents();

    void registerSocketNotifier(QSocketNotifier *);
    void unregisterSocketNotifier(QSocketNotifier *);

    int registerTimer(int interval, QObject *object);
    bool unregisterTimer(int timerId);
    bool unregisterTimers(QObject *object);

    void wakeUp();
    void interrupt();
    void flush();

    void startingUp();
    void closingDown();
};

#endif // QMOTIF_H
