/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the embedded classes of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QGFXRASTER_QWS_H
#define QGFXRASTER_QWS_H

#include "qgfxrasterbase_qws.h"

template <const int depth, const int type>
class QGfxRaster : public QGfxRasterBase, protected QWSPolygonScanner {
public:
    QGfxRaster(unsigned char *, int w, int h);
    ~QGfxRaster();

    virtual void drawPoint(int, int);
    virtual void drawPoints(const QPointArray &, int, int);
    virtual void drawLine(int, int, int, int);
    virtual void fillRect(int, int, int, int);
    virtual void drawPolyline(const QPointArray &, int, int);
    virtual void drawPolygon(const QPointArray &, bool, int, int);
    virtual void blt(int, int, int, int, int, int);
    virtual void scroll(int, int, int, int, int, int);
#if !defined(QT_NO_MOVIE) || !defined(QT_NO_TRANSFORMATIONS) || !defined(QT_NO_PIXMAP_TRANSFORMATION)
    virtual void stretchBlt(int, int, int, int, int, int);
#endif
    virtual void tiledBlt(int, int, int, int);

    virtual int bitDepth() { return depth; }

    virtual void setSource(const QImage *);
    virtual void setSource(const QPaintDevice *);
    virtual void setSource(unsigned char *, int, int, int, int, QRgb *, int);

protected:
    virtual void drawThickLine(int, int,int, int);
    virtual void drawThickPolyline(const QPointArray &,int, int);

    void buildSourceClut(const QRgb *cols , int numcols);
    void processSpans(int n, QPoint *point, int *width);

    void vline(int, int, int); // Optimised vertical line drawing
    void hline(int, int, int); // Optimised horizontal line drawing
    void hlineUnclipped(int, int, unsigned char *);
    void hImageLineUnclipped(int x1, int x2, unsigned char *l, unsigned const char *srcdata,
                             bool reverse);
    void hAlphaLineUnclipped(int x1, int x2, unsigned char *l, unsigned const char *srcdata,
                             unsigned const char *alphas);
    void drawPointUnclipped(int, unsigned char *);
    void drawAlphaPointUnclipped(int, unsigned char *);

    void calcPacking(void *, int, int, int &, int &, int &);
};

#endif // QGFXRASTER_QWS_H
