/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the embedded classes of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QWSREGIONMANAGER_QWS_H
#define QWSREGIONMANAGER_QWS_H

#include "qlist.h"
#include "qregion.h"

class QWSRegionHeader;
class QWSRegionIndex;

class QWSRegionManager
{
public:
    QWSRegionManager(const QString &filename, bool c = true);
    ~QWSRegionManager();

    // for clients
    const int *revision(int idx) const;
    QRegion region(int idx);

    int find(int id);

    // for server
    int add(int id, QRegion region);
    void set(int idx, QRegion region);
    void remove(int idx);
    void markUpdated(int idx);
    void commit();

private:
    QRect *rects(int offset);
    bool attach(const QString &filename);
    void detach();

private:
    bool client;
    QList<QRegion*> regions;
    QWSRegionHeader *regHdr;
    QWSRegionIndex *regIdx;
    unsigned char *data;
    int shmId;
};

#endif // QWSREGIONMANAGER_QWS_H
