/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the widgets module of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "qmenudata.h"

#ifdef QT_COMPAT
#include <qaction.h>
#include <qsignal.h>
#include <private/qaction_p.h>
#define d d_func()

struct QActionAccessor { QActionPrivate *d_ptr; };
class QMenuItemEmitter : public QObject
{
    Q_OBJECT
    QMenuItem *menuitem;
    QSignalEmitter *sig;
public:
    inline QMenuItemEmitter(QMenuItem *mi) : QObject(mi), menuitem(mi) {
        sig = new QSignalEmitter("int");
        QObject::connect(mi, SIGNAL(triggered()), this, SLOT(doSignalEmit()));
    }
    inline ~QMenuItemEmitter() { delete sig; }
    inline QSignalEmitter *signal() const { return sig; }
 private slots:
    void doSignalEmit() {
        int value = reinterpret_cast<QActionAccessor*>(menuitem)->d_ptr->param;
        sig->activate(&value);
    }
};
#include "qmenudata.moc"

/*!
    \class QMenuItem
    \brief The QMenuItem class represents an item in a menu.

    \compat

    Use QAction instead.
*/

QMenuItem::QMenuItem() : QAction((QWidget*)0)
{
}

void QMenuItem::setId(int id)
{
    d->param = d->id = id;
}

int QMenuItem::id() const
{
    return d->id;
}

QSignalEmitter *QMenuItem::signal() const
{
    if(!d->act_signal) {
        QMenuItem *that = const_cast<QMenuItem*>(this);
        that->d->act_signal = new QMenuItemEmitter(that);
    }
    return d->act_signal->signal();
}

void QMenuItem::setSignalValue(int param)
{
    d->param = param;
}

int QMenuItem::signalValue() const
{
    return d->param;
}
#endif
