/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "formwindowcursor.h"
#include "formwindow.h"
#include "command.h"

// sdk
#include <propertysheet.h>
#include <qextensionmanager.h>

#include <qdebug.h>

FormWindowCursor::FormWindowCursor(FormWindow *fw, QObject *parent)
    : QObject(parent),
      m_formWindow(fw),
      m_iterator(0)
{
    update();
    connect(fw, SIGNAL(changed()), this, SLOT(update()));
}

FormWindowCursor::~FormWindowCursor()
{
}

AbstractFormWindow *FormWindowCursor::formWindow() const
{
    return m_formWindow;
}

bool FormWindowCursor::movePosition(MoveOperation op, MoveMode mode)
{
    if (mode == MoveAnchor)
        m_formWindow->clearSelection(false);

    switch (op) {
    case Next:
        ++m_iterator;
        if (m_iterator >= widgetCount())
            m_iterator = 0;

        m_formWindow->selectWidget(m_formWindow->widgetAt(m_iterator), true);
        return true;

    case Prev:
        --m_iterator;
        if (m_iterator < 0)
            m_iterator = 0;

        m_formWindow->selectWidget(m_formWindow->widgetAt(m_iterator), true);
        return true;

    default:
        return false;
    }
}

int FormWindowCursor::position() const
{
    return m_iterator;
}

void FormWindowCursor::setPosition(int pos, MoveMode mode)
{
    if (!widgetCount())
        return;

    if (mode == MoveAnchor)
        m_formWindow->clearSelection(false);

    m_iterator = pos;
    if (m_iterator >= widgetCount())
        m_iterator = 0;

    m_formWindow->selectWidget(m_formWindow->widgetAt(m_iterator), true);
}

QWidget *FormWindowCursor::current() const
{
    if (m_iterator < widgetCount())
        return m_formWindow->widgetAt(m_iterator);
    return 0;
}

bool FormWindowCursor::hasSelection() const
{
    return !m_formWindow->selectedWidgets().isEmpty();
}

int FormWindowCursor::selectedWidgetCount() const
{
    int N = m_formWindow->selectedWidgets().count();
    return N ? N : 1;
}

QWidget *FormWindowCursor::selectedWidget(int index) const
{
    return hasSelection()
        ? m_formWindow->selectedWidgets().at(index)
        : m_formWindow->mainContainer();
}

void FormWindowCursor::update()
{
    // ### todo
}

int FormWindowCursor::widgetCount() const
{
    return m_formWindow->widgetCount();
}

QWidget *FormWindowCursor::widget(int index) const
{
    return m_formWindow->widgetAt(index);
}

void FormWindowCursor::setProperty(const QString &name, const QVariant &value)
{
    int N = selectedWidgetCount();
    Q_ASSERT(N);

    if (N > 1)
        m_formWindow->commandHistory()->push(new QtCommand(QtCommand::MacroBegin, tr("changed '%1'").arg(name)));

    for (int i=0; i<N; ++i) {
        QWidget *w = selectedWidget(i);

        IPropertySheet *sheet = qt_extension<IPropertySheet*>(m_formWindow->core()->extensionManager(), w);
        Q_ASSERT(sheet);

        SetPropertyCommand *cmd = new SetPropertyCommand(m_formWindow);
        cmd->init(w, name, value);

        m_formWindow->commandHistory()->push(cmd);
    }

    if (N > 1)
        m_formWindow->commandHistory()->push(new QtCommand(QtCommand::MacroEnd));
}
