/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the dialog module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qabstractprintdialog.h"
#include "qabstractprintdialog_p.h"

#define d d_func()

QAbstractPrintDialog::QAbstractPrintDialog(QPrinter *printer, QWidget *parent)
    : QDialog(*(new QAbstractPrintDialogPrivate), parent)
{
    d->printer = printer;
}

QAbstractPrintDialog::QAbstractPrintDialog(QAbstractPrintDialogPrivate &ptr,
                                           QPrinter *printer,
                                           QWidget *parent)
    : QDialog(ptr, parent)
{
    d->printer = printer;
}

void QAbstractPrintDialog::setEnabledOptions(PrintDialogOptions options)
{
    d->options = options;
}

void QAbstractPrintDialog::addEnabledOption(PrintDialogOption option)
{
    d->options |= option;
}

QAbstractPrintDialog::PrintDialogOptions QAbstractPrintDialog::enabledOptions() const
{
    return d->options;
}

bool QAbstractPrintDialog::isOptionEnabled(PrintDialogOption option) const
{
    return d->options & option;
}

void QAbstractPrintDialog::setPrintRange(PrintRange range)
{
    d->printRange = range;
}

QAbstractPrintDialog::PrintRange QAbstractPrintDialog::printRange() const
{
    return d->printRange;
}

void QAbstractPrintDialog::setMinMax(int min, int max)
{
    Q_ASSERT_X(min <= max, "QAbstractPrintDialog::setMinMax",
               "'min' must be less than or equal to 'max'");
    d->minPage = min;
    d->maxPage = max;
    d->options |= PrintPageRange;
}

int QAbstractPrintDialog::minPage() const
{
    return d->minPage;
}

int QAbstractPrintDialog::maxPage() const
{
    return d->maxPage;
}

void QAbstractPrintDialog::setFromTo(int from, int to)
{
    Q_ASSERT_X(from <= to, "QAbstractPrintDialog::setFromTo",
               "'from' must be less than or equal to 'to'");
    d->fromPage = from;
    d->toPage = to;

    if (d->minPage == 0 && d->maxPage == 0)
        setMinMax(1, to);
}

int QAbstractPrintDialog::fromPage() const
{
    return d->fromPage;
}

int QAbstractPrintDialog::toPage() const
{
    return d->toPage;
}

QPrinter *QAbstractPrintDialog::printer() const
{
    return d->printer;
}
