/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the painting module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QPOLYGON_H
#define QPOLYGON_H

#include "qvector.h"
#include "qpoint.h"
#include "qrect.h"

class QPointArray;
class QRectF;

class Q_GUI_EXPORT QPolygon : public QVector<QPointF>
{
public:
    inline QPolygon() {}
    inline ~QPolygon() {}
    inline QPolygon(int size) : QVector<QPointF>(size) {}
    inline QPolygon(const QPolygon &a) : QVector<QPointF>(a) {}
    inline QPolygon(const QVector<QPointF> &v) : QVector<QPointF>(v) {}
    QPolygon(const QRectF &r);

    inline void translate(float dx, float dy);
    void translate(const QPointF &offset);

    QPointArray toPointArray() const;
    static QPolygon fromPointArray(const QPointArray &a);

    bool isClosed() const { return !isEmpty() && first() == last(); }

    QRectF boundingRect() const;
};

#ifndef QT_NO_DEBUG_OUTPUT
Q_GUI_EXPORT QDebug operator<<(QDebug, const QPolygon &);
#endif

/*****************************************************************************
  QPolygon stream functions
 *****************************************************************************/
#ifndef QT_NO_DATASTREAM
Q_GUI_EXPORT QDataStream &operator<<(QDataStream &stream, const QPolygon &array);
Q_GUI_EXPORT QDataStream &operator>>(QDataStream &stream, QPolygon &array);
#endif

inline void QPolygon::translate(float dx, float dy)
{ translate(QPointF(dx, dy)); }

#endif // QPOLYGONy_H
