/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the sql module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <qsqldriverplugin.h>
#include <qstringlist.h>
#include "../../../../src/sql/drivers/sqlite2/qsql_sqlite2.h"

class QSQLite2DriverPlugin : public QSqlDriverPlugin
{
public:
    QSQLite2DriverPlugin();

    QSqlDriver* create(const QString &);
    QStringList keys() const;
};

QSQLite2DriverPlugin::QSQLite2DriverPlugin()
    : QSqlDriverPlugin()
{
}

QSqlDriver* QSQLite2DriverPlugin::create(const QString &name)
{
    if (name == QLatin1String("QSQLITE2")) {
        QSQLite2Driver* driver = new QSQLite2Driver();
        return driver;
    }
    return 0;
}

QStringList QSQLite2DriverPlugin::keys() const
{
    QStringList l;
    l  << QLatin1String("QSQLITE2");
    return l;
}

Q_EXPORT_PLUGIN(QSQLite2DriverPlugin)
