/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "objectinspectorview.h"

// components
#include <objectinspector.h>

// sdk
#include <abstractformeditor.h>

ObjectInspectorView::ObjectInspectorView(AbstractFormEditor *core, QWidget *parent)
    : QMainWindow(parent, Qt::WStyle_Tool),
      m_core(core)
{
    setWindowTitle(tr("Object Inspector"));

    ObjectInspector *editor = new ObjectInspector(core, this);
    setCentralWidget(editor);

    core->setObjectInspector(editor);

    (void) statusBar();
}

ObjectInspectorView::~ObjectInspectorView()
{
}

void ObjectInspectorView::hideEvent(QHideEvent *ev)
{
    emit visibilityChanged(isVisible());
    QMainWindow::hideEvent(ev);
}

void ObjectInspectorView::showEvent(QShowEvent *ev)
{
    emit visibilityChanged(isVisible());
    QMainWindow::showEvent(ev);
}
