/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qdesigner_formbuilder.h"

#include <container.h>
#include <customwidget.h>
#include <pluginmanager.h>
#include <qextensionmanager.h>
#include <abstractformeditor.h>

#include <QWidget>

QDesignerFormBuilder::QDesignerFormBuilder(AbstractFormEditor *core)
    : m_core(core)
{
    Q_ASSERT(m_core);
    
    PluginManager pluginManager;
    
    m_customFactory.clear();
    QStringList plugins = pluginManager.registeredPlugins();
    
    foreach (QString plugin, plugins) {
        QObject *o = pluginManager.instance(plugin);
        
        if (ICustomWidget *c = qt_cast<ICustomWidget*>(o)) {
            if (!c->isInitialized())
                c->initialize(m_core);
                
            m_customFactory.insert(c->name(), c);
        }
    }
}

QWidget *QDesignerFormBuilder::createWidget(const QString &widgetName, QWidget *parentWidget, const QString &name)
{
    if (ICustomWidget *c = m_customFactory.value(widgetName)) {
        QWidget *widget = c->createWidget(parentWidget);
        widget->setObjectName(name);
        return widget;
    }
    
    QWidget *widget = FormBuilder::createWidget(widgetName, parentWidget, name);
    if (!widget) {
        qWarning("failed to create a widget for type %s", widgetName.latin1());
        widget = new QWidget(parentWidget);
        widget->setObjectName(name);
    }
    
    return widget;
}

bool QDesignerFormBuilder::addItem(DomWidget *ui_widget, QWidget *widget, QWidget *parentWidget)
{
    if (FormBuilder::addItem(ui_widget, widget, parentWidget))
        return true;
        
    if (IContainer *container = qt_extension<IContainer*>(m_core->extensionManager(), parentWidget)) {
        container->addWidget(widget);
        return true;
    }
    
    return false;
}
