/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef SPACER_H
#define SPACER_H

#include "shared_global.h"

#include <QWidget>

class AbstractFormWindow;

class QT_SHARED_EXPORT Spacer: public QWidget
{
    Q_OBJECT

    Q_ENUMS(SizeType)

    Q_PROPERTY(Qt::Orientation orientation READ orientation WRITE setOrientation)
    Q_PROPERTY(SizeType sizeType READ sizeType WRITE setSizeType)
    Q_PROPERTY(QSize sizeHint READ sizeHint WRITE setSizeHint DESIGNABLE true STORED true)

private:
    enum { HSize = 6, HMask = 0x3f, VMask = HMask << HSize,
           MayGrow = 1, ExpMask = 2, MayShrink = 4 };

public:
    enum SizeType { Fixed = 0,
                    Minimum = MayGrow,
                    Maximum = MayShrink,
                    Preferred = MayGrow | MayShrink,
                    MinimumExpanding = MayGrow | ExpMask,
                    Expanding = MayGrow | MayShrink | ExpMask,
                    Ignored = ExpMask /* magic value */ };

    Spacer(QWidget *parent = 0);

    QSize minimumSize() const;

    QSize sizeHint() const;
    void setSizeHint(const QSize &s);

    Spacer::SizeType sizeType() const;
    void setSizeType(Spacer::SizeType t);

    Qt::Alignment alignment() const;
    Qt::Orientation orientation() const;

    void setOrientation(Qt::Orientation o);
    void setInteraciveMode(bool b) { interactive = b; };

protected:
    void paintEvent(QPaintEvent *e);
    void resizeEvent(QResizeEvent* e);
    void updateMask();

private:
    AbstractFormWindow *m_formWindow;
    Qt::Orientation orient;
    bool interactive;
    QSize sh;
};

#endif // SPACER_H
