/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef CUSTOMWIDGET_H
#define CUSTOMWIDGET_H

#include <extension.h>
#include <QObject>
#include <QString>
#include <QIcon>

class QWidget;
class AbstractFormEditor;

struct ICustomWidget
{
    virtual ~ICustomWidget() {}

    virtual QString name() const = 0;
    virtual QString group() const = 0;
    virtual QString toolTip() const = 0;
    virtual QString whatsThis() const = 0;
    virtual QString includeFile() const = 0;
    virtual QIcon icon() const = 0;

    virtual bool isContainer() const = 0;
    virtual bool isForm() const = 0;

    virtual QWidget *createWidget(QWidget *parent) = 0;

//
// IDesignerCustomWidget
//    
    virtual bool isInitialized() const 
    { return false; }
    
    virtual void initialize(AbstractFormEditor *core) 
    { Q_UNUSED(core); }
    
    virtual QString codeTemplate() const
    { return QString::null; }
};

Q_DECLARE_EXTENSION_INTERFACE(ICustomWidget, "http://trolltech.com/Qt/IDE/CustomWidget")

#endif // CUSTOMWIDGET_H
