/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the porting application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "rulesfromxml.h"
#include <QFile>
#include <iostream>

using std::cout;
using std::endl;


RulesFromXml::RulesFromXml(QString xmlFilePath)
:isParsed(false)
{
    QFile f(xmlFilePath);
    if(!f.open(QIODevice::ReadOnly)) {
        qFatal("Could not find rule file %s", xmlFilePath.latin1());
    }
    if(!xml.setContent(&f))
        qFatal("Xml parsing failed! Error: %s", xml.errorString().latin1());
}

QList<TokenReplacement*> RulesFromXml::getNoPreprocessPortingTokenRules()
{
    if(!isParsed) {
        parseXml();
        isParsed=true;
    }
    
    if(tokenRules.isEmpty()) {
         cout << "Warning: token rules list is empty" << endl;
    }
    return tokenRules;
}

QStringList RulesFromXml::getHeaderList(QtVersion qtVersion)
{
    if(!isParsed) {
       parseXml();
       isParsed=true;
    }
    if(qt3Headers.isEmpty() || qt4Headers.isEmpty()) {
         cout << "Warning: headers list is empty" << endl;
    }
    
    if (qtVersion==Qt3)
        return qt3Headers;
    else //Qt4
        return qt4Headers;
}

QStringList RulesFromXml::getNeededHeaderList()
{    
    if(!isParsed) {
       parseXml();
       isParsed=true;
    }
    
    if(tokenRules.isEmpty()) {
         cout << "Warning: needed Headers list is empty" << endl;
    }
    
    return neededHeaders;
}


void RulesFromXml::parseXml()
{
    int ruleCount = xml["Rules"]["Count"].text().toInt();
    ++ruleCount; //Hack! compensate for off-by-one error somewhere in QtSimpleXml
                  
    //parse InheritsQt first, since ScopedTokenReplacement take this list
    //as a parameter
    for(int rule=0; rule<ruleCount; ++rule) { 
        QtSimpleXml &currentRule = xml["Rules"][rule];
        if(currentRule.attribute("Type")=="InheritsQt") {
            inheritsQtClass << currentRule.text();
        }
    }
   
    for(int rule=0; rule<ruleCount; ++rule) {
        QtSimpleXml &currentRule = xml["Rules"][rule];
        
        if(currentRule.attribute("Type")=="RenamedHeader") {
                      tokenRules.append(new IncludeTokenReplacement(
                     currentRule["Qt3"].text().latin1(),
                     currentRule["Qt4"].text().latin1()));
        } 
        else if(currentRule.attribute("Type")=="RenamedClass" ||
                currentRule.attribute("Type")=="RenamedToken" ) {
            tokenRules.append(new GenericTokenReplacement(
                    currentRule["Qt3"].text().latin1(),
                    currentRule["Qt4"].text().latin1()));
        } 
        else if(currentRule.attribute("Type")=="RenamedEnumvalue" ||
                currentRule.attribute("Type")=="RenamedType" ||
                currentRule.attribute("Type")=="RenamedQtSymbol" ) {
            tokenRules.append(new ScopedTokenReplacement(
                    currentRule["Qt3"].text().latin1(),
                    currentRule["Qt4"].text().latin1(),
                    inheritsQtClass));
        }
        else if(currentRule.attribute("Type")=="NeedHeader") {
            neededHeaders += currentRule["Header"].text();
        }
        else if(currentRule.attribute("Type")=="qt3Header") {
            qt3Headers += currentRule.text();
        }
        else if(currentRule.attribute("Type")=="qt4Header") {
            qt4Headers += currentRule.text();
        }
    }    
}
