/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the porting application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef TOKENREPLACEMENTS_H
#define TOKENREPLACEMENTS_H

#include "lexer.h"    //for TokenStream
#include "textreplacement.h"
#include <QStringList>
#include <QByteArray>

class TokenReplacement
{
public:
    virtual bool doReplace(TokenStream * /*tokenStream*/, TextReplacements &/*textReplacements*/){return false;};
    /*
        returns the replace key for this replacement. Every time a token matches the replace key,
        doReplace() will be called for this TokenReplacement.
    */
    virtual QByteArray getReplaceKey(){return QByteArray();};
    virtual ~TokenReplacement(){};
protected:
    void makeLogEntry(QString group, QString text, TokenStream *tokenStream);
};

/*
    A TokenReplacement that changes #include directives
*/
class IncludeTokenReplacement : public TokenReplacement
{
public:
    IncludeTokenReplacement(QByteArray fromFile, QByteArray toFile);
 //   bool doReplace(QByteArray tokenText, QByteArray &newTokenText);
    bool doReplace(TokenStream *tokenStream, TextReplacements &textReplacements);
private:
    QByteArray fromFile;
    QByteArray toFile;
};

/*
    A TokenReplacement that change any token
*/
class GenericTokenReplacement : public TokenReplacement
{
public:
    GenericTokenReplacement(QByteArray oldToken, QByteArray newToken);
    bool doReplace(TokenStream *tokenStream, TextReplacements &textReplacements);
    QByteArray getReplaceKey();
private:
    QByteArray oldToken;
    QByteArray newToken;
};

/*
   Changes scoped tokens:
   AA::BB -> CC::DD
   oldToken corresponds to the AA::BB part, newToken corresponds CC::DD.
   Since this is a token replacement, the AA part of oldToken is typically
   unknown. This means that we might change tokens named BB that does not belong
   to the AA scope. Ast replacemnts will fix this.

*/
class ScopedTokenReplacement : public TokenReplacement
{
public:
    ScopedTokenReplacement(QByteArray oldToken, QByteArray newToken, const QStringList inheritsQt);
    bool doReplace(TokenStream *tokenStream, TextReplacements &textReplacements);
    QByteArray getReplaceKey();
private:
  //  bool findPreTextToken(QByteArray scopeName, TokenStream *tokenStream);
    int findScopeOperator(TokenStream *tokenStream, int startTokenIndex);
    int getNextScopeToken(TokenStream *tokenStream, int startTokenIndex);
    QByteArray oldToken;
    QByteArray newToken;
    const QStringList inheritsQt; //a list of Qt3 classes that inherits the Qt class
};

#endif
