.TH starpkg "1" "Nov 2002"
.SH NAME
starpkg \- convert a StarPlot data set to StarPlot file format
.SH SYNOPSIS
.BR starpkg " [ \-\-dataset ]"
.I data\-set
.RI "[ \-\-dest " destination
]
.br
.BR starpkg " \-\-recurse"
.I input\-dir
.RI "[ \-\-dest " destination
]
.br
.
.SH DESCRIPTION
.PP
On the StarPlot web site are available some packages of data that include
both an original data file from NASA, and also a  specification file.
These packages are referred to as "data sets", from which
.BR starconvert (1)
can produce a data file in StarPlot format.  For ease of use, this should be
done via the starpkg shell script.
.br
.
.SH USAGE
.PP
Assuming that
.I data\-set
is a valid StarPlot data set (either in tar.gz format or a directory resulting
from uncompressing the tar.gz file), the `starpkg \-\-dataset' command converts
it to a StarPlot-formatted data file.  Note that the `\-\-dataset' flag
is optional, and the name of the input data set may be specified without it.
In order to be a valid StarPlot data set, a directory or tar.gz file must
contain at least a valid specification file whose name ends
with `.spec' and a flat text data file named `catalog.dat'.
.
.PP
If the `\-\-dest' option is omitted,
the default location of the output file is the first of the directories
.IR DATADIR ", " $PWD ", " $HOME
in which the user has write permissions.  If `\-\-dest' is omitted or
.I destination
is a directory, the name of the output file will by default
be ${specfilename%.spec}.stars.  For instance, a data set containing
.I gliese.3.spec
will produce a file named
.IR gliese.3.stars .
.
.PP
The `starpkg \-\-recurse' form of the command executes the above action for
every StarPlot data set contained in
.IR input\-dir ,
placing the resulting StarPlot data files to the directory
.IR destination .
(If the \-\-dest option is omitted, the default destination directory is
chosen as above.)  This form of the starpkg command is most useful
when a new version of StarPlot has been installed and you wish to regenerate
all StarPlot data files from data sets using the new starconvert program.
.
.SH OPTIONS
.br
.TP
\-\-dataset, \-s
Specify a directory or tar.gz file to use as a StarPlot data set.
.TP
\-\-dest, \-d
Specify the file or directory in which to output StarPlot\-format data files.
.TP
\-\-recurse, \-r
Specify a directory in which to search for StarPlot data sets.
.br
.
.SH SEE ALSO
.BR starplot "(1), " starconvert (1)
.SH AUTHOR
.nh
.PP
Copyright \(co 2000\-2002 under the GNU GPL by Kevin B. McCarty 
.IR <kmccarty@princeton.edu> .
The StarPlot web page is at
.IR www.starplot.org .
.
