#include <qslider.h>
#include <qspinbox.h>
#include <qfile.h>
#include <qdir.h>

#include "backlight.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#define FL_IOCTL_STEP_CONTRAST	100

static int setfl(int l)
{
    int bl;
    int fd;
    
    fd = open("/dev/fl", O_WRONLY);
    bl = ioctl(fd, FL_IOCTL_STEP_CONTRAST, l);
    close(fd);

    return 0;
}

Backlight::Backlight(QWidget *parent, const char *name):
    BacklightBase(parent, name)
{
    QFile f(QDir::homeDirPath() + "/Choices/common/backlight");
    if (f.exists()) {
	f.open(IO_ReadOnly);
	QString l = "";
	f.readLine(l, 5);
	f.close();
	int i = l.toInt();
	//qDebug("i= " + QString::number(i));
	if (i == 0) i = 1;
	backlight_slider->setValue(i);
	setfl(i);
    } else {
	int i = 3;
	backlight_slider->setValue(i);
	setfl(i);
    }

    QFile v(QDir::homeDirPath() + "/Choices/common/screenoff");
    if (v.exists()) {
	v.open(IO_ReadOnly);
	QString l = "";
	v.readLine(l, 5);
	v.close();
	int i = l.toInt();
	screenoff_slider->setValue(i);
	//qDebug("i= " + QString::number(i));
	system("xset s " + l);
    } else {
	int i = 60;
	screenoff_slider->setValue(i);
	system("xset s " + QString::number(i));
    }

    QFile v1(QDir::homeDirPath() + "/Choices/common/suspend");
    if (v1.exists()) {
	v1.open(IO_ReadOnly);
	QString l = "";
	v1.readLine(l, 5);
	v1.close();
	int i = l.toInt();
	suspend_slider->setValue(i);
	//qDebug("i= " + QString::number(i));
	system("xset dpms 0 0 " + l);
    } else {
	int i = 2400;
	suspend_slider->setValue(i);
	system("xset dpms 0 0 " + QString::number(i));
    }

}

Backlight::~Backlight()
{
}

void Backlight::apply()
{
    QFile f(QDir::homeDirPath() + "/Choices/common/backlight");
    f.open(IO_WriteOnly);
    QString l = QString::number(backlight_slider->value());
    f.writeBlock(l, l.length());
    f.close();

    QFile f1(QDir::homeDirPath() + "/Choices/common/suspend");
    f1.open(IO_WriteOnly);
    QString l1 = suspend_slider->text();
    f1.writeBlock(l1, l1.length());
    f1.close();
    system("xset dpms 0 0 " + l1);

    QFile v(QDir::homeDirPath() + "/Choices/common/screenoff");
    v.open(IO_WriteOnly);
    l = screenoff_slider->text();
    v.writeBlock(l, l.length());
    v.close();
    system("xset s " + l);
}

void Backlight::new_backlight(int l)
{
//    qDebug("backlight");
    setfl(l);
}

void Backlight::new_screenoff(int t)
{
//    qDebug("screenoff");
}
