/*****************************************************************************
 * channel.h: channel functions and definitions
 *****************************************************************************
 * $Id: channel.h,v 1.9 2004/10/11 19:27:46 pingus77 Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 *  Original code:
 *  channel for Bt848 frame grabber driver
 *
 *  Copyright (C) 1996,97 Marcus Metzler (mocm@thp.uni-koeln.de)
 *
 *  many changes by Gerd Knorr <kraxel@cs.tu-berlin.de>
 *      [ hmm, think by now nearly nothing left from the original code ... ]
 *
 *****************************************************************************/
#ifndef _CHANNEL_H_
#define _CHANNEL_H_

struct CHANNEL
{
  char *name;
  char *key;

  char *cname;            /* name of the channel  */
  int channel;            /* index into tvtuner[] */
  int fine;
  int freq;

  int capture;
  int source;
  int norm;

  int color;
  int bright;
  int hue;
  int contrast;

  Pixmap pixmap;
  Widget button;

  int ckey;

  int deinterlace;
  
  char *subpage;
};

extern struct CHANNEL defaults;
extern struct CHANNEL **channels;
extern int count;
extern int have_mixer;

extern int cur_sender, cur_channel, cur_fine, cur_norm, cur_input, cur_freq;
extern char *cur_subpage;
// values which depend on the norm
extern int cur_maxwidth, cur_maxheight, cur_secam;
extern int cur_maxfpsnum, cur_maxfpsden;

extern int chan_tab;
extern struct STRTAB chan_names[];

int lookup_channel (char *channel);
int get_freq (int i);
int cf2freq (char *name, int fine);

struct CHANNEL *add_channel (char *name);
void hotkey_channel (struct CHANNEL *channel);
void configure_channel (struct CHANNEL *channel);
void del_channel (int nr);

void read_config ();
void read_first ();
void save_config ();
int  load_last_channel(struct CHANNEL *last_channel);
void save_last_channel(int last_channel);
void debug_channel(struct CHANNEL *chan);
void update_channel(struct CHANNEL *dest, struct CHANNEL *src);
void load_memcpy_method(void);
void save_memcpy_method(int method);

/* ----------------------------------------------------------------------- */

extern struct STRTAB booltab[];
extern struct STRTAB captab[];

int str_to_int (char *str, struct STRTAB *tab);
char *int_to_str (int n, struct STRTAB *tab);

#endif // _CHANNEL_H_
